/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.util;

import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.jalbum.component.JProgressManager;
import se.datadosen.jalbum.JAlbumUtilities;
import se.datadosen.jalbum.OperationAbortedException;

public class AbortableBackgroundTask<T> {
    private final JProgressManager pm;
    private final JProgressManager.TaskStatus ts;
    private int millisToPopup = 1000;

    public AbortableBackgroundTask(JProgressManager progressManager, String message) {
        this.pm = progressManager;
        this.ts = new JProgressManager.TaskStatus(message);
        this.ts.setIndeterminate(true);
        this.ts.setStringPainted(false);
    }

    public void removeTaskStatus() {
        this.pm.removeTask(this.ts);
    }

    public void setSubMessage(String message) {
        this.ts.setSubMessage(message);
    }

    public void onAbort(Runnable r) {
        this.ts.onAbort(r);
    }

    public int getMillisToPopup() {
        return this.millisToPopup;
    }

    public void setMillisToPopup(int millisToPopup) {
        this.millisToPopup = millisToPopup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T call(Callable<T> callable) throws Exception, OperationAbortedException {
        ScheduledFuture<?> showTaskStatusFuture = JAlbumUtilities.schedule(() -> {
            this.pm.addTask(this.ts);
            this.pm.startTask(this.ts);
        }, (long)this.millisToPopup, TimeUnit.MILLISECONDS);
        try {
            T t = callable.call();
            return t;
        }
        finally {
            showTaskStatusFuture.cancel(true);
            this.pm.removeTask(this.ts);
        }
    }
}

