/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.undo;

import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import net.jalbum.undo.LocalizedUndoableEdit;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectImpl;
import se.datadosen.jalbum.Msg;

public class UndoableMoveEdit
extends LocalizedUndoableEdit {
    private AlbumObject ao;
    private String oldPath;
    private AlbumObject oldParent;
    private String oldName;
    private int oldPosition = -1;
    private final AlbumObject newParent;
    private final String newName;
    private final int newPosition;

    public UndoableMoveEdit(AlbumObject ao, AlbumObject newParent, String newName, int newPosition) {
        this.ao = ao;
        this.oldParent = ao.getParent();
        this.oldPath = ao.getParent().getPathFromRoot();
        this.oldName = ao.getName();
        AlbumObject parent = ao.getParent();
        if (parent != null) {
            List<AlbumObject> chldrn = parent.getChildren();
            this.oldPosition = chldrn.indexOf(ao);
        }
        this.newParent = newParent;
        this.newName = newName;
        this.newPosition = newPosition;
    }

    @Override
    public String getPresentationName() {
        return Msg.get("edit.moveOf", this.ao);
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        try {
            AlbumObject oldParent = ((AlbumObjectImpl)this.getRoot(this.ao)).getChild(this.oldPath, true);
            if (oldParent == null) {
                throw new NullPointerException("For child " + this.oldPath);
            }
            this.ao.moveTo(oldParent, this.oldName, this.oldPosition);
            oldParent.fireModelChanged();
            this.newParent.fireModelChanged();
        }
        catch (IOException ex) {
            Logger.getLogger(UndoableMoveEdit.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        try {
            this.ao.moveTo(this.newParent, this.newName, this.newPosition);
            this.oldParent.fireModelChanged();
            this.newParent.fireModelChanged();
        }
        catch (IOException ex) {
            Logger.getLogger(AlbumObjectImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private AlbumObject getRoot(AlbumObject ao) {
        AlbumObject parent = ao.getParent();
        if (parent == null) {
            return ao;
        }
        return this.getRoot(parent);
    }
}

