/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.script;

import groovy.lang.GroovyClassLoader;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.Set;
import java.util.regex.Pattern;
import javax.script.ScriptContext;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.codehaus.groovy.jsr223.GroovyScriptEngineImpl;

public class GroovierScriptEngine
extends GroovyScriptEngineImpl {
    private boolean rememberImports = false;
    private final Set<String> imports = new HashSet<String>();
    private CompilerConfiguration config;
    private ScriptEngineFactory factory;
    private static final Pattern tokenSeparator = Pattern.compile("\\s|;");

    public GroovierScriptEngine() {
        this(null, Thread.currentThread().getContextClassLoader(), new CompilerConfiguration());
    }

    public GroovierScriptEngine(ClassLoader parent) {
        this(null, parent, new CompilerConfiguration());
    }

    public GroovierScriptEngine(ScriptEngineFactory factory, ClassLoader parent, CompilerConfiguration config) {
        this.factory = factory;
        this.config = config;
        GroovyClassLoader classLoader = new GroovyClassLoader(parent, config);
        super.setClassLoader(classLoader);
    }

    public CompilerConfiguration getConfig() {
        return this.config;
    }

    public ScriptEngineFactory getFactory() {
        return this.factory;
    }

    public Object eval(String script, ScriptContext ctx) throws ScriptException {
        if (this.rememberImports) {
            this.rememberImports(script);
        }
        return super.eval(script, ctx);
    }

    public boolean isRememberImports() {
        return this.rememberImports;
    }

    public void setRememberImports(boolean rememberImports) {
        this.rememberImports = rememberImports;
    }

    public void addImports(String ... imports) {
        ImportCustomizer ic = null;
        for (String imp : imports) {
            int dotStarIndex;
            String[] tokens;
            if (this.imports.contains(imp)) continue;
            if (ic == null) {
                ic = new ImportCustomizer();
            }
            if ((tokens = tokenSeparator.split(imp))[0].equals("static")) {
                if (tokens.length != 2) continue;
                dotStarIndex = tokens[1].indexOf(".*");
                if (dotStarIndex > 0) {
                    ic.addStaticStars(new String[]{tokens[1].substring(0, dotStarIndex)});
                } else {
                    int lastDotIndex = tokens[1].lastIndexOf(46);
                    if (lastDotIndex >= 0) {
                        ic.addStaticImport(tokens[1].substring(0, lastDotIndex), tokens[1].substring(lastDotIndex + 1));
                    }
                }
            } else {
                dotStarIndex = imp.indexOf(".*");
                if (dotStarIndex > 0) {
                    ic.addStarImports(new String[]{imp.substring(0, dotStarIndex)});
                } else {
                    ic.addImports(new String[]{imp});
                }
            }
            this.imports.add(imp);
        }
        if (ic != null) {
            this.config.addCompilationCustomizers(new CompilationCustomizer[]{ic});
        }
    }

    private void rememberImports(String script) {
        Scanner scanner = new Scanner(script);
        scanner.useDelimiter(tokenSeparator);
        try {
            String token;
            while (scanner.hasNext() && (token = scanner.next()).equals("import")) {
                String nextToken = scanner.next();
                if (nextToken.equals("static")) {
                    this.addImports("static " + scanner.next());
                    continue;
                }
                this.addImports(nextToken);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }
}

