/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.review;

import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.OverlayLayout;
import javax.swing.SwingUtilities;
import net.jalbum.review.JCloseupGrid;
import net.jalbum.review.JMovingPanel;
import net.jalbum.review.JThumbnailStrip;
import se.datadosen.explorer.ImageCache;
import se.datadosen.explorer.JAlbumExplorer;
import se.datadosen.explorer.JAlbumObject;
import se.datadosen.jalbum.JAlbumSite;
import se.datadosen.util.Platform;

public class ReviewMode
extends JFrame {
    JAlbumExplorer explorer;
    private static boolean debugMode = false;
    private static final int MOUSE_MARGIN = 5;
    int currentIndex;
    Dimension screenSize = this.getGraphicsConfiguration().getBounds().getSize();
    ImageCache slideCache = new ImageCache(4, this.screenSize);
    final KeyStroke escape = KeyStroke.getKeyStroke(27, 0);
    final KeyStroke f1 = KeyStroke.getKeyStroke(112, 0);
    JThumbnailStrip thumbStrip;
    JCloseupGrid closeupGrid;
    JSplitPane splitPane;
    JMovingPanel thumbStripPanel = new JMovingPanel();
    public Action quitAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent evt) {
            ReviewMode.this.explorer.explorer.selectionModel.selectMatching(ReviewMode.this.thumbStrip.listSelectedAlbumObjects());
            ReviewMode.this.setVisible(false);
            ReviewMode.this.getGraphicsConfiguration().getDevice().setFullScreenWindow(null);
            ReviewMode.this.slideCache.dispose();
            ReviewMode.this.dispose();
        }
    };
    public Action helpAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent evt) {
            ReviewMode.this.quitAction.actionPerformed(null);
            try {
                BrowserLauncher.openURL(JAlbumSite.getInstance().getHelpUrl() + "/JAlbum/Review");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    };
    public Action homeAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent evt) {
            ReviewMode.this.viewPage(0);
        }
    };
    public Action endAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent evt) {
            ReviewMode.this.viewPage((ReviewMode.this.thumbStrip.getComponentCount() + ReviewMode.this.closeupGrid.getGridSize() - 1) / ReviewMode.this.closeupGrid.getGridSize() - 1);
        }
    };
    public Action pageUpAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent evt) {
            ReviewMode.this.viewPage(ReviewMode.this.closeupGrid.getCurrentPage() - 1);
        }
    };
    public Action pageDownAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent evt) {
            ReviewMode.this.viewPage(ReviewMode.this.closeupGrid.getCurrentPage() + 1);
        }
    };
    private final AWTEventListener awtEventListener = new AWTEventListener(){

        @Override
        public void eventDispatched(AWTEvent e) {
            if (e instanceof MouseEvent) {
                MouseEvent me = (MouseEvent)e;
                Point point = SwingUtilities.convertPoint(me.getComponent(), me.getPoint(), ReviewMode.this.getContentPane());
                Rectangle hotZone = ReviewMode.this.getContentPane().getBounds();
                hotZone.grow(-10, -10);
                hotZone.translate(5, 5);
                ReviewMode.this.closeupGrid.handleGlassPanelVisibility(hotZone.contains(point));
                if (ReviewMode.this.isFocused() && me.getButton() == 0) {
                    ReviewMode.this.thumbStripPanel.handleVisibility(point);
                }
            }
        }
    };

    public ReviewMode(JAlbumExplorer explorer) {
        super(explorer.getGraphicsConfiguration());
        this.explorer = explorer;
        this.init();
    }

    private void init() {
        Optional<JAlbumObject> jaoOpt;
        this.slideCache.setApplyFilters(true);
        if (debugMode) {
            this.setSize(1000, 800);
        } else {
            this.setUndecorated(true);
            this.setSize(this.screenSize);
        }
        ((JPanel)this.getContentPane()).registerKeyboardAction(this.quitAction, "escapeAction", this.escape, 2);
        this.getRootPane().registerKeyboardAction(this.helpAction, "helpAction", this.f1, 2);
        this.thumbStrip = new JThumbnailStrip(this);
        this.thumbStrip.selectionModel.selectMatching(this.explorer.explorer.listSelectedAlbumObjects());
        if (this.thumbStrip.selectionModel.getSelectionCount() == 0 && this.thumbStrip.getComponentCount() > 0) {
            JAlbumObject first = (JAlbumObject)this.thumbStrip.getComponent(0);
            first.setSelected(true);
        }
        if ((jaoOpt = this.thumbStrip.objects().filter(jao -> jao.isSelected()).findFirst()).isPresent()) {
            this.thumbStrip.selectionModel.setFocusedObject(jaoOpt.get());
            this.thumbStrip.selectionModel.lastClickedIndex = this.thumbStrip.selectionModel.indexOf(jaoOpt.get());
        }
        this.closeupGrid = new JCloseupGrid(this);
        JScrollPane thumbScroller = new JScrollPane(this.thumbStrip, 21, 30);
        thumbScroller.getHorizontalScrollBar().setUnitIncrement(20);
        this.thumbStrip.configureKeys(thumbScroller);
        this.thumbStripPanel.setContent(thumbScroller);
        JPanel glassPanel = new JPanel(new BorderLayout());
        glassPanel.setOpaque(false);
        JLayeredPane layers = new JLayeredPane();
        this.getContentPane().add(layers);
        layers.setLayout(new OverlayLayout(layers));
        glassPanel.add((Component)this.thumbStripPanel, "South");
        layers.add((Component)glassPanel, JLayeredPane.PALETTE_LAYER);
        layers.add((Component)this.closeupGrid, JLayeredPane.DEFAULT_LAYER);
        this.validate();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ReviewMode.this.dispose();
            }
        });
    }

    @Override
    public void addNotify() {
        super.addNotify();
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.awtEventListener);
        Toolkit.getDefaultToolkit().addAWTEventListener(this.awtEventListener, 48L);
    }

    @Override
    public void removeNotify() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.awtEventListener);
        super.removeNotify();
    }

    @Override
    public void setVisible(boolean visible) {
        if ((Platform.isMac() || Platform.isLinux()) && !debugMode && visible) {
            this.getGraphicsConfiguration().getDevice().setFullScreenWindow(this);
        }
        super.setVisible(visible);
    }

    private static Rectangle unionBounds(List<? extends JComponent> comps) {
        Rectangle rect = null;
        for (JComponent jComponent : comps) {
            if (rect == null) {
                rect = new Rectangle(jComponent.getBounds());
            }
            Rectangle.union(rect, jComponent.getBounds(), rect);
        }
        return rect;
    }

    void viewPage(int page) {
        int gridSize = this.closeupGrid.getGridSize();
        int selStart = page * gridSize;
        int selEnd = page * gridSize + gridSize - 1;
        if ((selStart = Math.max(0, selStart)) <= (selEnd = Math.min(this.thumbStrip.getComponentCount() - 1, selEnd))) {
            this.thumbStrip.selectionModel.selectRange(selStart, selEnd);
            this.thumbStrip.scrollRectToVisible(ReviewMode.unionBounds(this.thumbStrip.selectionModel.getSelectedObjects()));
        }
    }
}

