/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.review;

import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import net.jalbum.review.JCloseupPanel;
import net.jalbum.review.ReviewMode;
import se.datadosen.explorer.ExplorerSelectionModel;
import se.datadosen.explorer.JAlbumExplorer;
import se.datadosen.explorer.JAlbumObject;
import se.datadosen.explorer.JAlbumObjectsPanel;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.PermissionException;
import se.datadosen.util.LambdaAction;
import se.datadosen.util.Platform;

class JThumbnailStrip
extends JAlbumObjectsPanel {
    MouseAdapter mouseOnComponentAdapter = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent e) {
            JAlbumObject jao = (JAlbumObject)e.getComponent();
            JThumbnailStrip.this.selectionModel.wasAlreadySelected = jao.isSelected();
            if (JAlbumExplorer.isPortableControlDown(e) && !e.isPopupTrigger()) {
                jao.setSelected(!jao.isSelected());
            } else if (e.isShiftDown()) {
                int clickedIndex = JThumbnailStrip.this.selectionModel.indexOf(jao);
                JThumbnailStrip.this.selectionModel.selectRange(JThumbnailStrip.this.selectionModel.lastClickedIndex, clickedIndex);
            } else {
                JThumbnailStrip.this.selectionModel.selectSingle(jao);
            }
            JThumbnailStrip.this.selectionModel.setFocusedObject(jao);
            int index = JThumbnailStrip.this.indexOf(jao);
            if (++index < JThumbnailStrip.this.getComponentCount()) {
                JAlbumObject next = (JAlbumObject)JThumbnailStrip.this.getComponent(index);
                JThumbnailStrip.this.reviewMode.slideCache.preload(next.ao);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            JAlbumObject jao = (JAlbumObject)e.getComponent();
            if (!jao.isFocusOwner()) {
                jao.requestFocusInWindow();
            }
        }
    };
    private final ReviewMode reviewMode;

    @Override
    public Config.LabelType getLabelType() {
        return Config.LabelType.fileName;
    }

    JThumbnailStrip(ReviewMode reviewMode) {
        super(reviewMode.explorer);
        this.reviewMode = reviewMode;
        this.setIconScale(0.6);
        reviewMode.explorer.explorer.objects().filter(jao -> jao.isVisible() && jao.ao.hasDisplayableImage()).map(jao -> jao.ao).forEach(ao -> {
            JAlbumObject jao = new JAlbumObject((AlbumObject)ao, this);
            jao.addMouseListener(this.mouseOnComponentAdapter);
            this.add(jao);
        });
        this.validate();
    }

    @Override
    protected MouseAdapter getMouseOnComponentAdapter() {
        return this.mouseOnComponentAdapter;
    }

    @Override
    protected void go(ExplorerSelectionModel.Direction dir, ActionEvent e) {
        if (dir == ExplorerSelectionModel.Direction.PAGE_UP || dir == ExplorerSelectionModel.Direction.PAGE_DOWN && this.getVisibleObjects().size() == 0) {
            return;
        }
        JAlbumObject focused = this.selectionModel.getFocusedObject();
        if (focused != null) {
            JAlbumObject jao = this.selectionModel.getNeighbourObject(focused, dir);
            JAlbumObject next = this.selectionModel.getNeighbourObject(jao, dir);
            this.reviewMode.slideCache.preload(next.ao);
            MouseEvent me = new MouseEvent(jao, 0, e.getWhen(), e.getModifiers(), 0, 0, 1, false);
            this.scrollRectToVisible(jao.getBounds());
            this.getMouseOnComponentAdapter().mousePressed(me);
        }
    }

    void goTo(int index, ActionEvent ae) {
        index = this.ensureWithinBounds(index);
        JAlbumObject jao = (JAlbumObject)this.getComponent(index);
        if (index > 0) {
            JAlbumObject previous = (JAlbumObject)this.getComponent(index - 1);
            this.reviewMode.slideCache.preload(previous.ao);
        }
        if (index < this.getComponentCount() - 1) {
            JAlbumObject next = (JAlbumObject)this.getComponent(index + 1);
            this.reviewMode.slideCache.preload(next.ao);
        }
        this.scrollRectToVisible(jao.getBounds());
        if ((ae.getModifiers() & 1) != 0) {
            int clickedIndex = this.selectionModel.indexOf(jao);
            this.selectionModel.selectRange(this.selectionModel.lastClickedIndex, clickedIndex);
        } else {
            this.selectionModel.selectSingle(jao);
        }
    }

    @Override
    public void configureKeys(JScrollPane explorerScrollPane) {
        super.configureKeys(explorerScrollPane);
        InputMap im = explorerScrollPane.getInputMap(1);
        im.put(KeyStroke.getKeyStroke(45, 0), "toggleIncluded");
        ActionMap am = explorerScrollPane.getActionMap();
        am.put("toggleIncluded", new LambdaAction(() -> this.toggleIncluded()));
        am.put("home", this.reviewMode.homeAction);
        am.put("end", this.reviewMode.endAction);
        am.put("pageUp", this.reviewMode.pageUpAction);
        am.put("pageDown", this.reviewMode.pageDownAction);
    }

    void deleteImage(JCloseupPanel panel) {
        AlbumObject ao = panel.getAO();
        AlbumObject folder = ao.getParent();
        if (!ao.isLink()) {
            if (Platform.isMac()) {
                this.getGraphicsConfiguration().getDevice().setFullScreenWindow(null);
            }
            int answer = JOptionPane.showConfirmDialog(panel, Msg.get("slideshow.deleteMessage"), Msg.get("slideshow.deleteTitle"), 0, 2);
            if (Platform.isMac()) {
                this.getGraphicsConfiguration().getDevice().setFullScreenWindow(SwingUtilities.getWindowAncestor(this));
            }
            if (answer != 0) {
                return;
            }
        }
        try {
            JAlbumObject jao = this.getJAlbumObject(ao);
            jao.setSelected(false);
            int index = this.indexOf(jao);
            ao.delete();
            this.remove(index);
            this.validate();
            if (this.selectionModel.getSelectedObjects().isEmpty()) {
                if (index >= this.getComponentCount()) {
                    --index;
                }
                if (index >= 0) {
                    jao = (JAlbumObject)this.getComponent(index);
                    this.selectionModel.selectSingle(jao);
                }
            }
        }
        catch (IOException | PermissionException ex) {
            Logger.getLogger(ReviewMode.class.getName()).log(Level.SEVERE, null, ex);
        }
        folder.fireModelChanged();
    }

    private int ensureWithinBounds(int index) {
        if (index < 0) {
            index = 0;
        } else if (index >= this.getComponentCount()) {
            index = this.getComponentCount() - 1;
        }
        return index;
    }
}

