/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.review;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import javafx.beans.binding.BooleanExpression;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.OverlayLayout;
import net.jalbum.component.JImageComponent;
import net.jalbum.component.JZoomControlPanel;
import net.jalbum.component.JZoomScrollPane;
import net.jalbum.review.JCameraInfoPanel;
import net.jalbum.review.ReviewMode;
import se.datadosen.component.JFadePanel;
import se.datadosen.component.JGlassButton;
import se.datadosen.component.JProgressSpinner;
import se.datadosen.component.JRatingSlider;
import se.datadosen.component.RiverLayout;
import se.datadosen.explorer.JAlbumObject;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumSynchronizer;
import se.datadosen.jalbum.Flag;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.Msg;
import se.datadosen.util.Debug;
import se.datadosen.util.LambdaAction;
import se.datadosen.util.Platform;
import se.datadosen.util.annotations.ToolTipText;

final class JCloseupPanel
extends JLayeredPane
implements PropertyChangeListener {
    private static final Icon excludeIcon = Icons.get("exclude-64", 64);
    JZoomScrollPane imageScrollPane = new JZoomScrollPane(){

        @Override
        protected void paintChildren(Graphics g) {
            super.paintChildren(g);
            if (JCloseupPanel.this.ao != null && !JCloseupPanel.this.ao.isIncluded()) {
                Dimension dim = new Dimension(excludeIcon.getIconWidth(), excludeIcon.getIconHeight());
                excludeIcon.paintIcon(this, g, (this.getWidth() - dim.width) / 2, (this.getHeight() - dim.height) / 2);
            }
        }
    };
    JImageComponent imageComp = this.imageScrollPane.getImageComponent();
    JFadePanel glassPanel = new JFadePanel();
    @ToolTipText(value="edit.rating")
    JRatingSlider rating;
    final KeyStroke escape;
    final KeyStroke t;
    final KeyStroke f;
    final KeyStroke delete;
    final KeyStroke backspace;
    final KeyStroke cmdBackspace;
    final KeyStroke home;
    final KeyStroke end;
    static final KeyStroke space = KeyStroke.getKeyStroke(32, 0);
    static final KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
    @ToolTipText(value="slideshow.folderThumbToolTip")
    public Action toggleFolderThumbAction;
    @ToolTipText(value="slideshow.flagToolTip")
    public Action toggleFlagAction;
    @ToolTipText(value="slideshow.excludeToolTip")
    public Action toggleIncludeAction;
    @ToolTipText(value="slideshow.deleteToolTip")
    public Action deleteAction;
    @ToolTipText(value="slideshow.singleModeToolTip")
    public Action singleModeAction;
    @ToolTipText(value="review.leaveTooltip")
    public Action quitSlideShowAction;
    @ToolTipText(value="slideshow.firstImageToolTip")
    public Action firstImageAction;
    @ToolTipText(value="slideshow.previousImageToolTip")
    public Action previousImageAction;
    @ToolTipText(value="slideshow.nextImageToolTip")
    public Action nextImageAction;
    @ToolTipText(value="slideshow.lastImageToolTip")
    public Action lastImageAction;
    JButton firstButton;
    JButton previousButton;
    JButton singleModeButton;
    JButton quitButton;
    JButton nextButton;
    JButton lastButton;
    JButton folderthumb;
    JButton flag;
    JButton exclude;
    JButton deleteB;
    JProgressSpinner spinner;
    JCameraInfoPanel infoPanel;
    private final ReviewMode reviewMode;
    private AlbumObject ao;
    int index;

    JCloseupPanel(ReviewMode rm, AlbumObject ao) {
        this.imageComp.setScaleToMaxSize(true);
        this.rating = new JRatingSlider(5, Icons.get("star-0-30", 36), Icons.get("star-1-30", 36));
        this.escape = KeyStroke.getKeyStroke(27, 0);
        this.t = KeyStroke.getKeyStroke(84, 0);
        this.f = KeyStroke.getKeyStroke(70, 0);
        this.delete = KeyStroke.getKeyStroke(127, 0);
        this.backspace = KeyStroke.getKeyStroke(8, 0);
        this.cmdBackspace = KeyStroke.getKeyStroke(8, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx());
        this.home = KeyStroke.getKeyStroke(36, 0);
        this.end = KeyStroke.getKeyStroke(35, 0);
        this.toggleFolderThumbAction = new AbstractAction(){
            {
                this.putValue("AcceleratorKey", JCloseupPanel.this.t);
                this.putValue("SmallIcon", Icons.get("favorite-0-30"));
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                JCloseupPanel.this.setAsFolderThumbnail();
            }
        };
        this.toggleFlagAction = new AbstractAction(){
            {
                this.putValue("AcceleratorKey", JCloseupPanel.this.t);
                this.putValue("SmallIcon", Flag.NoFlag.getIcon(30, true, Color.lightGray));
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                JCloseupPanel.this.cycleFlag();
            }
        };
        this.toggleIncludeAction = new AbstractAction(){
            {
                this.putValue("SmallIcon", Icons.get("exclude-0-30"));
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                boolean include = !JCloseupPanel.this.ao.isIncluded();
                AlbumSynchronizer sync = new AlbumSynchronizer(JCloseupPanel.this.reviewMode.explorer.parent.engine);
                try {
                    if (!include) {
                        sync.delete(JCloseupPanel.this.ao);
                    }
                    JCloseupPanel.this.ao.setIncluded(include);
                }
                catch (IOException ex) {
                    Debug.showFriendlyErrorDialog(JCloseupPanel.this, ex);
                }
            }
        };
        this.deleteAction = new AbstractAction(){
            {
                this.putValue("AcceleratorKey", Platform.isMac() ? JCloseupPanel.this.cmdBackspace : JCloseupPanel.this.delete);
                this.putValue("SmallIcon", Icons.get("delete-30"));
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (JCloseupPanel.this.ao != null) {
                    JCloseupPanel.this.reviewMode.thumbStrip.deleteImage(JCloseupPanel.this);
                }
            }
        };
        this.singleModeAction = new AbstractAction(){
            {
                this.putValue("SmallIcon", Icons.get("compare-mode-single", 30));
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                JCloseupPanel.this.singleView();
            }
        };
        this.quitSlideShowAction = new AbstractAction(){
            {
                this.putValue("SmallIcon", Icons.get("explore-white", 30));
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                JCloseupPanel.this.reviewMode.quitAction.actionPerformed(evt);
            }
        };
        this.firstImageAction = new AbstractAction(){
            {
                this.putValue("AcceleratorKey", JCloseupPanel.this.home);
                this.putValue("SmallIcon", Icons.get("first-30"));
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                JCloseupPanel.this.reviewMode.thumbStrip.goTo(0, evt);
            }
        };
        this.previousImageAction = new AbstractAction(){
            {
                this.putValue("SmallIcon", Icons.get("previous-30"));
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                JCloseupPanel.this.reviewMode.thumbStrip.goTo(JCloseupPanel.this.index - 1, evt);
            }
        };
        this.nextImageAction = new AbstractAction(){
            {
                this.putValue("SmallIcon", Icons.get("next-30"));
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                JCloseupPanel.this.reviewMode.thumbStrip.goTo(JCloseupPanel.this.index + 1, evt);
            }
        };
        this.lastImageAction = new AbstractAction(){
            {
                this.putValue("AcceleratorKey", JCloseupPanel.this.end);
                this.putValue("SmallIcon", Icons.get("last-30"));
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                JCloseupPanel.this.reviewMode.thumbStrip.goTo(JCloseupPanel.this.reviewMode.thumbStrip.getComponentCount() - 1, evt);
            }
        };
        this.firstButton = this.createGlassButton(this.firstImageAction);
        this.previousButton = this.createGlassButton(this.previousImageAction);
        this.singleModeButton = this.createGlassButton(this.singleModeAction);
        this.quitButton = this.createGlassButton(this.quitSlideShowAction);
        this.nextButton = this.createGlassButton(this.nextImageAction);
        this.lastButton = this.createGlassButton(this.lastImageAction);
        this.folderthumb = this.createGlassButton(this.toggleFolderThumbAction);
        this.flag = this.createGlassButton(this.toggleFlagAction);
        this.exclude = this.createGlassButton(this.toggleIncludeAction);
        this.deleteB = this.createGlassButton(this.deleteAction);
        this.spinner = new JProgressSpinner(38);
        this.infoPanel = new JCameraInfoPanel();
        this.reviewMode = rm;
        this.init();
        Msg.setTexts(this);
        this.setAO(ao);
    }

    AlbumObject getAO() {
        return this.ao;
    }

    void setAO(AlbumObject ao) {
        if (ao != this.ao) {
            if (this.ao != null) {
                this.ao.removePropertyChangeListener(this);
            }
            if (ao != null) {
                ao.addPropertyChangeListener(this);
                this.index = this.reviewMode.thumbStrip.indexOf(ao);
            } else {
                this.index = 0;
            }
            this.ao = ao;
            this.setFocusable(ao != null);
            this.updateVisuals();
        }
        this.updateButtonStates();
    }

    void updateButtonStates() {
        boolean singleMode = this.reviewMode.closeupGrid.getGridSize() == 1;
        this.singleModeButton.setVisible(!singleMode);
        this.firstButton.setVisible(singleMode);
        this.previousButton.setVisible(singleMode);
        this.quitButton.setVisible(singleMode);
        this.nextButton.setVisible(singleMode);
        this.lastButton.setVisible(singleMode);
        if (singleMode) {
            this.firstImageAction.setEnabled(this.index > 0);
            this.previousImageAction.setEnabled(this.index > 0);
            this.nextImageAction.setEnabled(this.index < this.reviewMode.thumbStrip.getComponentCount() - 1);
            this.lastImageAction.setEnabled(this.index < this.reviewMode.thumbStrip.getComponentCount() - 1);
        }
    }

    private void updateVisuals() {
        try {
            this.infoPanel.setAO(this.ao);
            if (this.ao != null) {
                this.imageComp.setImageProvider(suggestedDim -> this.ao.loadImage(true, suggestedDim, true));
                if (this.reviewMode.slideCache.contains(this.ao)) {
                    this.imageComp.setImage(this.reviewMode.slideCache.getImage(this.ao), this.ao.getSize(true));
                } else {
                    this.imageComp.setImageAsync(dim -> this.reviewMode.slideCache.getImage(this.ao), this.ao.getSize(true));
                }
                this.updateRating(Math.max(this.ao.getRating(), 0));
                this.updateFlag(this.ao.getFlag());
                this.updateHeart();
                this.updateInclude();
            } else {
                this.imageComp.setImage(null);
                this.imageComp.setImageProvider(null);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
    }

    private void singleView() {
        if (this.ao != null) {
            JAlbumObject jao = this.reviewMode.thumbStrip.getJAlbumObject(this.ao);
            if (jao == null) {
                throw new RuntimeException("jao null");
            }
            this.reviewMode.thumbStrip.selectionModel.selectSingle(jao);
        }
    }

    void init() {
        this.glassPanel.setDimmed(true);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                JCloseupPanel.this.glassPanel.setDimmed(false);
            }

            @Override
            public void focusLost(FocusEvent e) {
                JCloseupPanel.this.glassPanel.setDimmed(true);
            }
        });
        MouseAdapter ma = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && (e.getModifiersEx() & 0x340) == 0) {
                    JCloseupPanel.this.singleView();
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (!JCloseupPanel.this.isFocusOwner()) {
                    JCloseupPanel.this.requestFocusInWindow();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                JCloseupPanel.this.requestFocusInWindow();
            }
        };
        this.imageScrollPane.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        this.imageScrollPane.getViewport().addMouseMotionListener(ma);
        this.imageScrollPane.getViewport().addMouseListener(ma);
        InputMap im = this.getInputMap();
        im.put(KeyStroke.getKeyStroke('0'), "unrated");
        im.put(KeyStroke.getKeyStroke('1'), "1rated");
        im.put(KeyStroke.getKeyStroke('2'), "2rated");
        im.put(KeyStroke.getKeyStroke('3'), "3rated");
        im.put(KeyStroke.getKeyStroke('4'), "4rated");
        im.put(KeyStroke.getKeyStroke('5'), "5rated");
        im.put(KeyStroke.getKeyStroke('6'), "select");
        im.put(KeyStroke.getKeyStroke('7'), "second");
        im.put(KeyStroke.getKeyStroke('8'), "approved");
        im.put(KeyStroke.getKeyStroke('9'), "review");
        im.put(this.f, "toggleFlag");
        im.put(this.t, "toggleFolderThumbnail");
        im.put(KeyStroke.getKeyStroke('-'), "toggleIncluded");
        im.put(this.delete, "delete");
        im.put(this.backspace, "delete");
        im.put(this.cmdBackspace, "delete");
        im.put(space, "singleImage");
        ActionMap am = this.getActionMap();
        am.put("unrated", new LambdaAction(() -> this.setRating(0)));
        am.put("1rated", new LambdaAction(() -> this.setRating(1)));
        am.put("2rated", new LambdaAction(() -> this.setRating(2)));
        am.put("3rated", new LambdaAction(() -> this.setRating(3)));
        am.put("4rated", new LambdaAction(() -> this.setRating(4)));
        am.put("5rated", new LambdaAction(() -> this.setRating(5)));
        am.put("select", new LambdaAction(() -> this.setFlag(Flag.Select)));
        am.put("second", new LambdaAction(() -> this.setFlag(Flag.Second)));
        am.put("approved", new LambdaAction(() -> this.setFlag(Flag.Approved)));
        am.put("review", new LambdaAction(() -> this.setFlag(Flag.Review)));
        am.put("toggleFlag", this.toggleFlagAction);
        am.put("toggleFolderThumbnail", this.toggleFolderThumbAction);
        am.put("toggleIncluded", this.toggleIncludeAction);
        am.put("delete", this.deleteAction);
        am.put("singleImage", this.singleModeAction);
        im.put(KeyStroke.getKeyStroke(36, 64), "first");
        im.put(KeyStroke.getKeyStroke(35, 64), "last");
        im.put(KeyStroke.getKeyStroke(37, 64), "previous");
        im.put(KeyStroke.getKeyStroke(39, 64), "next");
        im.put(KeyStroke.getKeyStroke(37, 0), "previous");
        im.put(KeyStroke.getKeyStroke(39, 0), "next");
        im.put(KeyStroke.getKeyStroke(33, 0), "pageUp");
        im.put(KeyStroke.getKeyStroke(34, 0), "pageDown");
        im.put(KeyStroke.getKeyStroke(36, 0), "home");
        im.put(KeyStroke.getKeyStroke(35, 0), "end");
        am.put("first", this.firstImageAction);
        am.put("last", this.lastImageAction);
        am.put("previous", this.previousImageAction);
        am.put("next", this.nextImageAction);
        am.put("home", this.reviewMode.homeAction);
        am.put("end", this.reviewMode.endAction);
        am.put("pageUp", this.reviewMode.pageUpAction);
        am.put("pageDown", this.reviewMode.pageDownAction);
        this.rating.addChangeListener(e1 -> {
            try {
                this.ao.setRating(this.rating.getValue());
            }
            catch (IOException ex) {
                Debug.showFriendlyErrorDialog(this, ex);
            }
        });
        this.spinner.setModel((BooleanExpression)this.imageComp.workingProperty);
        this.setLayout(new OverlayLayout(this));
        JPanel starPanel = new JPanel(new FlowLayout(3));
        starPanel.setOpaque(false);
        starPanel.add(this.rating);
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        buttonPanel.setAlignmentY(0.5f);
        buttonPanel.setOpaque(false);
        buttonPanel.add(this.firstButton);
        buttonPanel.add(this.previousButton);
        buttonPanel.add(this.singleModeButton);
        buttonPanel.add(this.quitButton);
        buttonPanel.add(this.nextButton);
        buttonPanel.add(this.lastButton);
        buttonPanel.add(this.spinner);
        JPanel eastPanel = new JPanel(new FlowLayout(4));
        eastPanel.setOpaque(false);
        eastPanel.add(this.folderthumb);
        eastPanel.add(this.flag);
        eastPanel.add(this.exclude);
        eastPanel.add(this.deleteB);
        this.glassPanel.setOpaque(false);
        Dimension hScrollSize = this.imageScrollPane.getHorizontalScrollBar().getPreferredSize();
        Dimension vScrollSize = this.imageScrollPane.getVerticalScrollBar().getPreferredSize();
        this.glassPanel.setBorder(BorderFactory.createEmptyBorder(16, 28, 16, 28));
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.setOpaque(false);
        northPanel.add((Component)this.rating, "West");
        northPanel.add((Component)buttonPanel, "Center");
        northPanel.add((Component)eastPanel, "East");
        this.glassPanel.add((Component)northPanel, "North");
        JPanel southPanel = new JPanel(new RiverLayout(0, 0));
        southPanel.setOpaque(false);
        southPanel.add("vbottom", this.infoPanel);
        southPanel.add("hfill", Box.createHorizontalGlue());
        JZoomControlPanel zoomControl = new JZoomControlPanel(this.imageScrollPane);
        southPanel.add(zoomControl);
        this.glassPanel.add((Component)southPanel, "South");
        this.add((Component)this.glassPanel, JLayeredPane.PALETTE_LAYER);
        this.add((Component)this.imageScrollPane, JLayeredPane.DEFAULT_LAYER);
        this.glassPanel.setVisible(false);
        this.reviewMode.explorer.getCurrentFolder().addPropertyChangeListener("representingAlbumObject", this);
    }

    private void cycleFlag() {
        try {
            Flag f = this.ao.getFlag();
            int ordinal = 1 + f.ordinal();
            if (ordinal == Flag.values().length) {
                ordinal = 0;
            }
            f = Flag.values()[ordinal];
            this.ao.setFlag(f);
        }
        catch (IOException ex) {
            Debug.showFriendlyErrorDialog(this, ex);
        }
    }

    private void setAsFolderThumbnail() {
        AlbumObject currentFolder = this.ao.getParent();
        if (this.ao == currentFolder.getRepresentingAlbumObject()) {
            currentFolder.setRepresentingAlbumObject(null);
        } else {
            currentFolder.setRepresentingAlbumObject(this.ao);
        }
    }

    private void updateRating(int rating) {
        this.rating.setValue(rating);
    }

    private void updateFlag(Flag flag) {
        this.toggleFlagAction.putValue("SmallIcon", flag.getIcon(30, true, Color.lightGray));
        this.toggleFlagAction.putValue("ShortDescription", flag.toString() + " / " + Msg.get("slideshow.flagToolTip"));
    }

    private void updateInclude() {
        if (this.ao.isIncluded()) {
            this.toggleIncludeAction.putValue("SmallIcon", Icons.get("exclude-0-30"));
        } else {
            this.toggleIncludeAction.putValue("SmallIcon", Icons.get("exclude-1-30"));
        }
    }

    private void updateHeart() {
        if (this.ao != null) {
            if (this.ao.getParent().getRepresentingAlbumObject() == this.ao) {
                this.toggleFolderThumbAction.putValue("SmallIcon", Icons.get("favorite-1-30"));
            } else {
                this.toggleFolderThumbAction.putValue("SmallIcon", Icons.get("favorite-0-30"));
            }
        }
    }

    JGlassButton createGlassButton(Action a) {
        JGlassButton b = new JGlassButton(a);
        b.setBorderRadius(8);
        b.setBorderOpacity(0.15f);
        b.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        return b;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        switch (evt.getPropertyName()) {
            case "properties": {
                this.updateRating(Math.max(this.getAO().getRating(), 0));
                this.updateFlag(this.getAO().getFlag());
                break;
            }
            case "included": {
                this.imageScrollPane.repaint();
                this.updateInclude();
                break;
            }
            case "representingAlbumObject": {
                this.updateHeart();
            }
        }
    }

    void handleGlassPanelVisibility(boolean show) {
        this.glassPanel.setVisible(show && this.ao != null);
    }

    private void setRating(int rating) {
        if (this.ao != null) {
            try {
                this.ao.setRating(rating);
            }
            catch (IOException ex) {
                Debug.showErrorDialog(this, ex);
            }
        }
    }

    private void setFlag(Flag flag) {
        if (this.ao != null) {
            try {
                this.ao.setFlag(flag);
            }
            catch (IOException ex) {
                Debug.showErrorDialog(this, ex);
            }
        }
    }
}

