/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.review;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JLabel;
import net.jalbum.review.JSmokeGlassPanel;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.CameraMetadataPrinter;
import se.datadosen.jalbum.Icons;

public class JCameraInfoPanel
extends JSmokeGlassPanel {
    private static final Icon PIN_ICON = Icons.toolbar("pin");
    private AlbumObject ao;
    private JLabel content = new JLabel();
    private boolean expanded = false;
    private boolean pinned;

    public JCameraInfoPanel() {
        this.content.setFont(this.content.getFont().deriveFont(16.0f));
        this.content.setForeground(Color.white);
        this.content.setOpaque(false);
        this.add(this.content);
        this.setFocusable(false);
        this.content.setFocusable(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                if (!JCameraInfoPanel.this.pinned && !JCameraInfoPanel.this.getBounds().contains(e.getPoint())) {
                    JCameraInfoPanel.this.setExpanded(false);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                JCameraInfoPanel.this.setExpanded(true);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                JCameraInfoPanel.this.setPinned(!JCameraInfoPanel.this.pinned);
                JCameraInfoPanel.this.setExpanded(JCameraInfoPanel.this.pinned);
            }
        });
    }

    public boolean isPinned() {
        return this.pinned;
    }

    public void setPinned(boolean pinned) {
        this.pinned = pinned;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g2d) {
        super.paintComponent(g2d);
        if (this.pinned) {
            PIN_ICON.paintIcon(this, g2d, this.getWidth() - PIN_ICON.getIconWidth() - 8, 8);
        }
    }

    public void setAO(AlbumObject ao) {
        this.ao = ao;
        if (ao != null) {
            if (!this.expanded) {
                this.content.setText(ao.getName() + "  ...");
            } else {
                CameraMetadataPrinter printer = new CameraMetadataPrinter();
                this.content.setText("<html>" + printer.printMetadata(ao, "<br>\n") + "</html>");
            }
        } else {
            this.content.setText("");
        }
        this.getParent().validate();
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        boolean oldExpanded = this.expanded;
        if (expanded != oldExpanded) {
            this.expanded = expanded;
            this.setAO(this.ao);
        }
    }
}

