/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.review;

import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import javax.swing.border.AbstractBorder;

class FlexibleStrokeBorder
extends AbstractBorder {
    private final int KNOB_LENGTH = 40;
    private final BasicStroke top;
    private final BasicStroke left;
    private final BasicStroke bottom;
    private final BasicStroke right;
    private final Paint paint;

    public FlexibleStrokeBorder(BasicStroke top, BasicStroke left, BasicStroke bottom, BasicStroke right, Paint paint) {
        this.top = top;
        this.left = left;
        this.bottom = bottom;
        this.right = right;
        this.paint = paint;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if ((g = g.create()) instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this.top != null) {
                g2d.setColor(c.getBackground());
                int extraKnobLength = 44;
                g2d.fillRect(x + (width - extraKnobLength) / 2, y, extraKnobLength, FlexibleStrokeBorder.widthOf(this.top));
            }
            g2d.setPaint((Paint)(this.paint != null ? this.paint : (c == null ? null : c.getForeground())));
            if (this.top != null) {
                g2d.setStroke(this.top);
                float size = FlexibleStrokeBorder.sizeOf(this.top);
                g2d.draw(new Line2D.Float(x + (width - 40) / 2, (float)y + size / 2.0f, (width - 40) / 2 + 40, (float)y + size / 2.0f));
            }
            if (this.bottom != null) {
                g2d.setStroke(this.bottom);
                float size = FlexibleStrokeBorder.sizeOf(this.bottom);
                g2d.draw(new Line2D.Float(x + (width - 40) / 2, (float)(y + height) - size / 2.0f, (width - 40) / 2 + 40, (float)(y + height) - size / 2.0f));
            }
        }
        g.dispose();
    }

    private static float sizeOf(BasicStroke stroke) {
        return stroke != null ? stroke.getLineWidth() : 0.0f;
    }

    private static int widthOf(BasicStroke stroke) {
        return (int)Math.ceil(FlexibleStrokeBorder.sizeOf(stroke));
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        insets.set(FlexibleStrokeBorder.widthOf(this.top), FlexibleStrokeBorder.widthOf(this.left), FlexibleStrokeBorder.widthOf(this.bottom), FlexibleStrokeBorder.widthOf(this.right));
        return insets;
    }
}

