/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.projectgroups;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import javax.swing.tree.MutableTreeNode;
import net.jalbum.projectgroups.AbstractProjectGroup;
import net.jalbum.projectgroups.FolderProjectGroup;
import net.jalbum.projectgroups.ProjectGroup;
import net.jalbum.projectgroups.ProjectGroups;
import net.jalbum.projectgroups.VirtualProjectGroup;
import se.datadosen.jalbum.AlbumProject;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.MiniConfig;
import se.datadosen.jalbum.RecentProjectFiles;
import se.datadosen.util.IO;

public class RootProjectGroup
extends AbstractProjectGroup {
    private List<ProjectGroup> children = new ArrayList<ProjectGroup>();
    private static final Preferences prefs = Preferences.userNodeForPackage(ProjectGroups.class);
    private static final String DEMO_GROUPS_INSTALLED_KEY = "demoGroupsInstalled";

    public RootProjectGroup() {
        RECENT_PROJECTS_GROUP.setParent(this);
        MY_ALBUMS_GROUP.setParent(this);
        for (String path : ProjectGroups.locations.getPaths()) {
            File f = new File(path);
            if (!f.isDirectory() || !f.exists()) continue;
            ProjectGroup child = ProjectGroup.createInstance(() -> f);
            child.setParent(this);
            this.children.add(child);
        }
        Collections.sort(this.children);
        this.children.add(0, MY_ALBUMS_GROUP);
        this.children.add(0, RECENT_PROJECTS_GROUP);
        if (!prefs.getBoolean(DEMO_GROUPS_INSTALLED_KEY, false)) {
            this.installDemoGroups();
        }
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Override
    public File getLocation() {
        return null;
    }

    @Override
    public List<ProjectGroup> getChildren() {
        return this.children;
    }

    @Override
    public List<AlbumProject> getProjects() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getSourceActions() {
        return 0;
    }

    @Override
    public int getDropAction() {
        return 0;
    }

    @Override
    public void insert(MutableTreeNode child, int index) {
        super.insert(child, index);
        ProjectGroups.locations.addPath(((ProjectGroup)child).getLocation().getAbsolutePath());
    }

    @Override
    public void remove(MutableTreeNode node) {
        ProjectGroups.locations.removePath(((ProjectGroup)node).getLocation().getAbsolutePath());
        super.remove(node);
    }

    @Override
    public void remove(int index) {
        ProjectGroups.locations.removePath(((ProjectGroup)this.getChildAt(index)).getLocation().getAbsolutePath());
        super.remove(index);
    }

    public void forgetInstalledDemoGroups() {
        prefs.remove(DEMO_GROUPS_INSTALLED_KEY);
    }

    public void installDemoGroups() {
        try {
            FolderProjectGroup tests;
            FolderProjectGroup samples;
            VirtualProjectGroup favorites;
            File myAlbums = new File(Config.getConfig().getMyAlbumsLocation());
            if (!myAlbums.exists()) {
                myAlbums.mkdir();
            }
            if (!(favorites = new VirtualProjectGroup(() -> new File(myAlbums, "Favorites"))).getLocation().exists()) {
                favorites.createBackingFiles();
                this.insert(favorites, this.getChildCount());
            }
            if (!(samples = new FolderProjectGroup(() -> new File(myAlbums, "Samples"))).getLocation().exists()) {
                samples.createBackingFiles();
                this.insert(samples, this.getChildCount());
                File samplesDir = new File(MiniConfig.getMiniConfig().progDir, "samples");
                IO.copyDirectoryContent(samplesDir, samples.getLocation(), true);
                for (AlbumProject ap : samples.getProjects()) {
                    RecentProjectFiles.getInstance().addFile(ap.getProjectFile());
                }
            }
            if (!(tests = new FolderProjectGroup(() -> new File(myAlbums, "Tests"))).getLocation().exists()) {
                tests.createBackingFiles();
                this.insert(tests, this.getChildCount());
            }
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
        prefs.putBoolean(DEMO_GROUPS_INSTALLED_KEY, true);
    }
}

