/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.projectgroups;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import javax.swing.Icon;
import net.jalbum.projectgroups.AbstractProjectGroup;
import net.jalbum.projectgroups.ProjectGroup;
import net.jalbum.projectgroups.VirtualGroup;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumObjectFactory;
import se.datadosen.jalbum.AlbumProject;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.RecentProjectFiles;

public class RecentProjectsGroup
extends AbstractProjectGroup
implements VirtualGroup {
    private final AlbumObjectFactory factory = new AlbumObjectFactory(new AlbumBean());
    private static final Icon ICON = Icons.get("project-group-recent", 20);
    protected List<AlbumProject> projects;

    public RecentProjectsGroup() {
        RecentProjectFiles.getInstance().addListener(new RecentProjectFiles.Listener(){

            @Override
            public void projectFileRenamed(RecentProjectFiles list, File oldName, File newName) {
                if (RecentProjectsGroup.this.projects != null) {
                    for (AlbumProject ap : RecentProjectsGroup.this.projects) {
                        if (!ap.getProjectFile().equals(oldName)) continue;
                        ap.setProjectFile(newName);
                        break;
                    }
                }
            }

            @Override
            public void structureChanged(RecentProjectFiles list) {
                RecentProjectsGroup.this.projects = null;
            }

            @Override
            public void projectFileRemoved(RecentProjectFiles list, File name) {
                if (RecentProjectsGroup.this.projects != null) {
                    Iterator<AlbumProject> it = RecentProjectsGroup.this.projects.iterator();
                    while (it.hasNext()) {
                        AlbumProject ap = it.next();
                        if (!ap.getProjectFile().equals(name)) continue;
                        it.remove();
                        break;
                    }
                }
            }

            @Override
            public void projectFileAdded(RecentProjectFiles list, File name) {
                if (RecentProjectsGroup.this.projects != null) {
                    try {
                        RecentProjectsGroup.this.projects.add(0, new AlbumProject(name, RecentProjectsGroup.this.factory));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    @Override
    public boolean getAllowsChildren() {
        return false;
    }

    @Override
    public String getName() {
        return Msg.get("prefs.projectsByUse");
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public Icon getIcon() {
        return ICON;
    }

    @Override
    public File getLocation() {
        return new File(Config.getConfig().getMyAlbumsLocation());
    }

    @Override
    public List<AlbumProject> getProjects() {
        if (this.projects == null) {
            ArrayList<AlbumProject> list = new ArrayList<AlbumProject>();
            List<File> files = RecentProjectFiles.getInstance().getFiles();
            for (int i = files.size() - 1; i >= 0; --i) {
                File f = files.get(i);
                try {
                    list.add(new AlbumProject(f, this.factory));
                    continue;
                }
                catch (Exception ex) {
                    if (!JAlbum.logger.isLoggable(Level.FINEST)) continue;
                    System.err.println("Can't list project " + String.valueOf(f) + ": " + ex.getMessage());
                }
            }
            this.projects = list;
        }
        return this.projects;
    }

    @Override
    public Comparator<AlbumProject> getComparator(Config.ProjectOrdering ordering) {
        Comparator comparator = super.getComparator(ordering);
        if (ordering == Config.ProjectOrdering.projectsByUse) {
            comparator = BY_ADDED_COMPARATOR;
        }
        return comparator;
    }

    @Override
    public List<ProjectGroup> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public int getSourceActions() {
        return 0x40000000;
    }

    @Override
    public int getDropAction() {
        return 0;
    }
}

