/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.projectgroups;

import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import net.jalbum.projectgroups.FolderProjectGroup;
import net.jalbum.projectgroups.JProjectGroupsPanel;
import net.jalbum.projectgroups.ProjectGroup;
import net.jalbum.projectgroups.ProjectGroups;
import net.jalbum.projectgroups.VirtualProjectGroup;
import se.datadosen.jalbum.AlbumProject;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.RecentProjectFiles;

public class ProjectGroupsTreeTransferHandler
extends TransferHandler {
    JProjectGroupsPanel.JProjectGroupsTree tree;
    JAlbumFrame window;

    public ProjectGroupsTreeTransferHandler(JProjectGroupsPanel.JProjectGroupsTree tree, JAlbumFrame window) {
        this.tree = tree;
        this.window = window;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        ProjectGroup group;
        super.canImport(support);
        if (!support.isDataFlavorSupported(AlbumProject.ALBUM_PROJECT_FLAVOR)) {
            return false;
        }
        JTree.DropLocation dl = (JTree.DropLocation)support.getDropLocation();
        ProjectGroup projectGroup = group = dl.getPath() != null ? (ProjectGroup)dl.getPath().getLastPathComponent() : null;
        if (group != null) {
            boolean ok;
            if (group.getLocation().equals(ProjectGroups.getInstance().getCurrentGroup().getLocation())) {
                return false;
            }
            boolean bl = ok = (support.getSourceDropActions() & group.getDropAction()) != 0;
            if (ok) {
                support.setDropAction(group.getDropAction());
            }
            return ok;
        }
        return false;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        super.importData(support);
        if (!this.canImport(support)) {
            return false;
        }
        JTree.DropLocation dl = (JTree.DropLocation)support.getDropLocation();
        try {
            FolderProjectGroup targetGroup = (FolderProjectGroup)dl.getPath().getLastPathComponent();
            AlbumProject ap = (AlbumProject)support.getTransferable().getTransferData(AlbumProject.ALBUM_PROJECT_FLAVOR);
            File fromProjectFile = ap.getProjectFile();
            File from = fromProjectFile.getParentFile();
            File to = new File(targetGroup.getLocation(), from.getName());
            if (to.equals(from)) {
                return false;
            }
            if (targetGroup instanceof VirtualProjectGroup) {
                VirtualProjectGroup tg = (VirtualProjectGroup)targetGroup;
                tg.addProject(ap);
            } else {
                if (this.window.getCurrentProject() == ap && !this.window.closeProject()) {
                    return false;
                }
                if (from.renameTo(to)) {
                    File toProjectFile = new File(to, ap.getProjectFile().getName());
                    RecentProjectFiles.getInstance().replaceFile(fromProjectFile, toProjectFile);
                } else {
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException ex) {
            ex.printStackTrace(System.err);
        }
        catch (UnsupportedFlavorException ex) {
            Logger.getLogger(ProjectGroupsTreeTransferHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(ProjectGroupsTreeTransferHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
        return false;
    }
}

