/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.projectgroups;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import se.datadosen.jalbum.JAlbumUtilities;

class PathDatabase {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final File backingFile;
    private long lastLoaded;
    private final HashSet<String> paths = new HashSet();
    private ScheduledFuture future;

    public PathDatabase(File backingFile) {
        this.backingFile = backingFile;
        try {
            if (backingFile.exists()) {
                this.load();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(PathDatabase.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public Set<String> getPaths() {
        this.ensureFresh();
        return new HashSet<String>(this.paths);
    }

    public boolean addPath(String path) {
        this.ensureFresh();
        boolean res = this.paths.add(path);
        this.scheduleSave();
        return res;
    }

    public boolean removePath(String path) {
        this.ensureFresh();
        boolean res = this.paths.remove(path);
        this.scheduleSave();
        return res;
    }

    public boolean containsPath(String path) {
        this.ensureFresh();
        return this.paths.contains(path);
    }

    private void scheduleSave() {
        if (this.future != null) {
            this.future.cancel(false);
        }
        this.future = JAlbumUtilities.schedule(() -> {
            try {
                this.save();
            }
            catch (IOException ex) {
                Logger.getLogger(PathDatabase.class.getName()).log(Level.SEVERE, null, ex);
            }
        }, 500L, TimeUnit.MILLISECONDS);
    }

    private void load() throws IOException {
        this.paths.clear();
        try (BufferedReader reader = new BufferedReader(new FileReader(this.backingFile, UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                this.paths.add(line);
            }
        }
        this.lastLoaded = System.currentTimeMillis();
    }

    private void save() throws IOException {
        try (PrintWriter writer = new PrintWriter(this.backingFile, UTF_8);){
            for (String path : this.paths) {
                writer.println(path);
            }
        }
    }

    private void ensureFresh() {
        if (this.backingFile.lastModified() > this.lastLoaded) {
            try {
                this.load();
            }
            catch (IOException ex) {
                Logger.getLogger(PathDatabase.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

