/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.projectgroups;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import net.jalbum.projectgroups.JProjectGroupsPanel;
import se.datadosen.util.IdleExecutor;

public class MenuSelector
implements MouseListener,
MouseMotionListener {
    private JProjectGroupsPanel panel;
    private long pressedTime;
    private IdleExecutor expansionTrigger = new IdleExecutor(1200, TimeUnit.MILLISECONDS);
    private boolean autoExpanded;
    AWTEventListener mouseListener = new AWTEventListener(){

        @Override
        public void eventDispatched(AWTEvent event) {
            if (event instanceof MouseEvent) {
                MouseEvent mouseEvent = (MouseEvent)event;
                switch (mouseEvent.getID()) {
                    case 503: {
                        MenuSelector.this.mouseMoved((MouseEvent)event);
                        break;
                    }
                    case 506: {
                        MenuSelector.this.mouseDragged((MouseEvent)event);
                    }
                }
            }
        }
    };

    public MenuSelector(final JProjectGroupsPanel panel) {
        this.panel = panel;
        panel.groupNameButton.addMouseListener(this);
        new DropTarget(panel.groupNameButton, new DropTargetListener(){
            final /* synthetic */ MenuSelector this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void dragEnter(DropTargetDragEvent dtde) {
                if (!panel.isExpanded()) {
                    this.this$0.expansionTrigger.onIdle(() -> {
                        panel.setExpanded(true);
                        this.this$0.autoExpanded = true;
                    });
                }
            }

            @Override
            public void dragOver(DropTargetDragEvent dtde) {
            }

            @Override
            public void dropActionChanged(DropTargetDragEvent dtde) {
            }

            @Override
            public void dragExit(DropTargetEvent dte) {
                this.this$0.expansionTrigger.cancel();
            }

            @Override
            public void drop(DropTargetDropEvent dtde) {
                this.this$0.expansionTrigger.cancel();
            }
        });
        Toolkit.getDefaultToolkit().addAWTEventListener(this.mouseListener, 48L);
    }

    boolean isMenuSelecting() {
        return this.pressedTime != 0L;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.panel.setExpanded(!this.panel.isExpanded());
        if (this.panel.isExpanded()) {
            this.autoExpanded = false;
            this.pressedTime = System.currentTimeMillis();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (System.currentTimeMillis() - this.pressedTime > 350L) {
            this.panel.setExpanded(false);
        }
        this.pressedTime = 0L;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.isMenuSelecting()) {
            Point p = SwingUtilities.convertPoint((Component)e.getSource(), e.getPoint(), this.panel.tree);
            Rectangle treeBounds = new Rectangle(this.panel.tree.getSize());
            if (treeBounds.contains(p)) {
                this.panel.tree.addSelectionPath(this.panel.tree.getClosestPathForLocation(p.x, p.y));
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }
}

