/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.projectgroups;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.EventObject;
import java.util.concurrent.TimeUnit;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DropMode;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.jalbum.UsageCounters;
import net.jalbum.projectgroups.FolderProjectGroup;
import net.jalbum.projectgroups.GroupAlreadyExistsException;
import net.jalbum.projectgroups.GroupNotEmptyException;
import net.jalbum.projectgroups.MenuSelector;
import net.jalbum.projectgroups.ProjectGroup;
import net.jalbum.projectgroups.ProjectGroups;
import net.jalbum.projectgroups.ProjectGroupsTreeTransferHandler;
import net.jalbum.projectgroups.TempFolderProjectGroup;
import net.jalbum.projectgroups.TempVirtualProjectGroup;
import net.jalbum.projectgroups.Temporary;
import net.jalbum.projectgroups.VirtualGroup;
import net.jalbum.projectgroups.VirtualProjectGroup;
import se.datadosen.component.AutoSelectingTreeCellEditor;
import se.datadosen.component.ControlPanel;
import se.datadosen.component.Hour;
import se.datadosen.component.JFileSelector;
import se.datadosen.component.JPlainButton;
import se.datadosen.component.RiverLayout2;
import se.datadosen.explorer.JAlbumExplorer;
import se.datadosen.explorer.JComboButton;
import se.datadosen.explorer.JPropertyPanel;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.JAlbumUtilities;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.MyDesktop;
import se.datadosen.jalbum.TipOfTheDay;
import se.datadosen.util.Debug;
import se.datadosen.util.IO;
import se.datadosen.util.annotations.Icon;
import se.datadosen.util.annotations.Text;
import se.datadosen.util.annotations.ToolTipText;

public class JProjectGroupsPanel
extends JPanel {
    private ProjectGroup clickedNode;
    private static final Preferences prefs = Preferences.userNodeForPackage(JProjectGroupsPanel.class);
    private static final String VIRTUAL_GROUP_KEY = "virtualGroup";
    @Text(value="ui.newProjectGroup")
    Action newProjectSubGroupAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            FolderProjectGroup clickedFolderProjectGroup = (FolderProjectGroup)JProjectGroupsPanel.this.clickedNode;
            TempFolderProjectGroup newGroup = new TempFolderProjectGroup(clickedFolderProjectGroup);
            DefaultTreeModel model = (DefaultTreeModel)JProjectGroupsPanel.this.tree.getModel();
            model.insertNodeInto(newGroup, JProjectGroupsPanel.this.clickedNode, 0);
            TreePath path = newGroup.getTreePath();
            JProjectGroupsPanel.this.tree.expandPath(path);
            JProjectGroupsPanel.this.tree.setSelectionPath(path);
            JProjectGroupsPanel.this.tree.startEditingAtPath(path);
        }
    };
    @Text(value="ui.newVirtualProjectGroup")
    Action newVirtualProjectSubGroupAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            FolderProjectGroup clickedFolderProjectGroup = (FolderProjectGroup)JProjectGroupsPanel.this.clickedNode;
            TempVirtualProjectGroup newGroup = new TempVirtualProjectGroup(clickedFolderProjectGroup);
            DefaultTreeModel model = (DefaultTreeModel)JProjectGroupsPanel.this.tree.getModel();
            model.insertNodeInto(newGroup, JProjectGroupsPanel.this.clickedNode, 0);
            TreePath path = newGroup.getTreePath();
            JProjectGroupsPanel.this.tree.expandPath(path);
            JProjectGroupsPanel.this.tree.setSelectionPath(path);
            JProjectGroupsPanel.this.tree.startEditingAtPath(path);
        }
    };
    @Text(value="edit.showInFilesystem")
    Action showInFileSystemAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            FolderProjectGroup clickedFolderProjectGroup = (FolderProjectGroup)JProjectGroupsPanel.this.clickedNode;
            try {
                MyDesktop.getDesktop().browseFileDirectory(clickedFolderProjectGroup.getLocation());
            }
            catch (UnsupportedOperationException ex) {
                Debug.showFriendlyErrorDialog(JProjectGroupsPanel.this, ex);
            }
        }
    };
    @Text(value="album.removeFromList")
    Action removeGroupAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            FolderProjectGroup clickedFolderProjectGroup = (FolderProjectGroup)JProjectGroupsPanel.this.clickedNode;
            ProjectGroup newSelectedGroup = clickedFolderProjectGroup.getParentGroup();
            if (newSelectedGroup.getParentGroup() == null) {
                newSelectedGroup = ProjectGroup.RECENT_PROJECTS_GROUP;
            }
            JProjectGroupsPanel.this.tree.setSelectionPath(newSelectedGroup.getTreePath());
            ((DefaultTreeModel)JProjectGroupsPanel.this.tree.getModel()).removeNodeFromParent(JProjectGroupsPanel.this.clickedNode);
        }
    };
    @Text(value="edit.renameFile")
    Action renameGroupAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            FolderProjectGroup group = (FolderProjectGroup)JProjectGroupsPanel.this.clickedNode;
            JProjectGroupsPanel.this.tree.startEditingAtPath(group.getTreePath());
        }
    };
    @Text(value="edit.delete")
    Action deleteGroupAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            FolderProjectGroup group = (FolderProjectGroup)JProjectGroupsPanel.this.clickedNode;
            ProjectGroup parent = group.getParentGroup();
            try {
                group.delete();
                if (parent.getParentGroup() == null) {
                    parent = ProjectGroup.RECENT_PROJECTS_GROUP;
                }
                JProjectGroupsPanel.this.tree.setSelectionPath(parent.getTreePath());
                ((DefaultTreeModel)JProjectGroupsPanel.this.tree.getModel()).removeNodeFromParent(JProjectGroupsPanel.this.clickedNode);
            }
            catch (GroupNotEmptyException ex) {
                JOptionPane.showMessageDialog(JProjectGroupsPanel.this, ex.getMessage(), Msg.get("edit.delete"), 0);
            }
        }
    };
    @Text(value="ui.reload")
    Action reloadAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ((FolderProjectGroup)JProjectGroupsPanel.this.clickedNode).invalidate();
            ((DefaultTreeModel)JProjectGroupsPanel.this.tree.getModel()).nodeStructureChanged(JProjectGroupsPanel.this.clickedNode);
        }
    };
    private static final javax.swing.Icon RIGHT_TRIANGLE = Icons.get("triangle-right", 13);
    private static final javax.swing.Icon DOWN_TRIANGLE = Icons.get("triangle-down", 13);
    @ToolTipText(value="ui.newProjectMenu")
    @Icon(value="16x16/plain-plus.svg")
    public Action newProjectAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JProjectGroupsPanel.this.explorer.parent.newProject();
        }
    };
    @ToolTipText(value="ui.newProjectGroup")
    @Icon(value="12x12/plain-plus.svg")
    public Action newProjectGroupAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ControlPanel cp = new ControlPanel();
            cp.add(new JLabel(Msg.get("ui.location")));
            final JTextField locationField = new JTextField(30);
            JFileSelector selector = new JFileSelector(locationField, true);
            File dir = new File(Config.getConfig().getMyAlbumsLocation(), Msg.get("ui.newGroup"));
            selector.setCurrentDirectory(dir);
            selector.setSelectedFile(dir);
            cp.add("tab hfill", locationField);
            locationField.addAncestorListener(new AncestorListener(){
                final /* synthetic */ 10 this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public void ancestorAdded(AncestorEvent event) {
                    locationField.requestFocusInWindow();
                    locationField.setSelectionStart(locationField.getText().lastIndexOf(File.separatorChar) + 1);
                    locationField.setSelectionEnd(locationField.getText().length());
                }

                @Override
                public void ancestorRemoved(AncestorEvent event) {
                }

                @Override
                public void ancestorMoved(AncestorEvent event) {
                }
            });
            cp.add("tab hfill", locationField);
            cp.add(selector);
            JCheckBox virtualGroup = new JCheckBox(Msg.get("ui.virtualGroup"), prefs.getBoolean(JProjectGroupsPanel.VIRTUAL_GROUP_KEY, true));
            virtualGroup.setToolTipText(Msg.get("ui.virtualGroupToolTip"));
            cp.add("br", virtualGroup);
            int res = JOptionPane.showConfirmDialog(JProjectGroupsPanel.this, cp, Msg.get("ui.newProjectGroup"), 2, -1);
            if (res == 0) {
                prefs.putBoolean(JProjectGroupsPanel.VIRTUAL_GROUP_KEY, virtualGroup.isSelected());
                File f = selector.getSelectedFile();
                if (ProjectGroups.locationExists(f)) {
                    JOptionPane.showMessageDialog(JProjectGroupsPanel.this, Msg.get("edit.objectAlreadyExists", f.getName()), Msg.get("ui.newProjectGroup"), 0);
                    return;
                }
                ProjectGroup root = (ProjectGroup)JProjectGroupsPanel.this.tree.getModel().getRoot();
                try {
                    ProjectGroup newGroup;
                    if (f.exists()) {
                        newGroup = ProjectGroup.createInstance(() -> f);
                    } else {
                        newGroup = virtualGroup.isSelected() ? new VirtualProjectGroup(() -> f) : new FolderProjectGroup(() -> f);
                        newGroup.createBackingFiles();
                    }
                    ((DefaultTreeModel)JProjectGroupsPanel.this.tree.getModel()).insertNodeInto(newGroup, root, root.getChildCount());
                    JProjectGroupsPanel.this.tree.setSelectionPath(new TreePath(new Object[]{root, newGroup}));
                }
                catch (IOException ex) {
                    Debug.showErrorDialog(JProjectGroupsPanel.this, ex);
                }
            }
        }
    };
    @ToolTipText(value="ui.clickToExpandToolTip")
    JPlainButton groupNameButton = new JPlainButton(RIGHT_TRIANGLE);
    private JComboButton<Config.ProjectOrdering> orderingButton = new JComboButton<Config.ProjectOrdering>(Config.ProjectOrdering.values(), false);
    private JPlainButton newProjectButton = new JPlainButton(this.newProjectAction);
    private JPanel expandedPanel = new JPanel(new BorderLayout());
    private JPlainButton newProjectGroupButton = new JPlainButton(this.newProjectGroupAction);
    @Text(value="ui.projectGroups")
    JPropertyPanel.JSmallLabel projectGroupsLabel = new JPropertyPanel.JSmallLabel();
    JProjectGroupsTree tree = new JProjectGroupsTree();
    boolean expanded = false;
    private final JAlbumExplorer explorer;

    private void addContextMenu(JProjectGroupsTree tree) {
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                JProjectGroupsPanel.this.handleContextMenu(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                JProjectGroupsPanel.this.handleContextMenu(mouseEvent);
            }
        };
        tree.addMouseListener(mouseListener);
    }

    private void handleContextMenu(MouseEvent e) {
        if (e.isPopupTrigger()) {
            TreePath tp = this.tree.getClosestPathForLocation(e.getX(), e.getY());
            this.clickedNode = (ProjectGroup)tp.getLastPathComponent();
            if (this.clickedNode instanceof FolderProjectGroup) {
                this.tree.setSelectionPath(tp);
                JPopupMenu menu = new JPopupMenu();
                menu.add(this.newProjectSubGroupAction);
                menu.add(this.newVirtualProjectSubGroupAction);
                menu.add(this.showInFileSystemAction);
                menu.add(this.reloadAction);
                if (this.clickedNode != ProjectGroup.MY_ALBUMS_GROUP) {
                    menu.add(this.renameGroupAction);
                    File myAlbumsDir = new File(Config.getConfig().getMyAlbumsLocation());
                    if (this.clickedNode.getParent() == ProjectGroups.getInstance().getRootGroup() && !IO.isSubdirectoryOf(this.clickedNode.getLocation(), myAlbumsDir)) {
                        menu.add(this.removeGroupAction);
                    } else {
                        menu.add(this.deleteGroupAction);
                    }
                }
                menu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
        this.groupNameButton.setIcon(expanded ? DOWN_TRIANGLE : RIGHT_TRIANGLE);
        this.expandedPanel.setVisible(expanded);
        this.validate();
        this.scrollRectToVisible(this.getBounds());
        this.firePropertyChange("expanded", !expanded, expanded);
        if (expanded) {
            UsageCounters.increase("projectGroupsExpanded");
        }
    }

    public JProjectGroupsPanel(JAlbumExplorer explorer) {
        super(new RiverLayout2(2, 2));
        this.explorer = explorer;
        Msg.maintainTranslated(this);
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 2));
        this.groupNameButton.setFont(JAlbumFrame.TITLE_FONT);
        this.groupNameButton.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.groupNameButton.setHorizontalAlignment(10);
        this.tree.addTreeSelectionListener(e -> {
            ProjectGroup pg = (ProjectGroup)e.getPath().getLastPathComponent();
            this.setTitle((String)(pg instanceof VirtualGroup ? "<" + pg.getName() + ">" : pg.getName()));
            ProjectGroups.getInstance().setCurrentGroup(pg);
        });
        this.tree.setEditable(true);
        AutoSelectingTreeCellEditor editor = new AutoSelectingTreeCellEditor(this.tree, (DefaultTreeCellRenderer)this.tree.getCellRenderer()){

            @Override
            public boolean isCellEditable(EventObject event) {
                TreePath path;
                if (event != null && event.getSource() instanceof JTree && event instanceof MouseEvent && (path = this.tree.getPathForLocation(((MouseEvent)event).getX(), ((MouseEvent)event).getY())) != null) {
                    TreeNode node = (TreeNode)path.getLastPathComponent();
                    if (!(node instanceof FolderProjectGroup)) {
                        return false;
                    }
                    if (node == ProjectGroup.MY_ALBUMS_GROUP) {
                        return false;
                    }
                }
                return super.isCellEditable(event);
            }
        };
        this.tree.setCellEditor(editor);
        editor.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingCanceled(ChangeEvent e) {
                ProjectGroup lastNode = (ProjectGroup)JProjectGroupsPanel.this.tree.getLastSelectedPathComponent();
                if (lastNode instanceof Temporary) {
                    JProjectGroupsPanel.this.tree.setSelectionPath(lastNode.getParentGroup().getTreePath());
                    ((DefaultTreeModel)JProjectGroupsPanel.this.tree.getModel()).removeNodeFromParent(lastNode);
                }
            }

            @Override
            public void editingStopped(ChangeEvent e) {
            }
        });
        this.tree.getModel().addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                DefaultTreeModel model = (DefaultTreeModel)JProjectGroupsPanel.this.tree.getModel();
                String newName = (String)JProjectGroupsPanel.this.tree.getCellEditor().getCellEditorValue();
                ProjectGroup group = (ProjectGroup)e.getChildren()[0];
                ProjectGroup parent = (ProjectGroup)group.getParent();
                ProjectGroup newGroup = null;
                try {
                    if (group instanceof Temporary) {
                        FolderProjectGroup tmpGroup = (FolderProjectGroup)group;
                        newGroup = group instanceof TempFolderProjectGroup ? new FolderProjectGroup(parent, newName) : new VirtualProjectGroup(parent, newName);
                        ((FolderProjectGroup)newGroup).createBackingFiles();
                        model.insertNodeInto(newGroup, parent, 0);
                        JProjectGroupsPanel.this.tree.setSelectionPath(newGroup.getTreePath());
                        model.removeNodeFromParent(tmpGroup);
                    } else if (group instanceof FolderProjectGroup) {
                        FolderProjectGroup g = (FolderProjectGroup)group;
                        g.setName(newName);
                    }
                }
                catch (GroupAlreadyExistsException ex) {
                    JOptionPane.showMessageDialog(JProjectGroupsPanel.this, Msg.get("edit.objectAlreadyExists", newName), Msg.get("ui.newProjectGroup"), 0);
                    SwingUtilities.invokeLater(() -> JProjectGroupsPanel.this.tree.startEditingAtPath(group.getTreePath()));
                }
                catch (IOException ex) {
                    newGroup.removeFromParent();
                    Debug.showErrorDialog(JProjectGroupsPanel.this, ex);
                }
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
            }
        });
        this.addContextMenu(this.tree);
        this.tree.setDropMode(DropMode.ON);
        this.tree.setTransferHandler(new ProjectGroupsTreeTransferHandler(this.tree, explorer.parent));
        this.orderingButton.addPropertyChangeListener("selectedItem", pce -> {
            Config.ProjectOrdering ordering = this.getProjectOrdering();
            Config.getConfig().setProjectOrdering(ordering);
            explorer.albumManager.orderBy(ordering);
            explorer.parent.preferencesWindow.savePreferences();
        });
        new MenuSelector(this);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    JProjectGroupsPanel.this.setExpanded(!JProjectGroupsPanel.this.expanded);
                }
            }
        });
        ProjectGroups.getInstance().addPropertyChangeListener("currentGroup", pce -> {
            ProjectGroup pg = (ProjectGroup)pce.getNewValue();
            if (pg != null) {
                this.tree.setSelectionPath(pg.getTreePath());
            }
        });
        this.add("hfill", this.groupNameButton);
        this.add(this.orderingButton);
        this.add(this.newProjectButton);
        JPanel northPanel = new JPanel(new RiverLayout2(2, 2));
        northPanel.add("p", this.projectGroupsLabel);
        northPanel.add("hfill", Box.createHorizontalGlue());
        northPanel.add(this.newProjectGroupButton);
        this.expandedPanel.add((Component)northPanel, "North");
        this.expandedPanel.add((Component)this.tree, "Center");
        this.add("p hfill", this.expandedPanel);
        this.setExpanded(this.expanded);
        this.tree.setSelectionPath(ProjectGroups.getInstance().getCurrentGroup().getTreePath());
        if (UsageCounters.get("projectGroupsExpanded") == 0) {
            JAlbumUtilities.schedule(() -> TipOfTheDay.showSpeechBubble(this, new Hour(5), Msg.get("ui.projectGroupsHint"), 12), 8L, TimeUnit.MINUTES);
        }
    }

    private void setTitle(String title) {
        this.groupNameButton.setText(title);
    }

    public void setProjectOrdering(Config.ProjectOrdering ordering) {
        this.orderingButton.setSelectedItem(ordering);
    }

    public Config.ProjectOrdering getProjectOrdering() {
        return this.orderingButton.getSelectedItem();
    }

    public ProjectGroup getCurrentGroup() {
        return (ProjectGroup)this.tree.getSelectionPath().getLastPathComponent();
    }

    public static class JProjectGroupsTree
    extends JTree {
        public JProjectGroupsTree() {
            super(ProjectGroups.getInstance().getRootGroup());
            this.setRootVisible(false);
            this.setShowsRootHandles(true);
            this.getSelectionModel().setSelectionMode(1);
            this.setRowHeight(26);
            this.setCellRenderer(new DefaultTreeCellRenderer(){

                @Override
                public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                    super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                    ProjectGroup group = (ProjectGroup)value;
                    this.setText(group.getName());
                    this.setIcon(group.getIcon());
                    return this;
                }
            });
            ToolTipManager.sharedInstance().registerComponent(this);
        }

        @Override
        public String getToolTipText(MouseEvent event) {
            TreePath tp = this.getClosestPathForLocation(event.getX(), event.getY());
            return ((ProjectGroup)tp.getLastPathComponent()).getDescription();
        }

        public String debug() {
            return this.paramString();
        }
    }
}

