/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.projectgroups;

import java.awt.Component;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import net.jalbum.projectgroups.FolderProjectGroup;
import net.jalbum.projectgroups.ProjectGroup;
import net.jalbum.projectgroups.ProjectGroups;
import se.datadosen.component.ChooserFactory;
import se.datadosen.component.DirectoryChooser;
import se.datadosen.jalbum.Msg;

public class JProjectGroupsComboBox
extends JComboBox<ProjectGroup> {
    public JProjectGroupsComboBox() {
        this.init();
    }

    private void init() {
        ArrayList<SelectFolderProjectGroup> items = new ArrayList<SelectFolderProjectGroup>();
        ProjectGroups.getInstance().groups().forEach(pg -> items.add((SelectFolderProjectGroup)pg));
        items.add(new SelectFolderProjectGroup());
        this.setModel(new DefaultComboBoxModel<ProjectGroup>((ProjectGroup[])items.toArray(ProjectGroup[]::new)));
        this.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                ProjectGroup group = (ProjectGroup)value;
                label.setText(group.getPathFromRoot());
                label.setIcon(group.getIcon());
                label.setToolTipText(group.getDescription());
                return label;
            }
        });
    }

    public ProjectGroup getSelectedGroup() {
        return (ProjectGroup)this.getSelectedItem();
    }

    public class SelectFolderProjectGroup
    extends FolderProjectGroup {
        public SelectFolderProjectGroup() {
            super(() -> ProjectGroup.MY_ALBUMS_GROUP.getLocation());
        }

        @Override
        public String getPathFromRoot() {
            return "...";
        }

        @Override
        public Icon getIcon() {
            return null;
        }

        @Override
        public String getDescription() {
            return Msg.get("ui.chooseDirectoryToolTip");
        }

        @Override
        public int getChildCount() {
            return super.getChildCount();
        }

        public boolean chooseLocation() {
            DirectoryChooser chooser = ChooserFactory.createDirectoryChooser(SwingUtilities.getWindowAncestor(JProjectGroupsComboBox.this));
            chooser.setSelectedFile(this.getLocation());
            chooser.setDialogTitle(Msg.get("ui.chooseProjectsDirectory"));
            int res = chooser.showOpenDialog(JProjectGroupsComboBox.this);
            if (res == 0) {
                this.setLocation(chooser.getSelectedFile());
                return true;
            }
            return false;
        }
    }
}

