/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.projectgroups;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.swing.Icon;
import net.jalbum.projectgroups.AbstractProjectGroup;
import net.jalbum.projectgroups.GroupAlreadyExistsException;
import net.jalbum.projectgroups.GroupNotEmptyException;
import net.jalbum.projectgroups.ProjectGroup;
import net.jalbum.projectgroups.ProjectGroups;
import net.jalbum.projectgroups.Temporary;
import se.datadosen.io.CachedFile;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumObjectFactory;
import se.datadosen.jalbum.AlbumProject;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.JAlbumContext;

public class FolderProjectGroup
extends AbstractProjectGroup {
    private static AlbumObjectFactory factory = new AlbumObjectFactory(new AlbumBean());
    private static final Icon ICON = Icons.get("project-group", 20);
    private Supplier<File> locationSupplier;
    private long lastRefreshed;
    protected List<AlbumProject> projects;
    protected List<ProjectGroup> children;

    protected FolderProjectGroup(Supplier<File> locationSupplier) {
        this.locationSupplier = locationSupplier;
    }

    protected FolderProjectGroup(ProjectGroup parent, String name) {
        this(() -> new File(parent.getLocation(), FolderProjectGroup.addBrackets(name)));
        this.parent = parent;
    }

    @Override
    public String getName() {
        String name = this.getLocation().getName();
        return FolderProjectGroup.trimBrackets(name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setName(String name) throws GroupAlreadyExistsException {
        File oldPath = this.getLocation();
        if (this.parent instanceof FolderProjectGroup) {
            File newName = FolderProjectGroup.locationFor(this.parent, name);
            if (!this.getLocation().renameTo(newName)) throw new GroupAlreadyExistsException(name);
            this.setLocation(FolderProjectGroup.locationFor(this.parent, name));
            ProjectGroups.getInstance().groupRenamed(this, oldPath, this.getLocation());
            return;
        } else {
            File parentDir = this.getLocation().getParentFile();
            File newName = new File(parentDir, name);
            if (!this.getLocation().renameTo(newName)) throw new GroupAlreadyExistsException(name);
            this.setLocation(new File(parentDir, name));
            ProjectGroups.getInstance().groupRenamed(this, oldPath, this.getLocation());
        }
    }

    @Override
    public String getDescription() {
        return this.getLocation().getAbsolutePath();
    }

    @Override
    public Icon getIcon() {
        return ICON;
    }

    @Override
    public File getLocation() {
        return this.locationSupplier.get();
    }

    protected void setLocation(File location) {
        this.locationSupplier = () -> location;
        this.invalidate();
    }

    @Override
    public List<AlbumProject> getProjects() {
        if (this.projects == null || this.getLocation().lastModified() > this.lastRefreshed) {
            this.lastRefreshed = System.currentTimeMillis();
            this.projects = new ArrayList<AlbumProject>();
            JAlbumContext context = JAlbumContext.getInstance();
            File loc = this.getLocation();
            if (!loc.exists()) {
                return this.projects;
            }
            try {
                for (CachedFile projDir : CachedFile.listContent(loc, f -> f.isDirectory())) {
                    try {
                        Optional<CachedFile> firstFound;
                        File projFile = new File(projDir, "jalbum-settings.jap");
                        if (!projFile.exists() && (firstFound = Stream.of(CachedFile.listContent(projDir)).filter(f -> f.getName().endsWith(".jap")).findFirst()).isPresent()) {
                            projFile = firstFound.get();
                        }
                        if (!projFile.exists()) continue;
                        try {
                            AlbumProject ap = new AlbumProject(projFile, context.getAlbumObjectfactory());
                            this.projects.add(ap);
                        }
                        catch (IOException iOException) {}
                    }
                    catch (IOException ex) {
                        System.err.println(ex.toString());
                    }
                }
            }
            catch (IOException ex) {
                System.err.println(ex.toString());
            }
        }
        return this.projects;
    }

    public void invalidate() {
        this.children = null;
        this.projects = null;
    }

    private void ensureInitialized() {
        if (this.children == null) {
            this.children = new ArrayList<ProjectGroup>();
            File[] files = this.getLocation().listFiles();
            if (files != null) {
                for (File f : files) {
                    String name = f.getName();
                    if (!f.isDirectory() || !FolderProjectGroup.hasBrackets(name)) continue;
                    this.children.add(ProjectGroup.createInstance(this, FolderProjectGroup.trimBrackets(name)));
                }
                Collections.sort(this.children);
            }
        }
    }

    public void addGroup(FolderProjectGroup child) throws GroupAlreadyExistsException {
        if (this.getChildren().stream().filter(pg -> !(pg instanceof Temporary)).anyMatch(pg -> pg.getName().equalsIgnoreCase(child.getName()))) {
            throw new GroupAlreadyExistsException(child.getName());
        }
    }

    public void delete() throws GroupNotEmptyException {
        File dsStore = new File(this.getLocation(), ".DS_Store");
        dsStore.delete();
        if (!this.getLocation().delete()) {
            throw new GroupNotEmptyException();
        }
    }

    public static boolean hasBrackets(String s) {
        return !s.equals(FolderProjectGroup.trimBrackets(s));
    }

    public static String trimBrackets(String s) {
        if (s.length() < 2) {
            return s;
        }
        return s.charAt(0) == '[' && s.charAt(s.length() - 1) == ']' ? s.substring(1, s.length() - 1) : s;
    }

    private static String addBrackets(String s) {
        return "[" + s + "]";
    }

    @Override
    public List<ProjectGroup> getChildren() {
        this.ensureInitialized();
        return this.children;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public void createBackingFiles() throws IOException {
        if (!this.getLocation().exists()) {
            Files.createDirectory(this.getLocation().toPath(), new FileAttribute[0]);
        }
    }

    @Override
    public int getSourceActions() {
        return 0x40000003;
    }

    @Override
    public int getDropAction() {
        return 2;
    }

    public static File locationFor(ProjectGroup parent, String name) {
        return new File(parent.getLocation(), FolderProjectGroup.addBrackets(name));
    }
}

