/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.jprint;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;

public class TextBox {
    private final AttributedString text;
    private final Graphics2D g2d;
    private TextAlignment alignment = TextAlignment.CENTERED;
    private int lineCount = -1;
    private LineBreakMeasurer lineMeasurer;
    private int paragraphStart;
    private int paragraphEnd;
    private Integer[] lineBreakIndexes;

    public TextBox(String s, Graphics2D g2d) {
        AttributedString as = null;
        if (s != null) {
            as = new AttributedString(s);
            as.addAttribute(TextAttribute.FONT, g2d.getFont());
        }
        this.text = as;
        this.g2d = g2d;
        this.init(g2d);
    }

    public TextBox(AttributedString text, Graphics2D g2d) {
        this.text = text;
        this.g2d = g2d;
        this.init(g2d);
    }

    private void init(Graphics2D g2d) {
        if (this.lineMeasurer == null && this.text != null) {
            AttributedCharacterIterator it = this.text.getIterator();
            this.paragraphStart = it.getBeginIndex();
            this.paragraphEnd = it.getEndIndex();
            FontRenderContext frc = g2d.getFontRenderContext();
            this.lineMeasurer = new LineBreakMeasurer(it, frc);
            this.lineBreakIndexes = this.getLineBreakIndexes(this.text.getIterator());
        }
    }

    protected Integer[] getLineBreakIndexes(AttributedCharacterIterator aci) {
        ArrayList<Integer> lineDelimiterList = new ArrayList<Integer>();
        char c = aci.first();
        while (c != '\uffff') {
            if (c == '\n') {
                lineDelimiterList.add(aci.getIndex());
            }
            c = aci.next();
        }
        lineDelimiterList.add(aci.getEndIndex() - 1);
        return lineDelimiterList.toArray(new Integer[lineDelimiterList.size()]);
    }

    public Dimension getSize(int breakWidth) {
        if (this.text == null) {
            return new Dimension(0, 0);
        }
        float drawPosY = 0.0f;
        float maxWidth = 0.0f;
        int currentBreak = 0;
        this.lineMeasurer.setPosition(this.paragraphStart);
        this.lineCount = 0;
        while (this.lineMeasurer.getPosition() < this.paragraphEnd) {
            ++this.lineCount;
            int limit = this.lineBreakIndexes[currentBreak] + 1;
            TextLayout layout = this.lineMeasurer.nextLayout(breakWidth, limit, false);
            if (this.lineMeasurer.getPosition() == limit) {
                ++currentBreak;
            }
            drawPosY += layout.getAscent() + layout.getDescent() + layout.getLeading();
            float lineWidth = layout.getVisibleAdvance();
            if (!(lineWidth > maxWidth)) continue;
            maxWidth = lineWidth;
        }
        return new Dimension((int)Math.ceil(maxWidth), (int)Math.ceil(drawPosY));
    }

    public int getLineCount(int breakWidth) {
        this.getSize(breakWidth);
        return this.lineCount;
    }

    public void draw(float x, float y, int breakWidth) {
        AffineTransform backup = this.g2d.getTransform();
        this.g2d.translate(x, y);
        if (this.text == null) {
            return;
        }
        this.init(this.g2d);
        float drawPosY = 0.0f;
        int currentBreak = 0;
        this.lineMeasurer.setPosition(this.paragraphStart);
        while (this.lineMeasurer.getPosition() < this.paragraphEnd) {
            int limit = this.lineBreakIndexes[currentBreak] + 1;
            TextLayout layout = this.lineMeasurer.nextLayout(breakWidth, limit, false);
            if (this.lineMeasurer.getPosition() == limit) {
                ++currentBreak;
            }
            float drawPosX = layout.isLeftToRight() ? 0.0f : (float)breakWidth - layout.getAdvance();
            layout.draw(this.g2d, drawPosX, drawPosY += layout.getLeading() + layout.getAscent());
            drawPosY += layout.getDescent();
        }
        this.g2d.setTransform(backup);
    }

    public TextAlignment getAlignment() {
        return this.alignment;
    }

    public void setAlignment(TextAlignment alignment) {
        this.alignment = alignment;
    }

    public static enum TextAlignment {
        LEFT,
        CENTERED,
        RIGHT;

    }
}

