/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.jprint;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.Preferences;
import javax.script.ScriptException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ProgressMonitor;
import net.jalbum.jprint.JPageLayout;
import net.jalbum.jprint.PageLayout;
import net.jalbum.jprint.TextBox;
import se.datadosen.component.ControlPanel;
import se.datadosen.component.StateMonitor;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumImage;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.jalbum.PluginContext;
import se.datadosen.util.Debug;
import se.datadosen.util.Replacer;

public class JPrintDialog
extends JDialog
implements Printable {
    static final int menuShortcutKeyMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx();
    private static final Icon bigIcon = Icons.get("printer", 40);
    private final Preferences prefs = Preferences.userNodeForPackage(this.getClass());
    private List<AlbumObject> printQueue;
    private PluginContext context;
    private int gap = 12;
    JCheckBox showFilenames = new JCheckBox(Msg.get("print.showFilenames"), this.prefs.getBoolean("showFilenames", true));
    JCheckBox showCaptions = new JCheckBox(Msg.get("print.showCaptions"), this.prefs.getBoolean("showCaptions", false));
    JCheckBox showDimensions = new JCheckBox(Msg.get("print.showDimensions"), this.prefs.getBoolean("showDimensions", false));
    JComboBox<PageLayout> pageLayout = new JComboBox<PageLayout>(PageLayout.values());
    JPageLayout pageLayoutIndicator;
    PrinterJob printJob;
    AlbumBean engine;
    PageFormat pageFormat;
    ProgressMonitor progressMonitor;
    private Replacer stripHtml = new Replacer();
    private Action closeAction;
    private Action pageSetupAction;
    private Action printAction;
    private int pass;
    private int lastPageIndex;

    private void addFolder(AlbumObject folder) {
        for (AlbumObject ao : folder.getChildren()) {
            if (!ao.isIncluded()) continue;
            if (ao.isFolder()) {
                this.addFolder(ao);
                continue;
            }
            if (!ao.hasDisplayableImage()) continue;
            this.printQueue.add(ao);
        }
    }

    public JPrintDialog(JAlbumContext context) {
        super(context.getFrame(), Msg.get("print.print"), true);
        this.stripHtml.add("<br>", "\n");
        this.stripHtml.add("<BR>", "\n");
        this.stripHtml.add("<b>", "");
        this.stripHtml.add("</b>", "");
        this.closeAction = new AbstractAction(Msg.get("ui.close")){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPrintDialog.this.prefs.putInt("pageOrientation", JPrintDialog.this.pageFormat.getOrientation());
                JPrintDialog.this.prefs.put("pageLayout", JPrintDialog.this.getPageLayout().name());
                JPrintDialog.this.prefs.putBoolean("showFilenames", JPrintDialog.this.showFilenames.isSelected());
                JPrintDialog.this.prefs.putBoolean("showCaptions", JPrintDialog.this.showCaptions.isSelected());
                JPrintDialog.this.prefs.putBoolean("showDimensions", JPrintDialog.this.showDimensions.isSelected());
                JPrintDialog.this.setVisible(false);
            }
        };
        this.pageSetupAction = new AbstractAction(Msg.get("print.pageSetup") + "..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPrintDialog.this.pageFormat = JPrintDialog.this.printJob.pageDialog(JPrintDialog.this.pageFormat);
                JPrintDialog.this.pageLayoutIndicator.setPageFormat(JPrintDialog.this.pageFormat);
                JPrintDialog.this.pageLayout.repaint();
            }
        };
        this.printAction = new AbstractAction(Msg.get("print.print") + "..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPrintDialog.this.printJob.setPrintable(JPrintDialog.this, JPrintDialog.this.pageFormat);
                if (JPrintDialog.this.printJob.printDialog()) {
                    JPrintDialog.this.printQueue = new ArrayList<AlbumObject>();
                    AlbumObject[] sel = JPrintDialog.this.context.getSelectedAlbumObjects();
                    JPrintDialog.this.printJob.setJobName(JPrintDialog.this.context.getCurrentFolder().getName());
                    if (sel.length == 0) {
                        JPrintDialog.this.addFolder(JPrintDialog.this.context.getCurrentFolder());
                    } else {
                        for (AlbumObject ao : sel) {
                            if (!ao.isIncluded()) continue;
                            if (ao.isFolder()) {
                                JPrintDialog.this.addFolder(ao);
                                continue;
                            }
                            if (!ao.hasDisplayableImage()) continue;
                            JPrintDialog.this.printQueue.add(ao);
                        }
                        if (sel.length == 1) {
                            JPrintDialog.this.printJob.setJobName(sel[0].getName());
                        }
                    }
                    JPrintDialog.this.progressMonitor = new ProgressMonitor(JPrintDialog.this, Msg.get("print.printing") + "...", null, 0, JPrintDialog.this.printQueue.size());
                    JPrintDialog.this.pass = 1;
                    new Thread("Print thread"){

                        @Override
                        public void run() {
                            try {
                                JPrintDialog.this.printJob.print();
                            }
                            catch (PrinterException pe) {
                                Debug.showFriendlyErrorDialog(JPrintDialog.this, pe);
                            }
                        }
                    }.start();
                }
            }
        };
        this.pass = 1;
        this.lastPageIndex = -1;
        this.context = context.getPluginContext();
        this.init();
    }

    private void setPageFormat(PageFormat pf) {
        this.pageFormat = pf;
    }

    private void init() {
        this.engine = this.context.getJAlbumContext().getEngine();
        try {
            this.engine.init();
        }
        catch (IOException | ScriptException | OperationAbortedException ex) {
            throw new RuntimeException(ex);
        }
        this.printJob = PrinterJob.getPrinterJob();
        this.pageFormat = this.printJob.defaultPage();
        this.pageFormat.setOrientation(this.prefs.getInt("pageOrientation", 0));
        ListCellRenderer<PageLayout> renderer = this.pageLayout.getRenderer();
        this.pageLayout.setRenderer((list, value, index, isSelected, cellHasFocus) -> {
            JLabel label = (JLabel)renderer.getListCellRendererComponent(list, (PageLayout)((Object)value), index, isSelected, cellHasFocus);
            label.setText(value.toString(this.pageFormat.getOrientation()));
            return label;
        });
        this.pageLayout.setSelectedItem((Object)PageLayout.valueOf(this.prefs.get("pageLayout", PageLayout.twelve.name())));
        this.pageLayoutIndicator = new JPageLayout(this.pageFormat, this.getPageLayout(), this.gap);
        this.pageLayoutIndicator.setToolTipText(Msg.get("print.pageLayout"));
        new StateMonitor(){

            @Override
            public void onChange() {
                JPrintDialog.this.pageLayoutIndicator.setPageLayout(JPrintDialog.this.getPageLayout());
            }
        }.add(this.pageLayout).done();
        Container content = this.getContentPane();
        content.setLayout(new BorderLayout());
        KeyStroke ks = KeyStroke.getKeyStroke(27, 0);
        JLayeredPane pane = this.getLayeredPane();
        pane.registerKeyboardAction(this.closeAction, "close", ks, 2);
        JPanel contentPanel = new JPanel(new BorderLayout());
        this.setContentPane(contentPanel);
        contentPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 4, 8));
        ControlPanel controls = new ControlPanel();
        controls.add(new JLabel(Msg.get("print.imagesPerPage")));
        controls.add("tab", this.pageLayout);
        controls.add("br", this.showFilenames);
        controls.add("br", this.showCaptions);
        controls.add("br", this.showDimensions);
        JPanel buttonPanel = new JPanel(new FlowLayout(4));
        buttonPanel.add(new JButton(this.pageSetupAction));
        JButton printButton = new JButton(this.printAction);
        buttonPanel.add(printButton);
        contentPanel.add((Component)controls, "Center");
        contentPanel.add((Component)new JLabel(bigIcon), "West");
        contentPanel.add((Component)this.pageLayoutIndicator, "East");
        contentPanel.add((Component)buttonPanel, "South");
        this.getRootPane().setDefaultButton(printButton);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                JPrintDialog.this.closeAction.actionPerformed(null);
            }
        });
        this.pack();
    }

    private PageLayout getPageLayout() {
        return (PageLayout)((Object)this.pageLayout.getSelectedItem());
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        int rows = this.getPageLayout().getRows();
        int cols = this.getPageLayout().getCols();
        if (pageFormat.getOrientation() == 1) {
            int t = rows;
            rows = cols;
            cols = t;
        }
        int imagesPerPage = rows * cols;
        if (this.progressMonitor.isCanceled()) {
            System.out.println("Cancelling print");
            this.printJob.cancel();
            return 1;
        }
        if (pageIndex == this.lastPageIndex) {
            ++this.pass;
        } else {
            this.lastPageIndex = pageIndex;
            this.pass = 1;
        }
        int totalPages = (int)Math.ceil((double)this.printQueue.size() / (double)imagesPerPage);
        if (pageIndex >= totalPages) {
            this.progressMonitor.close();
            return 1;
        }
        Graphics2D g = (Graphics2D)graphics;
        this.progressMonitor.setNote(Msg.get("print.printProgress", pageIndex + 1, totalPages, this.pass));
        AffineTransform transform = g.getTransform();
        g.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        Dimension printable = new Dimension((int)pageFormat.getImageableWidth(), (int)pageFormat.getImageableHeight());
        Dimension tile = new Dimension((printable.width - this.gap * (cols - 1)) / cols, (printable.height - this.gap * (rows - 1)) / rows);
        int startIndex = pageIndex * imagesPerPage;
        try {
            for (int row = 0; row < rows; ++row) {
                for (int col = 0; col < cols; ++col) {
                    int imageNum = startIndex + row * cols + col;
                    AlbumObject ao = this.printQueue.get(imageNum);
                    AffineTransform oldTransform = g.getTransform();
                    g.translate((double)printable.width * (double)col / (double)cols, (double)printable.height * (double)row / (double)rows);
                    Shape oldClip = g.getClip();
                    g.setClip(0, 0, tile.width, tile.height);
                    this.printTile(g, ao, tile);
                    g.setClip(oldClip);
                    g.setTransform(oldTransform);
                    this.progressMonitor.setProgress(imageNum);
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        g.setTransform(transform);
        return 0;
    }

    private String getText(AlbumObject ao) {
        String comment;
        ArrayList<String> texts = new ArrayList<String>();
        if (this.showFilenames.isSelected()) {
            texts.add(ao.getName());
        }
        if (this.showCaptions.isSelected() && (comment = this.stripHtml.replace(ao.getComment()).replaceAll("\\<.*?\\>", "")).length() > 0) {
            texts.add(comment);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < texts.size(); ++i) {
            if (i > 0) {
                sb.append(" | ");
            }
            sb.append((String)texts.get(i));
        }
        if (this.showDimensions.isSelected()) {
            try {
                Dimension dim = ao.getImageInfo().getSize();
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append("(").append(dim.width).append("x").append(dim.height).append(")");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return null;
    }

    static Dimension getScaledSize(Dimension imageDim, Dimension boundingBox) {
        if (imageDim.width <= boundingBox.width && imageDim.height <= boundingBox.height) {
            return imageDim;
        }
        double widthScale = (double)imageDim.width / (double)boundingBox.width;
        double heightScale = (double)imageDim.height / (double)boundingBox.height;
        double maxScale = Math.max(widthScale, heightScale);
        return new Dimension((int)((double)imageDim.width / maxScale + 0.5), (int)((double)imageDim.height / maxScale + 0.5));
    }

    private void printTile(Graphics2D g, AlbumObject ao, Dimension tile) throws IOException {
        BufferedImage image = (BufferedImage)ao.loadImage(true, new Dimension(tile.width * 2, tile.height * 2));
        AlbumImage ai = new AlbumImage(image, this.engine);
        try {
            ai = ai.applyFilters(1);
            ai = ai.applyFilters(2);
            image = (BufferedImage)ai.getImage();
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            return;
        }
        Dimension originalDim = new Dimension(image.getWidth(), image.getHeight());
        Dimension imageBox = (Dimension)tile.clone();
        Font f = new Font("Dialog", 0, 16 - (int)(1.5 * (double)this.getPageLayout().getCols()));
        g.setFont(f);
        String label = this.getText(ao);
        TextBox textBox = new TextBox(label, g);
        Dimension tb = textBox.getSize(tile.width);
        imageBox.height = (int)((double)imageBox.height - tb.getHeight());
        Dimension imageDim = JPrintDialog.getScaledSize(originalDim, imageBox);
        float yoff = 0.0f;
        float xoff = (tile.width - imageDim.width) / 2;
        if (label != null) {
            g.setColor(Color.black);
            textBox.draw(xoff + (float)((imageDim.width - tb.width) / 2), yoff + (float)imageDim.height, tile.width);
        }
        g.drawImage(image, (int)xoff, (int)yoff, imageDim.width, imageDim.height, null);
    }
}

