/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.jprint;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.print.PageFormat;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import net.jalbum.jprint.PageLayout;

public class JPageLayout
extends JComponent {
    private PageFormat pageFormat;
    private PageLayout pageLayout;
    private int gap;

    public JPageLayout(PageFormat pageFormat, PageLayout pageLayout, int gap) {
        this.pageFormat = pageFormat;
        this.pageLayout = pageLayout;
        this.gap = gap;
        this.init();
    }

    public PageFormat getPageFormat() {
        return this.pageFormat;
    }

    public void setPageFormat(PageFormat pageFormat) {
        this.pageFormat = pageFormat;
        this.repaint();
    }

    public PageLayout getPageLayout() {
        return this.pageLayout;
    }

    public void setPageLayout(PageLayout pageLayout) {
        this.pageLayout = pageLayout;
        this.repaint();
    }

    public int getGap() {
        return this.gap;
    }

    public void setGap(int gap) {
        this.gap = gap;
        this.repaint();
    }

    private boolean isPortrait() {
        return this.pageFormat.getOrientation() == 1;
    }

    @Override
    protected void paintComponent(Graphics g2d) {
        super.paintComponent(g2d);
        Insets in = this.getInsets();
        int width = this.getWidth() - in.left - in.right;
        int height = this.getHeight() - in.top - in.bottom;
        Graphics2D g = (Graphics2D)g2d;
        g.translate(in.left, in.top);
        double scale = Math.min((double)width / this.pageFormat.getWidth(), (double)height / this.pageFormat.getHeight());
        g.scale(scale, scale);
        double largestSide = Math.max(this.pageFormat.getWidth(), this.pageFormat.getHeight());
        g.translate((largestSide - this.pageFormat.getWidth()) / 2.0, (largestSide - this.pageFormat.getHeight()) / 2.0);
        g.setColor(Color.white);
        g.fillRect(0, 0, (int)this.pageFormat.getWidth(), (int)this.pageFormat.getHeight());
        g.setColor(Color.black);
        g.drawRect(0, 0, (int)this.pageFormat.getWidth(), (int)this.pageFormat.getHeight());
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        int cols = this.isPortrait() ? this.pageLayout.getRows() : this.pageLayout.getCols();
        int rows = this.isPortrait() ? this.pageLayout.getCols() : this.pageLayout.getRows();
        g.translate(this.pageFormat.getImageableX(), this.pageFormat.getImageableY());
        Dimension printable = new Dimension((int)this.pageFormat.getImageableWidth(), (int)this.pageFormat.getImageableHeight());
        int iconicGap = this.gap * 2;
        Dimension tile = new Dimension((printable.width - iconicGap * (cols - 1)) / cols, (printable.height - iconicGap * (rows - 1)) / rows);
        g.setColor(Color.lightGray);
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < cols; ++col) {
                g.fillRect(col * printable.width / cols, row * printable.height / rows, tile.width, tile.height);
            }
        }
    }

    private void init() {
        Dimension size = new Dimension(96, 96);
        this.setPreferredSize(size);
        this.setMaximumSize(size);
        this.setMinimumSize(size);
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
    }
}

