/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.filters.ui;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import net.jalbum.filters.Aligneable;
import net.jalbum.filters.Alignment;
import net.jalbum.filters.Bounded;
import net.jalbum.filters.HasOSDControls;
import net.jalbum.filters.VerticalAlignment;
import se.datadosen.component.JBackgroundPanel;
import se.datadosen.jalbum.JAlbumColor;

public class JAlignmentSelector
extends JComponent
implements HasOSDControls {
    public static final int SIZE = 42;
    public static final int LINE_THICKNESS = 1;
    public static final int BUTTON_BORDER = 1;
    public static final int RADIUS = 5;
    protected Aligneable model;
    private final Color buttonColor = new Color(0, 180, 0);
    private final OSDSupport osdSupport = new OSDSupport();

    public JAlignmentSelector(Aligneable model) {
        this.model = model;
        this.init();
    }

    private void init() {
        this.setPreferredSize(new Dimension(42, 42));
        this.setForeground(JAlbumColor.controlShadow);
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                JAlignmentSelector.this.handleMouseEvent(e);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                JAlignmentSelector.this.handleMouseEvent(e);
            }
        });
    }

    private void handleMouseEvent(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        int cw = this.getWidth();
        int ch = this.getHeight();
        Insets in = this.getInsets();
        int width = cw - in.left - in.right;
        int height = ch - in.top - in.bottom;
        int xIndex = 3 * (e.getX() - in.left) / width;
        xIndex = JAlignmentSelector.ensureBounded(xIndex, (Object[])Alignment.values());
        int yIndex = 3 * (e.getY() - in.top) / height;
        yIndex = JAlignmentSelector.ensureBounded(yIndex, (Object[])VerticalAlignment.values());
        Alignment align = Alignment.values()[xIndex];
        VerticalAlignment vAlign = VerticalAlignment.values()[yIndex];
        Alignment oldAlign = this.model.getAlign();
        VerticalAlignment oldVAlign = this.model.getValign();
        if (align != oldAlign || vAlign != oldVAlign) {
            this.model.setAlign(align);
            this.model.setValign(vAlign);
            this.repaint();
        }
    }

    private static int ensureBounded(int i, Object[] array) {
        if (i < 0) {
            return 0;
        }
        return Math.min(i, array.length - 1);
    }

    @Override
    protected void paintComponent(Graphics g2d) {
        Graphics2D g = (Graphics2D)g2d;
        if (!this.isEnabled()) {
            if (this.isOpaque()) {
                g.setColor(this.getBackground());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            g.setComposite(AlphaComposite.getInstance(3, 0.5f));
        }
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int cw = this.getWidth();
        int ch = this.getHeight();
        Insets in = this.getInsets();
        int width = cw - in.left - in.right;
        int height = ch - in.top - in.bottom;
        g.translate(in.left, in.top);
        int xIndex = this.model.getAlign().ordinal();
        int yIndex = this.model.getValign().ordinal();
        int x = width * xIndex / 3 + 1 + 1;
        int y = height * yIndex / 3 + 1 + 1;
        int butWidth = width / 3 - 2 - 1;
        int butHeight = height / 3 - 2 - 1;
        g.setColor(this.buttonColor);
        g.fillRoundRect(x, y, butWidth, butHeight, 5, 5);
        g.setColor(this.getForeground());
        g.setStroke(new BasicStroke(1.0f));
        g.drawRoundRect(0, 0, width, height, 5, 5);
        g.drawLine(width / 3, 0, width / 3, height);
        g.drawLine(2 * width / 3, 0, 2 * width / 3, height);
        g.drawLine(0, height / 3, width, height / 3);
        g.drawLine(0, 2 * height / 3, width, 2 * height / 3);
    }

    @Override
    public void attachOSDControls(JBackgroundPanel display) {
        this.osdSupport.attachOSDControls(display);
    }

    @Override
    public void detachOSDControls(JBackgroundPanel display) {
        this.osdSupport.detachOSDControls(display);
    }

    private class OSDSupport
    implements MouseListener,
    MouseMotionListener {
        JBackgroundPanel display;
        private Point mousePressedLocation;
        private Point textLocation;
        private boolean hit;

        private OSDSupport() {
        }

        public void attachOSDControls(JBackgroundPanel display) {
            this.display = display;
            display.addMouseListener(this);
            display.addMouseMotionListener(this);
        }

        public void detachOSDControls(JBackgroundPanel display) {
            display.removeMouseListener(this);
            display.removeMouseMotionListener(this);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.mousePressedLocation = this.translate(e.getPoint());
            Rectangle tb = ((Bounded)((Object)JAlignmentSelector.this.model)).getBounds();
            this.textLocation = new Point(tb.x + tb.width / 2, tb.y + tb.height / 2);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.display.setCursor(Cursor.getDefaultCursor());
            this.hit = false;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!this.hit) {
                return;
            }
            Point mouseLocation = this.translate(e.getPoint());
            Point newLoc = new Point(this.textLocation);
            newLoc.translate(mouseLocation.x - this.mousePressedLocation.x, mouseLocation.y - this.mousePressedLocation.y);
            Dimension imageDim = this.display.getImageBounds().getSize();
            double sf = this.display.getScaleFactor();
            imageDim.width = (int)((double)imageDim.width * sf);
            imageDim.height = (int)((double)imageDim.height * sf);
            int xIndex = 3 * newLoc.x / imageDim.width;
            xIndex = JAlignmentSelector.ensureBounded(xIndex, (Object[])Alignment.values());
            int yIndex = 3 * newLoc.y / imageDim.height;
            yIndex = JAlignmentSelector.ensureBounded(yIndex, (Object[])VerticalAlignment.values());
            Alignment align = Alignment.values()[xIndex];
            VerticalAlignment vAlign = VerticalAlignment.values()[yIndex];
            Alignment oldAlign = JAlignmentSelector.this.model.getAlign();
            VerticalAlignment oldVAlign = JAlignmentSelector.this.model.getValign();
            if (align != oldAlign || vAlign != oldVAlign) {
                JAlignmentSelector.this.model.setAlign(align);
                JAlignmentSelector.this.model.setValign(vAlign);
                JAlignmentSelector.this.repaint();
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Point p = this.translate(e.getPoint());
            Rectangle textBounds = ((Bounded)((Object)JAlignmentSelector.this.model)).getBounds();
            this.hit = textBounds.contains(p);
            this.display.setCursor(this.hit ? Cursor.getPredefinedCursor(12) : Cursor.getDefaultCursor());
        }

        private Point translate(Point p) {
            Rectangle ib = this.display.getImageBounds();
            double sf = this.display.getScaleFactor();
            p.translate(-ib.x, -ib.y);
            p.move((int)((double)p.x * sf), (int)((double)p.y * sf));
            return p;
        }
    }
}

