/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.filters.arty.effects;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Map;
import java.util.Random;
import javax.imageio.ImageIO;
import net.jalbum.filters.arty.effects.ArtySupport;
import net.jalbum.filters.arty.effects.BlendComposite;

public class ThistleFilter
extends ArtySupport {
    private int[] pixels;

    @Override
    public String getName() {
        return "Thistle";
    }

    @Override
    public String getDescription() {
        return "Antique, used look with scratches";
    }

    @Override
    public BufferedImage filter(BufferedImage bi, Map map) {
        return this.filter(bi);
    }

    @Override
    public BufferedImage filter(BufferedImage bi) {
        BufferedImage temp = ThistleFilter.convertType(bi, 2);
        int[] pixels = this.getPixels(temp);
        pixels = this.applyColorCurves(pixels, new double[][]{{0.0, 210.0, 255.0}, {0.0, 255.0}, {0.0, 255.0}}, new double[][]{{0.0, 235.0, 255.0}, {0.0, 255.0}, {0.0, 191.0}});
        temp = this.setPixels(temp, pixels);
        BufferedImage texture = new BufferedImage(temp.getWidth(), temp.getHeight(), temp.getType());
        try {
            texture = ImageIO.read(this.getClass().getResource("texture_old_square.jpg"));
        }
        catch (IOException ex) {
            new RuntimeException(ex);
        }
        Random generator = new Random();
        int random = generator.nextInt(4);
        double angle = 0.0;
        for (int i = 0; i < random; ++i) {
            angle += 90.0;
        }
        angle = angle * Math.PI / 180.0;
        AffineTransform aff = new AffineTransform();
        aff.rotate(angle, (double)texture.getWidth() / 2.0, (double)texture.getHeight() / 2.0);
        AffineTransformOp bio = new AffineTransformOp(aff, 2);
        texture = bio.filter(texture, null);
        Graphics2D graphics = temp.createGraphics();
        graphics.setComposite(BlendComposite.getInstance(BlendComposite.BlendingMode.OVERLAY, 0.75f));
        graphics.drawImage(texture, 0, 0, temp.getWidth(), temp.getHeight(), null);
        return temp;
    }
}

