/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.filters.arty.effects;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Map;
import net.jalbum.filters.arty.effects.ArtySupport;
import net.jalbum.filters.arty.effects.BlendComposite;

public class RainflowerFilter
extends ArtySupport {
    @Override
    public String getName() {
        return "Rainflower";
    }

    @Override
    public String getDescription() {
        return "effect like the Brannin filter in Instagram, but darker";
    }

    @Override
    public BufferedImage filter(BufferedImage bi, Map map) {
        return this.filter(bi);
    }

    @Override
    public BufferedImage filter(BufferedImage bi) {
        BufferedImage temp = RainflowerFilter.convertType(bi, 2);
        int[] pixels = this.getPixels(temp);
        pixels = this.applyColorCurves(pixels, new double[][]{{0.0, 31.0, 127.0, 223.0, 255.0}, {0.0, 15.0, 127.0, 223.0, 255.0}, {0.0, 15.0, 127.0, 223.0, 255.0}}, new double[][]{{0.0, 0.0, 127.0, 255.0, 255.0}, {0.0, 31.0, 127.0, 239.0, 255.0}, {0.0, 31.0, 127.0, 239.0, 255.0}});
        temp = this.setPixels(temp, pixels);
        BufferedImage tmp = this.getGrayScale(temp);
        Graphics2D g2 = temp.createGraphics();
        g2.drawImage((Image)temp, 0, 0, null);
        g2.setComposite(BlendComposite.getInstance(BlendComposite.BlendingMode.OVERLAY, 0.7f));
        g2.drawImage(tmp, 0, 0, temp.getWidth(), temp.getHeight(), null);
        g2.dispose();
        temp = this.applyBrightnessAndContrast(temp, -10.0, 20.0);
        pixels = this.getPixels(temp);
        pixels = this.applySaturation(pixels, 0.25);
        temp = this.setPixels(temp, pixels);
        return temp;
    }
}

