/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.filters.arty.effects;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.Map;
import net.jalbum.filters.arty.effects.ArtySupport;
import net.jalbum.filters.arty.effects.BlendComposite;

public class PinkFilter
extends ArtySupport {
    @Override
    public String getName() {
        return "Pink";
    }

    @Override
    public String getDescription() {
        return "effect like the Early Bird filter in Instagram";
    }

    @Override
    public BufferedImage filter(BufferedImage bi, Map map) {
        return this.filter(bi);
    }

    @Override
    public BufferedImage filter(BufferedImage bi) {
        BufferedImage temp = PinkFilter.convertType(bi, 2);
        temp = this.applyBrightnessAndContrast(temp, -5.0, 10.0);
        int[] pixels = this.getPixels(temp);
        pixels = this.applySaturation(pixels, 0.25);
        temp = this.setPixels(temp, pixels);
        BufferedImage dstImg = PinkFilter.adjustBorder(temp);
        BufferedImage tmpImg = new BufferedImage(temp.getWidth(), temp.getHeight(), temp.getType());
        Graphics2D gt = tmpImg.createGraphics();
        gt.setColor(new Color(250, 245, 215));
        gt.fill(new Rectangle(0, 0, bi.getWidth(), temp.getHeight()));
        Graphics2D gdst = dstImg.createGraphics();
        gdst.setComposite(BlendComposite.getInstance(BlendComposite.BlendingMode.MULTIPLY, 1.0f));
        gdst.drawImage(tmpImg, 0, 0, temp.getWidth(), temp.getHeight(), null);
        BufferedImage tmp2 = new BufferedImage(temp.getWidth(), temp.getHeight(), temp.getType());
        Graphics2D g2 = tmp2.createGraphics();
        g2.setColor(new Color(250, 245, 215));
        g2.fill(new Rectangle(0, 0, temp.getWidth(), temp.getHeight()));
        gdst.setComposite(BlendComposite.getInstance(BlendComposite.BlendingMode.OVERLAY, 0.3f));
        gdst.drawImage(tmp2, 0, 0, temp.getWidth(), temp.getHeight(), null);
        return dstImg;
    }
}

