/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.filters.arty.effects;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.RescaleOp;
import net.jalbum.filters.arty.effects.BlendComposite;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.interpolation.LinearInterpolator;
import org.apache.commons.math3.analysis.interpolation.SplineInterpolator;
import se.datadosen.jalbum.JAFilter;

public abstract class ArtySupport
implements JAFilter {
    public static final float STRONG_EFFECT_STRENGTH = 0.8f;
    private static final float EFFECT_STRENGTH = 0.6f;
    private int passes = 3;
    private int strength = 5;

    public BufferedImage filter(BufferedImage bi) {
        return bi;
    }

    public int[] getPixels(BufferedImage bi) {
        int[] pixels = new int[bi.getWidth() * bi.getHeight()];
        switch (bi.getType()) {
            case 5: {
                byte[] temp = ((DataBufferByte)bi.getRaster().getDataBuffer()).getData();
                for (int i = 0; i < bi.getWidth() * bi.getHeight(); ++i) {
                    pixels[i] = temp[i * 3 + 2] << 16 | temp[i * 3 + 1] << 8 | temp[i * 3];
                }
                break;
            }
            case 6: {
                byte[] temp = ((DataBufferByte)bi.getRaster().getDataBuffer()).getData();
                for (int i = 0; i < bi.getWidth() * bi.getHeight(); ++i) {
                    pixels[i] = temp[i * 3] << 24 | temp[i * 3 + 3] << 16 | temp[i * 3 + 2] << 8 | temp[i * 3 + 1];
                }
                break;
            }
            default: {
                pixels = ((DataBufferInt)bi.getRaster().getDataBuffer()).getData();
            }
        }
        return pixels;
    }

    public BufferedImage setPixels(BufferedImage bi, int[] pixels) {
        switch (bi.getType()) {
            case 5: {
                BufferedImage buff = new BufferedImage(bi.getWidth(), bi.getHeight(), 2);
                System.arraycopy(pixels, 0, ((DataBufferInt)buff.getRaster().getDataBuffer()).getData(), 0, bi.getWidth() * bi.getHeight());
                bi = ArtySupport.convertType(buff, bi.getType());
                break;
            }
            case 6: {
                BufferedImage buff = new BufferedImage(bi.getWidth(), bi.getHeight(), 2);
                System.arraycopy(pixels, 0, ((DataBufferInt)buff.getRaster().getDataBuffer()).getData(), 0, bi.getWidth() * bi.getHeight());
                bi = ArtySupport.convertType(buff, bi.getType());
                break;
            }
            default: {
                System.arraycopy(pixels, 0, ((DataBufferInt)bi.getRaster().getDataBuffer()).getData(), 0, bi.getWidth() * bi.getHeight());
            }
        }
        return bi;
    }

    public static BufferedImage convertType(BufferedImage bi, int type) {
        ColorConvertOp cco = new ColorConvertOp(null);
        BufferedImage dest = new BufferedImage(bi.getWidth(), bi.getHeight(), type);
        cco.filter(bi, dest);
        return dest;
    }

    public int[] applyRedTouch(int[] pixels, double redTouchFactor) {
        for (int i = 0; i < pixels.length; ++i) {
            int alpha = pixels[i] >> 24 & 0xFF;
            int red = pixels[i] >> 16 & 0xFF;
            int green = pixels[i] >> 8 & 0xFF;
            int blue = pixels[i] & 0xFF;
            float average = (green + blue) / 2;
            green = (int)((double)green - redTouchFactor * (double)((float)green - average));
            blue = (int)((double)blue - redTouchFactor * (double)((float)blue - average));
            if (alpha < 0) {
                alpha = 0;
            } else if (alpha > 255) {
                alpha = 255;
            }
            if (red < 0) {
                red = 0;
            } else if (red > 255) {
                red = 255;
            }
            if (green < 0) {
                green = 0;
            } else if (green > 255) {
                green = 255;
            }
            if (blue < 0) {
                blue = 0;
            } else if (blue > 255) {
                blue = 255;
            }
            pixels[i] = alpha << 24 | red << 16 | green << 8 | blue;
        }
        return pixels;
    }

    public int[] applyRedOnly(int[] pixels) {
        double frequenz = 0.006159985595274104;
        for (int i = 0; i < pixels.length; ++i) {
            int argb = pixels[i];
            int a = argb >> 24 & 0xFF;
            int r = argb >> 16 & 0xFF;
            int g = argb >> 8 & 0xFF;
            int b = argb & 0xFF;
            r = (int)(255.0 * Math.sin(frequenz * (double)r));
            b = (int)(-255.0 * Math.cos(frequenz * (double)b) + 255.0);
            pixels[i] = a << 24 | r << 16 | g << 8 | b;
        }
        return pixels;
    }

    public int[] applySaturation(int[] pixels, double saturationFactor) {
        for (int i = 0; i < pixels.length; ++i) {
            int alpha = pixels[i] >> 24 & 0xFF;
            int red = pixels[i] >> 16 & 0xFF;
            int green = pixels[i] >> 8 & 0xFF;
            int blue = pixels[i] & 0xFF;
            float average = (red + green + blue) / 3;
            red = (int)((double)red - saturationFactor * (double)((float)red - average));
            green = (int)((double)green - saturationFactor * (double)((float)green - average));
            blue = (int)((double)blue - saturationFactor * (double)((float)blue - average));
            if (alpha < 0) {
                alpha = 0;
            } else if (alpha > 255) {
                alpha = 255;
            }
            if (red < 0) {
                red = 0;
            } else if (red > 255) {
                red = 255;
            }
            if (green < 0) {
                green = 0;
            } else if (green > 255) {
                green = 255;
            }
            if (blue < 0) {
                blue = 0;
            } else if (blue > 255) {
                blue = 255;
            }
            pixels[i] = alpha << 24 | red << 16 | green << 8 | blue;
        }
        return pixels;
    }

    protected BufferedImage applyBrightnessAndContrast(BufferedImage bi, double brightness, double contrast) {
        double gamma = 0.25;
        contrast = contrast > 0.0 ? 100.0 * Math.pow(contrast - 1.0, 4.0) / Math.pow(100.0, 4.0) + 1.0 : (contrast == 0.0 ? 1.0 : 1.0 / (100.0 * Math.pow(-contrast + 1.0, 4.0) / Math.pow(100.0, 4.0) + 1.0));
        RescaleOp rescaleOp = new RescaleOp((float)contrast, (float)brightness, null);
        rescaleOp.filter(bi, bi);
        return bi;
    }

    protected int[] applyColorCurves(int[] pixels, double[][] input, double[][] output) {
        Object interpolatorRed = input[0].length > 2 ? new SplineInterpolator() : new LinearInterpolator();
        Object interpolatorGreen = input[1].length > 2 ? new SplineInterpolator() : new LinearInterpolator();
        Object interpolatorBlue = input[2].length > 2 ? new SplineInterpolator() : new LinearInterpolator();
        UnivariateFunction redFunc = interpolatorRed.interpolate(input[0], output[0]);
        UnivariateFunction greenFunc = interpolatorGreen.interpolate(input[1], output[1]);
        UnivariateFunction blueFunc = interpolatorBlue.interpolate(input[2], output[2]);
        for (int i = 0; i < pixels.length; ++i) {
            int alpha = pixels[i] >> 24 & 0xFF;
            int red = pixels[i] >> 16 & 0xFF;
            int green = pixels[i] >> 8 & 0xFF;
            int blue = pixels[i] & 0xFF;
            red = (int)redFunc.value((double)red);
            green = (int)greenFunc.value((double)green);
            blue = (int)blueFunc.value((double)blue);
            if (alpha < 0) {
                alpha = 0;
            } else if (alpha > 255) {
                alpha = 255;
            }
            if (red < 0) {
                red = 0;
            } else if (red > 255) {
                red = 255;
            }
            if (green < 0) {
                green = 0;
            } else if (green > 255) {
                green = 255;
            }
            if (blue < 0) {
                blue = 0;
            } else if (blue > 255) {
                blue = 255;
            }
            pixels[i] = alpha << 24 | red << 16 | green << 8 | blue;
        }
        return pixels;
    }

    protected BufferedImage getGrayScale(BufferedImage bi) {
        BufferedImage tmp = new BufferedImage(bi.getWidth(), bi.getHeight(), 10);
        Graphics g = tmp.getGraphics();
        g.drawImage(bi, 0, 0, null);
        g.dispose();
        BufferedImage dst = new BufferedImage(bi.getWidth(), bi.getHeight(), bi.getType());
        g = dst.getGraphics();
        g.drawImage(tmp, 0, 0, null);
        g.dispose();
        return dst;
    }

    public static BufferedImage adjustBorder(BufferedImage bi) {
        return ArtySupport.adjustBorder(bi, 0.6f);
    }

    public static BufferedImage adjustBorder(BufferedImage bi, float strength) {
        BufferedImage borderMask = ArtySupport.createSoftBorderMask(bi.getWidth(), bi.getHeight(), strength);
        Graphics2D g = bi.createGraphics();
        g.setComposite(BlendComposite.getInstance(BlendComposite.BlendingMode.MULTIPLY, 0.95f));
        g.drawImage((Image)borderMask, 0, 0, null);
        return bi;
    }

    private static BufferedImage createSoftBorderMask(int width, int height, float strength) {
        int i;
        if (strength > 1.0f) {
            strength = 1.0f;
        } else if (strength < 0.0f) {
            strength = 0.0f;
        }
        BufferedImage dstImg = new BufferedImage(width, height, 2);
        Graphics2D g = dstImg.createGraphics();
        g.setStroke(new BasicStroke(2.0f));
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        int bw = width / 4;
        int r = width / 3;
        for (i = bw; i >= 0; --i) {
            int colorComponent = 255 - (int)((float)(255 * i / bw) * strength);
            if (colorComponent < 0) {
                colorComponent = 0;
            }
            g.setColor(new Color(colorComponent, colorComponent, colorComponent));
            g.drawRoundRect(bw / 2 - i, bw / 2 - i, width - bw + 2 * i, height - bw + 2 * i, r, r);
        }
        i = 0;
        g.fillRoundRect(bw / 2 - i, bw / 2 - i, width - bw + 2 * i, height - bw + 2 * i, r, r);
        return dstImg;
    }

    protected BufferedImage blurFilter(BufferedImage bi) {
        Pixels pixels = new Pixels(bi, true);
        float r = (float)this.strength / 100.0f;
        r = r * r * r;
        for (int i = 0; i < this.passes; ++i) {
            pixels.boxBlur(r * 0.1f);
        }
        return pixels.getImage();
    }

    protected void setBlurStrength(int radius) {
        this.strength = radius;
    }

    private static class Pixels {
        private int width;
        private int height;
        private int[] pixels;
        private int[] newPixels;
        private BufferedImage img;

        private Pixels(BufferedImage in, boolean alwaysCopy) {
            this.width = in.getWidth();
            this.height = in.getHeight();
            this.newPixels = new int[this.width * this.height];
            DataBuffer db = in.getRaster().getDataBuffer();
            if (!(db instanceof DataBufferInt) || alwaysCopy) {
                this.img = new BufferedImage(this.width, this.height, 1);
                Graphics g = this.img.getGraphics();
                g.drawImage(in, 0, 0, null);
                g.dispose();
                db = this.img.getRaster().getDataBuffer();
            } else {
                this.img = in;
            }
            DataBufferInt dbi = (DataBufferInt)db;
            this.pixels = dbi.getData();
        }

        private BufferedImage getImage() {
            return this.img;
        }

        private void blurAlongXAndRotate(int radius) {
            int[] rSum = new int[this.width + 1];
            int[] gSum = new int[this.width + 1];
            int[] bSum = new int[this.width + 1];
            for (int y = 0; y < this.height; ++y) {
                int rAcc = 0;
                int gAcc = 0;
                int bAcc = 0;
                int x = 0;
                while (x < this.width) {
                    int col = this.pixels[y * this.width + x++];
                    rSum[x] = rAcc += col >> 16 & 0xFF;
                    gSum[x] = gAcc += col >> 8 & 0xFF;
                    bSum[x] = bAcc += col & 0xFF;
                }
                for (x = 0; x < this.width; ++x) {
                    int from = x - radius;
                    int to = x + radius + 1;
                    if (from < 0) {
                        from = 0;
                    }
                    if (to > this.width) {
                        to = this.width;
                    }
                    int len = to - from;
                    int r = (rSum[to] - rSum[from]) / len;
                    int g = (gSum[to] - gSum[from]) / len;
                    int b = (bSum[to] - bSum[from]) / len;
                    this.newPixels[x * this.height + y] = r << 16 | g << 8 | b;
                }
            }
            int[] tmp = this.pixels;
            this.pixels = this.newPixels;
            this.newPixels = tmp;
            int itmp = this.height;
            this.height = this.width;
            this.width = itmp;
        }

        private void boxBlur(float radius) {
            int size = this.width < this.height ? this.width : this.height;
            int r = (int)(radius * (float)size);
            this.blurAlongXAndRotate(r);
            this.blurAlongXAndRotate(r);
        }
    }
}

