/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.filters.arty;

import java.awt.image.BufferedImage;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import net.jalbum.filters.AbstractFilter;
import net.jalbum.filters.arty.Effect;
import net.jalbum.filters.arty.JArtySelector;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.JAFilter;
import se.datadosen.jalbum.Msg;
import se.datadosen.util.annotations.Unbound;

public class ArtyFilter
extends AbstractFilter {
    public static final String EFFECT_PROPERTY = "effect";
    private Effect effect = Effect.none;
    private JArtySelector ui;

    @Override
    public BufferedImage filter(BufferedImage bi, Map vars) {
        JAFilter effectClass = this.effect.getFilter();
        return effectClass.filter(bi, null);
    }

    public Effect getEffect() {
        return this.effect;
    }

    public void setEffect(Effect effect) {
        Effect oldEffect = this.effect;
        this.effect = effect;
        this.changeSupport.firePropertyChange(EFFECT_PROPERTY, (Object)oldEffect, (Object)effect);
        this.changeSupport.firePropertyChange("enabled", oldEffect != Effect.none, effect != Effect.none);
    }

    @Override
    @Unbound
    public boolean isEnabled() {
        return this.effect != Effect.none;
    }

    @Override
    public String getName() {
        return Msg.getString(this, "filters.arty.shortName");
    }

    @Override
    public ImageIcon getIcon() {
        return (ImageIcon)Icons.small("arty");
    }

    @Override
    public String getDescription() {
        return Msg.getString(this, "filters.arty.description");
    }

    @Override
    public JComponent userInterface() {
        if (this.ui == null) {
            this.ui = new JArtySelector(this);
        }
        return this.ui;
    }
}

