/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.filters;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import net.jalbum.filters.AbstractFilter;
import net.jalbum.filters.Aligneable;
import net.jalbum.filters.Alignment;
import net.jalbum.filters.Bounded;
import net.jalbum.filters.HasOSDControls;
import net.jalbum.filters.Layering;
import net.jalbum.filters.VerticalAlignment;
import net.jalbum.filters.ui.JAlignmentSelector;
import se.datadosen.component.ComponentUtilities;
import se.datadosen.component.ControlPanel;
import se.datadosen.component.JAlphaColorSelector;
import se.datadosen.component.JBackgroundPanel;
import se.datadosen.component.JFontComboBox;
import se.datadosen.component.JNarrowSlider;
import se.datadosen.component.StateMonitor;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.Msg;
import se.datadosen.util.BeanBinder;
import se.datadosen.util.Colors;
import se.datadosen.util.Replacer;
import se.datadosen.util.annotations.Text;
import se.datadosen.util.annotations.ToolTipText;
import se.datadosen.util.annotations.Unbound;

public class TextFilter
extends AbstractFilter
implements Aligneable,
Bounded {
    private String text = "";
    private Font font = new Font("SansSerif", 1, 40);
    private boolean tile;
    private int rowOffsetPercent = 0;
    private Color color = new Color(255, 255, 255);
    private Color shadowColor = new Color(0, 0, 0);
    private int shadowDistance = 0;
    private int strengthPercent = 100;
    private boolean antialias = true;
    private Alignment align = Alignment.left;
    private VerticalAlignment valign = VerticalAlignment.top;
    private int margin = 5;
    private int offset = 0;
    private int voffset = 0;
    private int angle = 0;
    private int referenceWidth = 0;
    private boolean roundedBorder = true;
    private Layering layering = Layering.ALL_OVER;
    private MyUI myUI;
    private final Rectangle textBounds = new Rectangle();

    public TextFilter() {
    }

    public TextFilter(boolean closeups, boolean thumbnails) {
        super(closeups, thumbnails);
    }

    @Override
    @Unbound
    public String getName() {
        return Msg.get("effects.textName");
    }

    @Override
    @Unbound
    public ImageIcon getIcon() {
        return (ImageIcon)Icons.small("text");
    }

    @Override
    @Unbound
    public String getDescription() {
        return "Overlay a text string on top of an image. The string may contain $variables";
    }

    @Override
    @Unbound
    public Rectangle getBounds() {
        return this.textBounds;
    }

    @Override
    public BufferedImage filter(BufferedImage bi, Map vars) {
        if (!this.isEnabled()) {
            return bi;
        }
        int width = bi.getWidth();
        int height = bi.getHeight();
        Graphics2D g = bi.createGraphics();
        float scale = vars.getOrDefault("scale", Float.valueOf(1.0f)).floatValue();
        this.paint(g, width, height, scale, vars);
        g.dispose();
        return bi;
    }

    public void paint(Component c, Graphics2D g) {
        this.paint(g, c.getWidth(), c.getHeight(), 1.0f, new HashMap());
    }

    private void paint(Graphics2D g, int width, int height, float scale, Map vars) {
        width = (int)((float)width / scale);
        height = (int)((float)height / scale);
        Font newFont = this.font;
        if (this.referenceWidth > 0) {
            newFont = this.font.deriveFont((float)this.font.getSize() * (float)width / (float)this.referenceWidth);
        }
        g.scale(scale, scale);
        if (this.antialias) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        g.setFont(newFont);
        Replacer r = new Replacer();
        TextFilter.fillReplacer(r, vars);
        String s = this.stripUnknownVariables(r.replace(this.text));
        FontRenderContext frc = g.getFontRenderContext();
        Rectangle2D rect = newFont.getStringBounds(s, frc);
        double radians = (double)this.angle / 180.0 * Math.PI;
        double bw = rect.getWidth();
        double bh = rect.getHeight();
        double boxWidth = Math.abs(bw * Math.cos(radians)) + Math.abs(bh * Math.sin(radians));
        double boxHeight = Math.abs(bh * Math.cos(radians)) + Math.abs(-bw * Math.sin(radians));
        float adjust = (float)Math.max(boxWidth / (double)(width - 2 * this.margin), boxHeight / (double)(height - 2 * this.margin));
        if (!this.tile && adjust > 1.0f) {
            newFont = this.font.deriveFont((float)this.font.getSize() / adjust);
            g.setFont(newFont);
            frc = g.getFontRenderContext();
            rect = newFont.getStringBounds(s, frc);
            bw = rect.getWidth();
            bh = rect.getHeight();
            boxWidth = Math.abs(bw * Math.cos(radians)) + Math.abs(bh * Math.sin(radians));
            boxHeight = Math.abs(bh * Math.cos(radians)) + Math.abs(-bw * Math.sin(radians));
        }
        if (this.tile) {
            this.align = Alignment.center;
            this.valign = VerticalAlignment.center;
        }
        int x = this.align == Alignment.left ? (int)rect.getX() + this.margin : (this.align == Alignment.right ? (int)((double)(width - this.margin) - boxWidth) : (int)(((double)width - boxWidth) / 2.0));
        int y = this.valign == VerticalAlignment.top ? this.margin : (this.valign == VerticalAlignment.bottom ? (int)((double)(height - this.margin) - boxHeight) : (int)(((double)height - boxHeight) / 2.0));
        this.textBounds.setBounds(x, y, (int)boxWidth, (int)boxHeight);
        AlphaComposite composite = AlphaComposite.getInstance(this.layering.getRule(), (float)this.strengthPercent / 100.0f);
        g.setComposite(composite);
        g.translate((int)((double)x + boxWidth / 2.0 + (double)this.offset), (int)((double)y + boxHeight / 2.0 + (double)this.voffset));
        if (this.angle != 0) {
            g.rotate(-radians);
        }
        if (this.tile) {
            int hyp = (int)Math.sqrt(width * width + height * height);
            int rows = (int)Math.ceil(Math.ceil((double)hyp / bh) / 2.0);
            int cols = (int)Math.ceil(Math.ceil((double)hyp / bw) / 2.0);
            for (int row = -rows; row <= rows; ++row) {
                int rowOffset = (int)bw * this.rowOffsetPercent / 100;
                for (int col = -cols; col <= cols; ++col) {
                    AffineTransform at = g.getTransform();
                    g.translate((double)((int)((bw + (double)this.margin) * (double)col)) + (double)(row * rowOffset) % bw, (double)((int)((bh + (double)this.margin) * (double)row)));
                    this.drawString(g, s, rect);
                    g.setTransform(at);
                }
            }
        } else {
            this.drawString(g, s, rect);
        }
    }

    private void drawString(Graphics2D g, String s, Rectangle2D rect) {
        if (this.shadowDistance > 0) {
            g.setColor(this.shadowColor);
            g.translate(this.shadowDistance, this.shadowDistance);
            g.drawString(s, (int)(-rect.getWidth() / 2.0 - rect.getX()), (int)(-rect.getHeight() / 2.0 - rect.getY()));
            g.translate(-this.shadowDistance, -this.shadowDistance);
        } else if (this.shadowDistance < 0) {
            g.setColor(this.shadowColor);
            Rectangle bgRect = TextFilter.grow(rect, -this.shadowDistance);
            if (this.roundedBorder) {
                int borderRadius = g.getFont().getSize() / 3;
                g.fillRoundRect((int)(-bgRect.getWidth() / 2.0 - bgRect.getX()), (int)(-bgRect.getHeight() / 2.0), (int)bgRect.getWidth(), (int)bgRect.getHeight(), borderRadius, borderRadius);
            } else {
                g.fillRect((int)(-bgRect.getWidth() / 2.0 - bgRect.getX()), (int)(-bgRect.getHeight() / 2.0), (int)bgRect.getWidth(), (int)bgRect.getHeight());
            }
        }
        g.setColor(this.color);
        g.drawString(s, (int)(-rect.getWidth() / 2.0 - rect.getX()), (int)(-rect.getHeight() / 2.0 - rect.getY()));
    }

    public void setText(String text) {
        String oldText = this.text;
        boolean oldIsEnabled = this.isEnabled();
        this.text = text;
        this.changeSupport.firePropertyChange("text", oldText, text);
        this.changeSupport.firePropertyChange("enabled", oldIsEnabled, this.isEnabled());
    }

    public String getText() {
        return this.text;
    }

    public void setFont(Font font) {
        Font oldFont = this.font;
        this.font = font;
        this.changeSupport.firePropertyChange("font", oldFont, font);
    }

    @Unbound
    public Font getFont() {
        return this.font;
    }

    public void setSize(int newSize) {
        Font oldFont = this.font;
        this.font = this.font.deriveFont((float)newSize);
        this.changeSupport.firePropertyChange("size", oldFont.getSize(), this.font.getSize());
    }

    public int getSize() {
        return this.font.getSize();
    }

    public boolean isBold() {
        return this.font.isBold();
    }

    public void setBold(boolean bold) {
        Font oldFont = this.font;
        int style = bold ? this.font.getStyle() | 1 : this.font.getStyle() & 0xFFFFFFFE;
        this.font = this.font.deriveFont(style);
        this.changeSupport.firePropertyChange("bold", oldFont.isBold(), this.font.isBold());
    }

    public boolean isItalic() {
        return this.font.isItalic();
    }

    public void setItalic(boolean italic) {
        Font oldFont = this.font;
        int style = italic ? this.font.getStyle() | 2 : this.font.getStyle() & 0xFFFFFFFD;
        this.font = this.font.deriveFont(style);
        this.changeSupport.firePropertyChange("italic", oldFont.isItalic(), this.font.isItalic());
    }

    public void setTile(boolean tile) {
        boolean oldTile = this.tile;
        this.tile = tile;
        this.changeSupport.firePropertyChange("tile", oldTile, tile);
        if (tile) {
            this.setAlign(Alignment.center);
            this.setValign(VerticalAlignment.center);
        }
    }

    public boolean isTile() {
        return this.tile;
    }

    public int getRowOffsetPercent() {
        return this.rowOffsetPercent;
    }

    public void setRowOffsetPercent(int rowOffsetPercent) {
        int oldRowDisplacement = this.rowOffsetPercent;
        this.rowOffsetPercent = rowOffsetPercent;
        this.changeSupport.firePropertyChange("rowOffsetPercent", oldRowDisplacement, rowOffsetPercent);
    }

    public void setAngle(int newAngle) {
        float oldAngle = this.angle;
        this.angle = newAngle;
        this.changeSupport.firePropertyChange("angle", Float.valueOf(oldAngle), (Object)newAngle);
    }

    public int getAngle() {
        return this.angle;
    }

    public void setFace(String fontFace) {
        Font oldFont = this.font;
        this.font = new Font(fontFace, this.font.getStyle(), this.font.getSize());
        this.changeSupport.firePropertyChange("face", oldFont.getName(), this.font.getName());
    }

    public String getFace() {
        return this.font.getFamily();
    }

    public void setStyle(String fontStyle) {
        Font oldFont = this.font;
        int style = 0;
        if (fontStyle.equalsIgnoreCase("bold")) {
            style = 1;
        } else if (fontStyle.equalsIgnoreCase("italic")) {
            style = 2;
        } else if (fontStyle.equalsIgnoreCase("bolditalic")) {
            style = 3;
        }
        this.font = new Font(this.font.getName(), style, this.font.getSize());
        this.changeSupport.firePropertyChange("style", oldFont, this.font);
    }

    public String getStyle() {
        switch (this.font.getStyle()) {
            case 1: {
                return "bold";
            }
            case 2: {
                return "italic";
            }
            case 3: {
                return "bolditalic";
            }
        }
        return "plain";
    }

    public void setColor(Color color) {
        Color oldColor = this.color;
        this.color = color;
        this.changeSupport.firePropertyChange("color", oldColor, color);
    }

    public void setColor(String htmlColor) {
        this.setColor(Colors.getHTMLColor(htmlColor));
    }

    public Color getColor() {
        return this.color;
    }

    public void setShadowColor(Color shadowColor) {
        Color oldShadowColor = this.shadowColor;
        this.shadowColor = shadowColor;
        this.changeSupport.firePropertyChange("shadowColor", oldShadowColor, shadowColor);
    }

    public void setShadowColor(String htmlColor) {
        this.setShadowColor(Colors.getHTMLColor(htmlColor));
    }

    public Color getShadowColor() {
        return this.shadowColor;
    }

    public int getShadowDistance() {
        return this.shadowDistance;
    }

    public void setShadowDistance(int shadowDistance) {
        int oldShadowDistance = this.shadowDistance;
        this.shadowDistance = shadowDistance;
        this.changeSupport.firePropertyChange("shadowDistance", oldShadowDistance, shadowDistance);
    }

    public int getStrengthPercent() {
        return this.strengthPercent;
    }

    public void setStrengthPercent(int strengthPercent) {
        int oldStrengthPercent = this.strengthPercent;
        this.strengthPercent = strengthPercent;
        this.changeSupport.firePropertyChange("strengthPercent", oldStrengthPercent, strengthPercent);
    }

    static Replacer fillReplacer(Replacer replacer, Map variables) {
        for (Map.Entry e : variables.entrySet()) {
            if (e.getValue() == null || e.getValue() instanceof Map) continue;
            replacer.add("$" + (String)e.getKey(), e.getValue().toString());
        }
        return replacer;
    }

    public void setMargin(int newMargin) {
        int oldMargin = this.margin;
        this.margin = newMargin;
        this.changeSupport.firePropertyChange("margin", oldMargin, newMargin);
    }

    public int getMargin() {
        return this.margin;
    }

    @Override
    public void setAlign(Alignment newAlign) {
        Alignment oldAlign = this.align;
        this.align = newAlign;
        this.changeSupport.firePropertyChange("align", (Object)oldAlign, (Object)newAlign);
    }

    @Override
    public Alignment getAlign() {
        return this.align;
    }

    @Override
    public void setValign(VerticalAlignment newValign) {
        VerticalAlignment oldValign = this.valign;
        this.valign = newValign;
        this.changeSupport.firePropertyChange("valign", (Object)oldValign, (Object)newValign);
    }

    @Override
    public VerticalAlignment getValign() {
        return this.valign;
    }

    public void setAntialias(boolean newAntialias) {
        boolean oldAntialias = this.antialias;
        this.antialias = newAntialias;
        this.changeSupport.firePropertyChange("antialias", oldAntialias, newAntialias);
    }

    public boolean isAntialias() {
        return this.antialias;
    }

    public void setOffset(int newOffset) {
        int oldOffset = this.offset;
        this.offset = newOffset;
        this.changeSupport.firePropertyChange("offset", oldOffset, newOffset);
    }

    public int getOffset() {
        return this.offset;
    }

    public void setVoffset(int newVoffset) {
        int oldVoffset = this.voffset;
        this.voffset = newVoffset;
        this.changeSupport.firePropertyChange("voffset", oldVoffset, newVoffset);
    }

    public int getVoffset() {
        return this.voffset;
    }

    public void setReferenceWidth(int referenceWidth) {
        int oldReferenceWidth = referenceWidth;
        this.referenceWidth = referenceWidth;
        this.changeSupport.firePropertyChange("referenceWidth", oldReferenceWidth, referenceWidth);
    }

    public int getReferenceWidth() {
        return this.referenceWidth;
    }

    public boolean isRoundedBorder() {
        return this.roundedBorder;
    }

    public void setRoundedBorder(boolean roundedBorder) {
        boolean oldRoundedBorder = roundedBorder;
        this.roundedBorder = roundedBorder;
        this.changeSupport.firePropertyChange("roundedBorder", oldRoundedBorder, roundedBorder);
    }

    public Layering getLayering() {
        return this.layering;
    }

    public void setLayering(Layering layering) {
        Layering oldLayering = this.layering;
        this.layering = layering;
        this.changeSupport.firePropertyChange("layering", (Object)oldLayering, (Object)layering);
    }

    private String stripUnknownVariables(String s) {
        StringBuilder sb = new StringBuilder();
        char[] chars = s.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '$' && i < chars.length - 1 && Character.isJavaIdentifierStart(chars[i + 1])) {
                ++i;
                while (i < chars.length && Character.isJavaIdentifierPart(chars[i])) {
                    ++i;
                }
                continue;
            }
            sb.append(chars[i]);
        }
        return sb.toString();
    }

    @Override
    public JComponent userInterface() {
        if (this.myUI == null) {
            this.myUI = new MyUI();
        }
        return this.myUI;
    }

    @Override
    @Unbound
    public boolean isEnabled() {
        return this.text.length() > 0;
    }

    private static Rectangle grow(Rectangle2D rect, int n) {
        Rectangle r = rect.getBounds();
        r.y -= n;
        r.width += n * 2;
        r.height += n * 2;
        return r;
    }

    private class MyUI
    extends ControlPanel
    implements HasOSDControls {
        @Text(value="effects.~")
        JLabel textLabel = new JLabel();
        JTextField text = new JTextField(14);
        @Text(value="effects.~")
        JLabel sizeLabel = new JLabel();
        JSpinner size = new JSpinner(new SpinnerNumberModel(36, 8, 800, 4));
        @Text(value="effects.~")
        JLabel effectLabel = new JLabel();
        @Text(value="effects.~")
        JCheckBox bold = new JCheckBox("<html><b>Bold</b></html>");
        @Text(value="effects.~")
        JCheckBox italic = new JCheckBox("<html><i>Italic</i></html>");
        @Text(value="effects.~")
        JCheckBox tile = new JCheckBox();
        @Text(value="effects.~")
        JLabel rowOffsetPercentLabel = new JLabel();
        @ToolTipText(value="effects.rowOffsetPercentToolTip")
        JSpinner rowOffsetPercent = new JSpinner(new SpinnerNumberModel(0, 0, 100, 10));
        @Text(value="effects.~")
        JLabel marginLabel = new JLabel();
        JSpinner margin = new JSpinner(new SpinnerNumberModel(5, -99, 99, 1));
        @Text(value="effects.~")
        JLabel angleLabel = new JLabel();
        JSpinner angle = new JSpinner(new SpinnerNumberModel(0, -359, 359, 15));
        @Text(value="effects.~")
        JLabel alignmentLabel = new JLabel();
        JAlignmentSelector alignmentSel = new JAlignmentSelector(TextFilter.this);
        @Text(value="effects.~")
        JLabel colorLabel = new JLabel();
        JAlphaColorSelector color = new JAlphaColorSelector(new JTextField(6));
        @Text(value="effects.~")
        JLabel shadowColorLabel = new JLabel();
        JAlphaColorSelector shadowColor = new JAlphaColorSelector(new JTextField(6));
        @Text(value="effects.~")
        @ToolTipText(value="effects.~ToolTip")
        JLabel shadowDistanceLabel = new JLabel();
        @ToolTipText(value="effects.~ToolTip")
        JSpinner shadowDistance = new JSpinner(new SpinnerNumberModel(0, -20, 20, 1));
        @Text(value="effects.~")
        @ToolTipText(value="effects.~ToolTip")
        JCheckBox roundedBorder = new JCheckBox();
        @ToolTipText(value="effects.~ToolTip")
        @Text(value="effects.~")
        JLabel layeringLabel = new JLabel();
        @ToolTipText(value="effects.~ToolTip")
        JComboBox layering = new JComboBox<Layering>(Layering.values());
        @Text(value="effects.~")
        JLabel strengthPercentLabel = new JLabel();
        JSlider strengthPercent = new JNarrowSlider(1, 100, 100);
        @Text(value="effects.font")
        JLabel faceLabel = new JLabel();
        JFontComboBox face = new JFontComboBox();
        @Text(value="effects.~")
        Action plain = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyUI.this.shadowDistance.setValue(0);
                MyUI.this.strengthPercent.setValue(100);
            }
        };
        @Text(value="effects.~")
        Action shadow = new AbstractAction("Shadow"){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyUI.this.shadowDistance.setValue(4);
                MyUI.this.strengthPercent.setValue(100);
                MyUI.this.shadowColor.setColor(Color.black);
            }
        };
        @Text(value="effects.~")
        Action watermark = new AbstractAction("Watermark"){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyUI.this.shadowDistance.setValue(3);
                MyUI.this.strengthPercent.setValue(20);
                MyUI.this.color.setColor(Color.white);
                MyUI.this.shadowColor.setColor(Color.black);
            }
        };
        @Text(value="effects.~")
        Action background = new AbstractAction("Background"){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyUI.this.shadowDistance.setValue(-5);
                MyUI.this.strengthPercent.setValue(100);
                MyUI.this.color.setColor(Color.white);
                MyUI.this.shadowColor.setColor(new Color(0, 0, 0, 50));
            }
        };

        public MyUI() {
            this.init();
        }

        private void init() {
            Msg.maintainTranslated(this);
            JFormattedTextField tf = ((JSpinner.DefaultEditor)this.size.getEditor()).getTextField();
            Dimension dim = tf.getMaximumSize();
            dim.width = 40;
            tf.setMaximumSize(dim);
            this.strengthPercent.setMinorTickSpacing(10);
            this.strengthPercent.setPaintTicks(true);
            this.face.setPreferredSize(new Dimension(180, this.face.getPreferredSize().height));
            this.add(this.textLabel);
            this.add("tab", this.text);
            this.add("", this.effectLabel);
            JPanel effectPanel = new JPanel(new FlowLayout(3, 0, 0));
            effectPanel.add(new JButton(this.plain));
            effectPanel.add(new JButton(this.shadow));
            effectPanel.add(new JButton(this.watermark));
            effectPanel.add(new JButton(this.background));
            this.add(effectPanel);
            this.add("br", this.faceLabel);
            this.add("tab", this.face);
            this.add(this.sizeLabel);
            this.add("", this.size);
            this.add(this.bold);
            this.add(this.italic);
            this.add(this.angleLabel);
            this.add(this.angle);
            this.add("br", this.colorLabel);
            this.add(this.color);
            this.add("tab", this.shadowColorLabel);
            this.add(this.shadowColor);
            this.add(this.shadowDistanceLabel);
            this.add(this.shadowDistance);
            this.add(this.roundedBorder);
            this.add(this.layeringLabel);
            this.add(this.layering);
            this.add("br", this.strengthPercentLabel);
            this.add("", this.strengthPercent);
            this.add(this.alignmentLabel);
            this.add(this.alignmentSel);
            this.add(this.marginLabel);
            this.add(this.margin);
            this.add(this.tile);
            this.add(this.rowOffsetPercentLabel);
            this.add(this.rowOffsetPercent);
            BeanBinder.getProperties((Object)TextFilter.this, this);
            StateMonitor.monitoring(this.text, this.size, this.bold, this.italic, this.tile, this.rowOffsetPercent, this.margin, this.angle, this.color, this.face, this.shadowColor, this.shadowDistance, this.roundedBorder, this.layering, this.strengthPercent).onUserChange(c -> BeanBinder.setProperties((Object)TextFilter.this, this));
            StateMonitor.monitoring(this.shadowDistance).onChange(c -> this.roundedBorder.setEnabled((Integer)this.shadowDistance.getValue() < 0));
            ComponentUtilities.whenSelectedDisable((AbstractButton)this.tile, this.alignmentLabel, this.alignmentSel);
            ComponentUtilities.whenSelectedEnable((AbstractButton)this.tile, this.rowOffsetPercentLabel, this.rowOffsetPercent);
        }

        @Override
        public void attachOSDControls(JBackgroundPanel display) {
            this.alignmentSel.attachOSDControls(display);
        }

        @Override
        public void detachOSDControls(JBackgroundPanel display) {
            this.alignmentSel.detachOSDControls(display);
        }
    }
}

