/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.filters;

import java.awt.AlphaComposite;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import net.jalbum.filters.AbstractFilter;
import net.jalbum.filters.Aligneable;
import net.jalbum.filters.Alignment;
import net.jalbum.filters.Bounded;
import net.jalbum.filters.HasOSDControls;
import net.jalbum.filters.Layering;
import net.jalbum.filters.VerticalAlignment;
import net.jalbum.filters.ui.JAlignmentSelector;
import se.datadosen.component.ComponentUtilities;
import se.datadosen.component.ControlPanel;
import se.datadosen.component.JBackgroundPanel;
import se.datadosen.component.JFileSelector;
import se.datadosen.component.JNarrowSlider;
import se.datadosen.component.StateMonitor;
import se.datadosen.explorer.JAlbumObject;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.Msg;
import se.datadosen.util.BeanBinder;
import se.datadosen.util.annotations.Text;
import se.datadosen.util.annotations.ToolTipText;
import se.datadosen.util.annotations.Unbound;

public class LogoFilter
extends AbstractFilter
implements Aligneable,
Bounded {
    private static final ImageIcon emptyIcon = new ImageIcon();
    private ImageIcon logo = emptyIcon;
    private String src = "";
    private boolean tile;
    private int rowOffsetPercent = 0;
    private int strengthPercent = 100;
    private boolean antialias = true;
    private Alignment align = Alignment.left;
    private VerticalAlignment valign = VerticalAlignment.top;
    private int margin = 5;
    private int offset = 0;
    private int voffset = 0;
    private int angle = 0;
    private int referenceWidth = 0;
    private int scalePercent = 100;
    private Layering layering = Layering.ALL_OVER;
    private MyUI myUI;
    private Rectangle logoBounds = new Rectangle();

    public LogoFilter() {
    }

    public LogoFilter(boolean closeups, boolean thumbnails) {
        super(closeups, thumbnails);
    }

    @Override
    @Unbound
    public String getName() {
        return Msg.get("effects.logoName");
    }

    @Override
    @Unbound
    public ImageIcon getIcon() {
        return (ImageIcon)Icons.get(LogoFilter.class, "res/stamp.svg", 16);
    }

    @Override
    @Unbound
    public String getDescription() {
        return "Overlay a logo image on top of an image";
    }

    @Override
    public BufferedImage filter(BufferedImage bi, Map vars) {
        if (!this.isEnabled() || this.logo.getImage() == null || "false".equals(vars.get("applyLogo"))) {
            return bi;
        }
        Graphics2D g = bi.createGraphics();
        if (this.antialias) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (this.getScalePercent() < 100 || this.angle % 90 != 0) {
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        }
        Image logoImage = this.logo.getImage();
        double bw = logoImage.getWidth(null) * this.getScalePercent() / 100;
        double bh = logoImage.getHeight(null) * this.getScalePercent() / 100;
        if (bw < 1.0 || bh < 1.0) {
            return bi;
        }
        double radians = (double)this.angle / 180.0 * Math.PI;
        double boxWidth = Math.abs(bw * Math.cos(radians)) + Math.abs(bh * Math.sin(radians));
        double boxHeight = Math.abs(bh * Math.cos(radians)) + Math.abs(-bw * Math.sin(radians));
        int width = bi.getWidth();
        int height = bi.getHeight();
        float scale = vars.getOrDefault("scale", Float.valueOf(1.0f)).floatValue();
        width = (int)((float)width / scale);
        height = (int)((float)height / scale);
        g.scale(scale, scale);
        int x = this.align == Alignment.left ? this.margin : (this.align == Alignment.right ? (int)((double)(width - this.margin) - boxWidth) : (int)(((double)width - boxWidth) / 2.0));
        int y = this.valign == VerticalAlignment.top ? this.margin : (this.valign == VerticalAlignment.bottom ? (int)((double)(height - this.margin) - boxHeight) : (int)(((double)height - boxHeight) / 2.0));
        this.logoBounds.setBounds(x, y, (int)boxWidth, (int)boxHeight);
        g.translate((double)x + boxWidth / 2.0 + (double)this.offset, (double)y + boxHeight / 2.0 + (double)this.voffset);
        if (this.angle != 0) {
            g.rotate(-radians);
        }
        AlphaComposite composite = AlphaComposite.getInstance(this.layering.getRule(), (float)this.strengthPercent / 100.0f);
        g.setComposite(composite);
        if (this.tile) {
            int hyp = (int)Math.sqrt(width * width + height * height);
            int rows = (int)Math.ceil(Math.ceil((double)hyp / bh) / 2.0);
            int cols = (int)Math.ceil(Math.ceil((double)hyp / bw) / 2.0);
            for (int row = -rows; row <= rows; ++row) {
                int rowOffset = (int)bw * this.rowOffsetPercent / 100;
                for (int col = -cols; col <= cols; ++col) {
                    AffineTransform at = g.getTransform();
                    g.translate((double)((int)((bw + (double)this.margin) * (double)col)) + (double)(row * rowOffset) % bw, (double)((int)((bh + (double)this.margin) * (double)row)));
                    g.drawImage(logoImage, (int)(-bw / 2.0), (int)(-bh / 2.0), (int)bw, (int)bh, null);
                    g.setTransform(at);
                }
            }
        } else {
            g.drawImage(logoImage, (int)(-bw / 2.0), (int)(-bh / 2.0), (int)bw, (int)bh, null);
        }
        g.dispose();
        return bi;
    }

    public void setSrc(String imageURL) {
        ImageIcon oldLogo = this.logo;
        try {
            this.src = imageURL;
            URL url = new URL(imageURL);
            this.logo = new ImageIcon(url);
        }
        catch (MalformedURLException ex) {
            this.logo = emptyIcon;
        }
        this.changeSupport.firePropertyChange("src", oldLogo, this.logo);
        this.changeSupport.firePropertyChange("enabled", oldLogo != emptyIcon, this.logo != emptyIcon);
    }

    public void setSrc(ImageIcon logo) {
        ImageIcon oldLogo = this.logo;
        this.logo = logo;
        this.changeSupport.firePropertyChange("src", oldLogo, logo);
        this.changeSupport.firePropertyChange("enabled", oldLogo != emptyIcon, logo != emptyIcon);
    }

    public String getSrc() {
        return this.src;
    }

    public void setTile(boolean tile) {
        boolean oldTile = this.tile;
        this.tile = tile;
        this.changeSupport.firePropertyChange("tile", oldTile, tile);
        if (tile) {
            this.setAlign(Alignment.center);
            this.setValign(VerticalAlignment.center);
        }
    }

    public boolean isTile() {
        return this.tile;
    }

    public int getRowOffsetPercent() {
        return this.rowOffsetPercent;
    }

    public void setRowOffsetPercent(int rowOffsetPercent) {
        int oldRowDisplacement = this.rowOffsetPercent;
        this.rowOffsetPercent = rowOffsetPercent;
        this.changeSupport.firePropertyChange("rowOffsetPercent", oldRowDisplacement, rowOffsetPercent);
    }

    public void setAngle(int newAngle) {
        float oldAngle = this.angle;
        this.angle = newAngle;
        this.changeSupport.firePropertyChange("angle", Float.valueOf(oldAngle), (Object)newAngle);
    }

    public int getAngle() {
        return this.angle;
    }

    public int getStrengthPercent() {
        return this.strengthPercent;
    }

    public void setStrengthPercent(int strengthPercent) {
        if (strengthPercent > 100) {
            strengthPercent = 100;
        } else if (strengthPercent < 0) {
            strengthPercent = 0;
        }
        int oldStrengthPercent = this.strengthPercent;
        this.strengthPercent = strengthPercent;
        this.changeSupport.firePropertyChange("strengthPercent", oldStrengthPercent, strengthPercent);
    }

    public int getScalePercent() {
        return this.scalePercent;
    }

    public void setScalePercent(int scalePercent) {
        if (scalePercent > 100) {
            scalePercent = 100;
        } else if (scalePercent < 1) {
            scalePercent = 1;
        }
        int oldScalePercent = this.scalePercent;
        this.scalePercent = scalePercent;
        this.changeSupport.firePropertyChange("scalePercent", oldScalePercent, scalePercent);
    }

    public void setMargin(int newMargin) {
        int oldMargin = this.margin;
        this.margin = newMargin;
        this.changeSupport.firePropertyChange("margin", oldMargin, newMargin);
    }

    public int getMargin() {
        return this.margin;
    }

    @Override
    public void setAlign(Alignment newAlign) {
        Alignment oldAlign = this.align;
        this.align = newAlign;
        this.changeSupport.firePropertyChange("align", (Object)oldAlign, (Object)newAlign);
    }

    @Override
    public Alignment getAlign() {
        return this.align;
    }

    @Override
    public void setValign(VerticalAlignment newValign) {
        VerticalAlignment oldValign = this.valign;
        this.valign = newValign;
        this.changeSupport.firePropertyChange("valign", (Object)oldValign, (Object)newValign);
    }

    @Override
    public VerticalAlignment getValign() {
        return this.valign;
    }

    public void setAntialias(boolean newAntialias) {
        boolean oldAntialias = this.antialias;
        this.antialias = newAntialias;
        this.changeSupport.firePropertyChange("antialias", oldAntialias, newAntialias);
    }

    public boolean isAntialias() {
        return this.antialias;
    }

    public void setOffset(int newOffset) {
        int oldOffset = this.offset;
        this.offset = newOffset;
        this.changeSupport.firePropertyChange("offset", oldOffset, newOffset);
    }

    public int getOffset() {
        return this.offset;
    }

    public void setVoffset(int newVoffset) {
        int oldVoffset = this.voffset;
        this.voffset = newVoffset;
        this.changeSupport.firePropertyChange("voffset", oldVoffset, newVoffset);
    }

    public int getVoffset() {
        return this.voffset;
    }

    public void setReferenceWidth(int referenceWidth) {
        int oldReferenceWidth = referenceWidth;
        this.referenceWidth = referenceWidth;
        this.changeSupport.firePropertyChange("referenceWidth", oldReferenceWidth, referenceWidth);
    }

    public int getReferenceWidth() {
        return this.referenceWidth;
    }

    public Layering getLayering() {
        return this.layering;
    }

    public void setLayering(Layering layering) {
        Layering oldLayering = this.layering;
        this.layering = layering;
        this.changeSupport.firePropertyChange("layering", (Object)oldLayering, (Object)layering);
    }

    @Override
    public JComponent userInterface() {
        if (this.myUI == null) {
            this.myUI = new MyUI();
        }
        return this.myUI;
    }

    @Override
    @Unbound
    public boolean isEnabled() {
        return this.logo != emptyIcon;
    }

    @Override
    @Unbound
    public Rectangle getBounds() {
        return this.logoBounds;
    }

    public static LogoFilter getFolderOverlay() {
        LogoFilter overlay = new LogoFilter(false, true);
        overlay.setAlign(Alignment.center);
        overlay.setValign(VerticalAlignment.center);
        overlay.setSrc(JAlbumObject.class.getResource("images/folder_closed_faint.png").toExternalForm());
        return overlay;
    }

    private static LogoFilter prepareCenteredOverlay() {
        LogoFilter overlay = new LogoFilter(true, true){

            @Override
            public BufferedImage filter(BufferedImage bi, Map vars) {
                int stage = (Integer)vars.get("stage");
                if (stage == 3) {
                    this.setScalePercent(50);
                } else if (stage == 5) {
                    this.setScalePercent(34);
                }
                return super.filter(bi, vars);
            }
        };
        overlay.setAlign(Alignment.center);
        overlay.setValign(VerticalAlignment.center);
        overlay.setStrengthPercent(70);
        return overlay;
    }

    public static LogoFilter getVideoOverlay() {
        LogoFilter overlay = LogoFilter.prepareCenteredOverlay();
        overlay.setSrc(AlbumBean.class.getResource("images/play.png").toExternalForm());
        return overlay;
    }

    public static LogoFilter getWebLocationOverlay() {
        LogoFilter overlay = LogoFilter.prepareCenteredOverlay();
        overlay.setSrc((ImageIcon)Icons.get("www-icon", 200));
        return overlay;
    }

    private class MyUI
    extends ControlPanel
    implements HasOSDControls {
        @Text(value="effects.imageURL")
        JLabel srcLabel = new JLabel();
        JTextField src = new JTextField(40);
        JFileSelector fileSelector = new JFileSelector(Msg.get("effects.selectLogoImage"), this.src);
        @Text(value="effects.~")
        JLabel marginLabel = new JLabel();
        JSpinner margin = new JSpinner(new SpinnerNumberModel(5, -99, 99, 1));
        @Text(value="effects.~")
        JLabel angleLabel = new JLabel();
        JSpinner angle = new JSpinner(new SpinnerNumberModel(0, -359, 359, 15));
        @Text(value="effects.~")
        @ToolTipText(value="effects.~ToolTip")
        JLabel layeringLabel = new JLabel();
        @ToolTipText(value="effects.~ToolTip")
        JComboBox layering = new JComboBox<Layering>(Layering.values());
        @Text(value="effects.~")
        JCheckBox tile = new JCheckBox();
        @Text(value="effects.~")
        JLabel rowOffsetPercentLabel = new JLabel();
        @ToolTipText(value="effects.rowOffsetPercentToolTip")
        JSpinner rowOffsetPercent = new JSpinner(new SpinnerNumberModel(0, 0, 100, 10));
        @Text(value="effects.alignment")
        JLabel alignmentLabel = new JLabel();
        JAlignmentSelector alignmentSel = new JAlignmentSelector(LogoFilter.this);
        @Text(value="effects.~")
        JLabel strengthPercentLabel = new JLabel();
        JSlider strengthPercent = new JNarrowSlider(1, 100, 100);
        @Text(value="effects.~")
        JLabel scalePercentLabel = new JLabel();
        JSlider scalePercent = new JNarrowSlider(1, 100, 100);
        @Text(value="effects.presets")
        JLabel presetsLabel = new JLabel();
        @Text(value="effects.~")
        Action clear = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyUI.this.src.setText("");
            }
        };
        Action jAlbumEffect = new AbstractAction("jAlbum"){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyUI.this.src.setText("http://jalbum.net/res/press/jalbum_desktop_app.png");
            }
        };
        Action jAlbumDotNetEffect = new AbstractAction("jAlbum.net"){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyUI.this.src.setText("http://jalbum.net/res/press/jalbumnet_logo_900x162.png");
            }
        };
        Action dorEffect = new AbstractAction("Dor"){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyUI.this.src.setText(JAlbum.class.getResource("/icons/standard/decorations/dor-handstanding.png").toExternalForm());
            }
        };

        public MyUI() {
            this.init();
        }

        private void init() {
            Msg.maintainTranslated(this);
            this.fileSelector.setURLFormat(true);
            this.strengthPercent.setMinorTickSpacing(10);
            this.strengthPercent.setPaintTicks(true);
            this.scalePercent.setMinorTickSpacing(10);
            this.scalePercent.setPaintTicks(true);
            this.add(this.srcLabel);
            this.add("tab", this.src);
            this.add(this.fileSelector);
            this.add("br", this.presetsLabel);
            JPanel effectPanel = new JPanel(new FlowLayout(3, 0, 0));
            effectPanel.add(new JButton(this.jAlbumEffect));
            effectPanel.add(new JButton(this.jAlbumDotNetEffect));
            effectPanel.add(new JButton(this.dorEffect));
            effectPanel.add(new JButton(this.clear));
            this.add("tab", effectPanel);
            this.add("br", this.scalePercentLabel);
            this.add("tab", this.scalePercent);
            this.add(this.angleLabel);
            this.add(this.angle);
            this.add(this.layeringLabel);
            this.add(this.layering);
            this.add("br", this.strengthPercentLabel);
            this.add("tab", this.strengthPercent);
            this.add(this.alignmentLabel);
            this.add(this.alignmentSel);
            this.add("", this.marginLabel);
            this.add("", this.margin);
            this.add(this.tile);
            this.add(this.rowOffsetPercentLabel);
            this.add(this.rowOffsetPercent);
            BeanBinder.getProperties((Object)LogoFilter.this, this);
            StateMonitor.monitoring(this.src, this.scalePercent, this.margin, this.angle, this.layering, this.strengthPercent, this.tile, this.rowOffsetPercent).onChange(c -> {
                if (!BeanBinder.isSynchingUI()) {
                    BeanBinder.setProperties((Object)LogoFilter.this, this);
                }
            });
            ComponentUtilities.whenSelectedDisable((AbstractButton)this.tile, this.alignmentLabel, this.alignmentSel);
            ComponentUtilities.whenSelectedEnable((AbstractButton)this.tile, this.rowOffsetPercentLabel, this.rowOffsetPercent);
        }

        @Override
        public void attachOSDControls(JBackgroundPanel display) {
            this.alignmentSel.attachOSDControls(display);
        }

        @Override
        public void detachOSDControls(JBackgroundPanel display) {
            this.alignmentSel.detachOSDControls(display);
        }
    }
}

