/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.filters;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import net.jalbum.filters.AbstractFilter;
import se.datadosen.component.ControlPanel;
import se.datadosen.component.StateMonitor;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.Msg;
import se.datadosen.util.BeanBinder;
import se.datadosen.util.annotations.Text;

public class GrayscaleFilter
extends AbstractFilter {
    private boolean enabled = false;
    private UI myUI;

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public GrayscaleFilter() {
    }

    public GrayscaleFilter(boolean enabled, boolean closeups, boolean thumbnails) {
        super(closeups, thumbnails);
        this.enabled = enabled;
    }

    public void setEnabled(boolean enabled) {
        boolean oldEnabled = this.enabled;
        this.enabled = enabled;
        this.changeSupport.firePropertyChange("enabled", oldEnabled, enabled);
    }

    @Override
    public String getName() {
        return Msg.get("effects.grayscaleName");
    }

    @Override
    public ImageIcon getIcon() {
        return (ImageIcon)Icons.small("grayscale");
    }

    @Override
    public String getDescription() {
        return "Produce a grayscale image";
    }

    @Override
    public BufferedImage filter(BufferedImage bi, Map vars) {
        if (!this.enabled) {
            return bi;
        }
        Graphics2D g = bi.createGraphics();
        RenderingHints rhs = g.getRenderingHints();
        ColorSpace cs = ColorSpace.getInstance(1003);
        ColorConvertOp theOp = new ColorConvertOp(cs, rhs);
        BufferedImage dstImg = new BufferedImage(bi.getWidth(), bi.getHeight(), GrayscaleFilter.getSuitableType(bi));
        theOp.filter(bi, dstImg);
        g.dispose();
        return dstImg;
    }

    private static int getSuitableType(BufferedImage bi) {
        return bi.getTransparency() == 1 ? 1 : 2;
    }

    @Override
    public JComponent userInterface() {
        if (this.myUI == null) {
            this.myUI = new UI();
        }
        return this.myUI;
    }

    private class UI
    extends ControlPanel {
        @Text(value="effects.enabled")
        JCheckBox enabled = new JCheckBox();

        public UI() {
            this.init();
        }

        private void init() {
            Msg.maintainTranslated(this);
            this.add(this.enabled);
            BeanBinder.getProperties((Object)GrayscaleFilter.this, this);
            StateMonitor.monitoring(this.enabled).onUserChange(c -> BeanBinder.setProperties((Object)GrayscaleFilter.this, this));
        }
    }
}

