/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.filters;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.util.Map;
import net.jalbum.util.Profiler;
import se.datadosen.jalbum.JAFilter;

public class ColorProfileFilter
implements JAFilter {
    private static ColorSpace sRGB = ColorSpace.getInstance(1000);

    @Override
    public String getName() {
        return "Apply color profile";
    }

    @Override
    public String getDescription() {
        return "Applies the embedded or given color profile of the source image and returns an image that's in the sRGB color space";
    }

    @Override
    public BufferedImage filter(BufferedImage im, Map vars) {
        return this.filter(im.getColorModel(), im, vars);
    }

    public BufferedImage filter(ColorModel colorModel, BufferedImage im, Map vars) {
        if (colorModel == null || colorModel.getColorSpace().isCS_sRGB()) {
            return im;
        }
        Profiler.Sample _s = Profiler.profile("Color profile filter");
        try {
            ColorConvertOp colorConvert = new ColorConvertOp(colorModel.getColorSpace(), sRGB, null);
            BufferedImage convertedImage = new BufferedImage(im.getWidth(), im.getHeight(), im.getType());
            try {
                colorConvert.filter(im.getRaster(), convertedImage.getRaster());
            }
            catch (IllegalArgumentException ex) {
                BufferedImage bufferedImage = im;
                if (_s != null) {
                    _s.close();
                }
                return bufferedImage;
            }
            BufferedImage bufferedImage = convertedImage;
            return bufferedImage;
        }
        finally {
            if (_s != null) {
                try {
                    _s.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }
}

