/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.filterManager;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.function.Predicate;
import java.util.logging.Level;
import net.jalbum.filterManager.FilterList;
import net.jalbum.filterManager.JAlbumImageFilter;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.ModifiesSize;
import se.datadosen.util.Stopwatch;

public class FilterPipeline {
    private FilterList filterList;

    public FilterPipeline(FilterList filterList) {
        this.filterList = filterList;
    }

    public FilterPipeline(AlbumObject ao) {
        this((FilterList)ao.getProperties().get("filterList"));
    }

    public FilterList getFilterList() {
        return this.filterList;
    }

    public BufferedImage processFilters(BufferedImage im) {
        im = this.processPrescaleFilters(im, null);
        im = this.processPostscaleFilters(im, null);
        return im;
    }

    public BufferedImage processPrescaleFilters(BufferedImage im) {
        return this.processPrescaleFilters(im, null);
    }

    public BufferedImage processPrescaleFilters(BufferedImage im, Predicate<JAlbumImageFilter> f) {
        if (this.filterList == null) {
            return im;
        }
        for (int i = 0; i < this.filterList.getPosition(); ++i) {
            JAlbumImageFilter filter = this.filterList.getFilters().get(i);
            if (filter == null || !filter.isPrescale() || f != null && !f.test(filter)) continue;
            if (JAlbum.logger.isLoggable(Level.FINER)) {
                System.out.println("Rendering with tool " + String.valueOf(filter.getClass()));
            }
            Stopwatch sw = new Stopwatch(filter.getName());
            sw.start();
            im = filter.renderImage(im);
            JAlbum.logger.finer(sw.toString());
        }
        return im;
    }

    public BufferedImage processPostscaleFilters(BufferedImage im) {
        return this.processPostscaleFilters(im, null);
    }

    public BufferedImage processPostscaleFilters(BufferedImage im, Predicate<JAlbumImageFilter> f) {
        if (this.filterList == null) {
            return im;
        }
        for (int i = 0; i < this.filterList.getPosition(); ++i) {
            JAlbumImageFilter filter = this.filterList.getFilters().get(i);
            if (filter == null || !filter.isPostscale() || filter.isPrescale() || f != null && !f.test(filter)) continue;
            if (JAlbum.logger.isLoggable(Level.FINER)) {
                System.out.println("Rendering with tool " + String.valueOf(filter.getClass()));
            }
            Stopwatch sw = new Stopwatch(filter.getName());
            sw.start();
            im = filter.renderImage(im);
        }
        return im;
    }

    public Dimension getPrescaleFilteredSize(Dimension dim) {
        if (this.filterList == null) {
            return dim;
        }
        for (int i = 0; i < this.filterList.getPosition(); ++i) {
            JAlbumImageFilter filter = this.filterList.getFilters().get(i);
            if (filter == null || !filter.isPrescale() || !(filter instanceof ModifiesSize)) continue;
            dim = ((ModifiesSize)((Object)filter)).getModifiedSize(dim, null);
        }
        return dim;
    }

    public Dimension getPostscaleFilteredSize(Dimension dim) {
        if (this.filterList == null) {
            return dim;
        }
        for (int i = 0; i < this.filterList.getPosition(); ++i) {
            JAlbumImageFilter filter = this.filterList.getFilters().get(i);
            if (filter == null || !filter.isPostscale() || filter.isPrescale() || !(filter instanceof ModifiesSize)) continue;
            dim = ((ModifiesSize)((Object)filter)).getModifiedSize(dim, null);
        }
        return dim;
    }
}

