/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.filterManager;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import net.jalbum.filterManager.FilterManager;
import net.jalbum.filterManager.JAlbumImageFilter;
import se.datadosen.component.JPlainButton;
import se.datadosen.component.JRolloverButton;
import se.datadosen.component.RiverLayout;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.Msg;
import se.datadosen.util.annotations.Icon;
import se.datadosen.util.annotations.Text;

public class FilterManagerUI
extends JPanel {
    private static final long serialVersionUID = -4783268072080962112L;
    protected final FilterManager filterManager;
    JButton apply;
    JButton cancel;
    JButton preview;
    JButton info;
    private JPanel filterInfoPanel;
    @Text(value="filters.filterManager.apply")
    @Icon(value="20x20/apply.svg")
    private final Action applyAction = new AbstractAction(){
        private static final long serialVersionUID = -4810095035671646114L;

        @Override
        public void actionPerformed(ActionEvent e) {
            FilterManagerUI.this.filterManager.applyFilter();
        }
    };
    @Text(value="cancel")
    @Icon(value="20x20/cancel.svg")
    private final Action cancelAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            FilterManagerUI.this.filterManager.cancel();
        }
    };

    public FilterManagerUI(FilterManager filterManager) {
        this.filterManager = filterManager;
        Msg.maintainTranslated(this);
        this.apply = new JRolloverButton(this.applyAction);
        this.cancel = new JRolloverButton(this.cancelAction);
        this.preview = new JPlainButton(Icons.small("btn-view"));
        this.info = new JPlainButton(Icons.small("info"));
        this.info.setToolTipText(Msg.get("filters.filterManager.infoToolTip"));
        KeyStroke ks = KeyStroke.getKeyStroke(10, 0);
        this.registerKeyboardAction(this.applyAction, "applyFilter", ks, 2);
        ks = KeyStroke.getKeyStroke(27, 0);
        this.registerKeyboardAction(this.cancelAction, "cancelFilter", ks, 2);
        this.setLayout(new RiverLayout(6, 0));
        this.add("br", Box.createVerticalStrut(10));
        this.add("p center", this.apply);
        this.add(this.cancel);
    }

    public void indicatePreview(boolean indicate) {
        if (indicate) {
            this.preview.setEnabled(true);
            this.preview.setToolTipText(Msg.get("filters.filterManager.previewToolTip"));
        } else {
            this.preview.setEnabled(false);
            this.preview.setToolTipText(Msg.get("filters.filterManager.previewToolTipDisabled"));
        }
    }

    public void loadFilterInfoPanel(JAlbumImageFilter filter) {
        this.filterInfoPanel = new JPanel(new RiverLayout());
        JLabel nameLabel = new JLabel(Msg.get("ui.nameOrdering") + ":");
        nameLabel.setFont(nameLabel.getFont().deriveFont(1));
        this.filterInfoPanel.add("p left", nameLabel);
        this.filterInfoPanel.add(new JLabel(filter.getName()));
        JLabel authorLabel = new JLabel(Msg.get("filters.filterManager.author") + ":");
        authorLabel.setFont(authorLabel.getFont().deriveFont(1));
        this.filterInfoPanel.add("p left", authorLabel);
        this.filterInfoPanel.add(new JLabel(filter.getProperties().getAuthor()));
        JLabel versionLabel = new JLabel(Msg.get("filters.filterManager.version") + ":");
        versionLabel.setFont(versionLabel.getFont().deriveFont(1));
        this.filterInfoPanel.add("p left", versionLabel);
        this.filterInfoPanel.add(new JLabel(filter.getProperties().getVersion()));
        JLabel descriptionLabel = new JLabel(Msg.get("filters.filterManager.description") + ":");
        descriptionLabel.setFont(descriptionLabel.getFont().deriveFont(1));
        this.filterInfoPanel.add("p left", descriptionLabel);
        this.filterInfoPanel.add(new JLabel(filter.getProperties().getDescription()));
        if (filter.getProperties().getHelp() != null && filter.getProperties().getHelp().length() > 1) {
            JLabel helpLabel = new JLabel(Msg.get("ui.helpMenu") + ":");
            helpLabel.setFont(helpLabel.getFont().deriveFont(1));
            this.filterInfoPanel.add("p left", helpLabel);
            this.filterInfoPanel.add(new JLabel(filter.getProperties().getHelp()));
        }
        if (filter.getProperties().getOther() != null && filter.getProperties().getOther().length() > 1) {
            JLabel otherLabel = new JLabel(Msg.get("filters.filterManager.other") + ":");
            otherLabel.setFont(otherLabel.getFont().deriveFont(1));
            this.filterInfoPanel.add("p left", otherLabel);
            this.filterInfoPanel.add(new JLabel(filter.getProperties().getOther()));
        }
    }
}

