/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.filterManager;

import java.awt.Cursor;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import net.jalbum.filterManager.FilterList;
import net.jalbum.filterManager.FilterManagerFriend;
import net.jalbum.filterManager.FilterManagerInterface;
import net.jalbum.filterManager.FilterManagerUI;
import net.jalbum.filterManager.FilterRenderer;
import net.jalbum.filterManager.JAlbumImageFilter;
import se.datadosen.util.BeanBinder;

public class FilterManager
extends FilterRenderer
implements FilterManagerInterface {
    FilterManagerFriend friend;
    FilterManagerUI filterManagerUI;
    JAlbumImageFilter newFilter;
    boolean alreadyUsed = false;

    public FilterManager(FilterManagerFriend friend) {
        this.friend = friend;
        if (friend != null) {
            this.filterManagerUI = new FilterManagerUI(this);
        }
    }

    public BufferedImage setImage(BufferedImage bi, FilterList filterList) {
        if (filterList == null) {
            this.setFilterList(new FilterList());
            this.getFilterList().setVersionNumber(1);
        } else {
            this.setFilterList(filterList);
        }
        this.bi = bi;
        this.biOut = this.renderImage(this.bi, true);
        return this.biOut;
    }

    public BufferedImage getImage() {
        return this.bi;
    }

    public JAlbumImageFilter addFilter(JAlbumImageFilter filter) {
        if (!filter.isPrescale() && !filter.isPostscale()) {
            return filter;
        }
        JAlbumImageFilter existing = this.getFilterList().findExisting(filter);
        this.alreadyUsed = existing != null;
        JAlbumImageFilter jAlbumImageFilter = this.newFilter = existing != null ? existing : filter;
        if (!this.alreadyUsed) {
            this.newFilter.init();
        } else {
            JPanel controls = this.newFilter.getControls();
            if (controls != null) {
                BeanBinder.getProperties((Object)this.newFilter, controls);
            }
        }
        this.newFilter.setFilterManager(this);
        BufferedImage filterInputImage = this.newFilter.isPrescale() && this.filterListHasPostscaleFilters() ? (this.alreadyUsed ? this.renderImage(this.cloneBufferedImage(this.bi), false, this.newFilter) : this.renderImage(this.cloneBufferedImage(this.bi), false)) : (this.alreadyUsed ? this.renderImage(this.cloneBufferedImage(this.bi), false, this.newFilter) : this.biOut);
        this.filterManagerUI.loadFilterInfoPanel(this.newFilter);
        this.newFilter.setPreviewImage(filterInputImage);
        return this.newFilter;
    }

    @Override
    public void setGUIImage(BufferedImage bi) {
        this.friend.setImage(bi);
    }

    @Override
    public BufferedImage renderImage(BufferedImage bi) {
        return this.renderImage(bi, false);
    }

    public BufferedImage renderImage(BufferedImage bi, boolean scaleImage) {
        BufferedImage biOutClone = this.applyPrescaleFilters(bi);
        if (scaleImage) {
            biOutClone = this.scaleImage(biOutClone);
        }
        biOutClone = this.applyPostscaleFilters(biOutClone);
        return biOutClone;
    }

    public BufferedImage renderImage(BufferedImage bi, boolean scaleImage, JAlbumImageFilter skipFilter) {
        BufferedImage biOutClone = this.applyPrescaleFilters(bi, skipFilter);
        if (scaleImage) {
            biOutClone = this.scaleImage(biOutClone);
        }
        biOutClone = this.applyPostscaleFilters(biOutClone, skipFilter);
        return biOutClone;
    }

    public BufferedImage renderImageWithoutPrescale(BufferedImage bi) {
        BufferedImage biOutClone = this.cloneBufferedImage(bi);
        biOutClone = this.applyPostscaleFilters(biOutClone);
        return biOutClone;
    }

    protected BufferedImage scaleImage(BufferedImage bi) {
        BufferedImage out = this.friend.scaleImage(bi);
        this.postscaleCache = this.cloneBufferedImage(out);
        return out;
    }

    public boolean isUndoPossible() {
        return this.getFilterList() != null && this.getFilterList().getPosition() > 0;
    }

    public BufferedImage undo() {
        if (this.getFilterList().getPosition() > 0) {
            this.getFilterList().setPosition(this.getFilterList().getPosition() - 1);
            JAlbumImageFilter undoneFilter = this.getFilterList().getFilters().get(this.getFilterList().getPosition());
            if (undoneFilter.isPrescale()) {
                this.biOut = this.applyPrescaleFilters(this.bi);
                this.biOut = this.scaleImage(this.biOut);
                this.biOut = this.applyPostscaleFilters(this.biOut);
            } else if (undoneFilter.isPostscale() && !undoneFilter.isPrescale()) {
                this.biOut = this.applyPostscaleFilters(this.postscaleCache);
            }
        }
        return this.biOut;
    }

    public boolean isRedoPossible() {
        return this.getFilterList() != null && this.getFilterList().getFilters().size() > this.getFilterList().getPosition();
    }

    public BufferedImage redo() {
        if (this.getFilterList().getFilters().size() > this.getFilterList().getPosition()) {
            this.getFilterList().setPosition(this.getFilterList().getPosition() + 1);
            JAlbumImageFilter redoneFilter = this.getFilterList().getFilters().get(this.getFilterList().getPosition() - 1);
            if (redoneFilter.isPrescale()) {
                this.biOut = redoneFilter.renderImage(this.cloneBufferedImage(this.prescaleCache));
                this.prescaleCache = this.cloneBufferedImage(this.biOut);
                this.biOut = this.scaleImage(this.biOut);
                this.biOut = this.applyPostscaleFilters(this.biOut);
            } else if (redoneFilter.isPostscale() && !redoneFilter.isPrescale()) {
                this.biOut = redoneFilter.renderImage(this.cloneBufferedImage(this.postscaleCache));
            }
        }
        return this.biOut;
    }

    protected BufferedImage renderPreview() {
        BufferedImage previewImage = this.cloneBufferedImage(this.bi);
        if (this.newFilter.isPrescale()) {
            previewImage = this.newFilter.renderImage(this.cloneBufferedImage(this.prescaleCache));
            previewImage = this.friend.scaleImage(previewImage);
            previewImage = this.applyPostscaleFilters(previewImage);
        } else {
            previewImage = this.newFilter.isPostscale() && !this.newFilter.isPrescale() ? this.newFilter.renderImage(this.cloneBufferedImage(this.biOut)) : this.biOut;
        }
        return previewImage;
    }

    public JPanel getFilterControls() {
        return this.newFilter.getControls();
    }

    public JPanel getFilterManagerControls() {
        return this.filterManagerUI;
    }

    @Override
    public void setCursor(Cursor cursor) {
        this.friend.getImageComponent().setCursor(cursor);
    }

    @Override
    public Cursor getCursor() {
        return this.friend.getImageComponent().getCursor();
    }

    protected void applyFilter() {
        this.getFilterList().dropUndone();
        if (!this.alreadyUsed) {
            this.getFilterList().getFilters().add(this.newFilter);
            this.getFilterList().setPosition(this.getFilterList().getPosition() + 1);
        }
        if (this.newFilter.isPrescale() && !this.newFilter.isPostscale()) {
            this.biOut = this.alreadyUsed ? this.applyPrescaleFilters(this.bi) : this.newFilter.renderImage(this.cloneBufferedImage(this.prescaleCache));
            this.prescaleCache = this.cloneBufferedImage(this.biOut);
            this.biOut = this.scaleImage(this.biOut);
            this.biOut = this.applyPostscaleFilters(this.biOut);
        } else if (this.newFilter.isPostscale()) {
            this.biOut = this.alreadyUsed ? this.renderImageWithoutPrescale(this.cloneBufferedImage(this.prescaleCache)) : this.newFilter.renderImage(this.cloneBufferedImage(this.biOut));
        }
        this.friend.filterMenuClosed(this.biOut, true);
    }

    public void cancel() {
        this.friend.filterMenuClosed(this.biOut, false);
    }

    public JAlbumImageFilter getNewFilter() {
        return this.newFilter;
    }
}

