/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.filterManager;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.jalbum.filterManager.JAlbumImageFilter;

public class FilterList
implements Serializable {
    private static final long serialVersionUID = 779419071601057783L;
    public static final int VERSION_NUMBER = 1;
    int position = 0;
    List<JAlbumImageFilter> filters = new ArrayList<JAlbumImageFilter>();
    int versionNumber = 0;

    public int getPosition() {
        return this.position <= this.filters.size() ? this.position : this.filters.size();
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public JAlbumImageFilter findExisting(JAlbumImageFilter filter) {
        for (int i = 0; i < this.getPosition(); ++i) {
            if (!this.filters.get(i).getClass().equals(filter.getClass())) continue;
            return this.filters.get(i);
        }
        return null;
    }

    public List<JAlbumImageFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<JAlbumImageFilter> filters) {
        this.filters = filters;
    }

    public void disposeAll() {
        for (JAlbumImageFilter f : this.filters) {
            f.dispose();
        }
    }

    public void dropUndone() {
        for (int i = this.filters.size() - 1; i >= this.position; --i) {
            this.filters.remove(i);
        }
    }

    public int getVersionNumber() {
        return this.versionNumber;
    }

    public void setVersionNumber(int versionNumber) {
        this.versionNumber = versionNumber;
    }

    public static FilterList clone(FilterList fl) {
        if (fl == null) {
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (XMLEncoder e = new XMLEncoder(new BufferedOutputStream(bos));){
            e.writeObject(fl);
        }
        XMLDecoder d = new XMLDecoder(new BufferedInputStream(new ByteArrayInputStream(bos.toByteArray())));
        fl = (FilterList)d.readObject();
        d.close();
        return fl;
    }
}

