/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.component;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import net.jalbum.component.JImageComponent;
import se.datadosen.util.Platform;

public class JZoomScrollPane
extends JScrollPane {
    private DelayEffect filter = new DelayEffect();
    double factor = 20.0;

    public JZoomScrollPane() {
        super(21, 31);
        if (Platform.isWindows()) {
            this.factor = 5.0;
        }
        this.init();
    }

    public JImageComponent getImageComponent() {
        return (JImageComponent)this.getViewport().getView();
    }

    private void init() {
        this.setViewportView(new JImageComponent());
        this.setWheelScrollingEnabled(false);
        this.initListeners();
    }

    private void initListeners() {
        MouseAdapter ma = new MouseAdapter(){
            private Point plantPoint;

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                JZoomScrollPane.this.zoomBySteps(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                JZoomScrollPane.this.setCursor(Cursor.getPredefinedCursor(12));
                this.plantPoint = e.getPoint();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                JZoomScrollPane.this.setCursor(Cursor.getPredefinedCursor(0));
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                this.dragViewport(e);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                JImageComponent comp = JZoomScrollPane.this.getImageComponent();
                if ((e.getModifiersEx() & 0x340) != 0) {
                    if (comp.getZoomLevel() == 1.0) {
                        comp.zoomToMin();
                    } else {
                        Point clickPos = JZoomScrollPane.this.mousePosRelativeImage(e);
                        Rectangle boundsBefore = comp.getImageBounds();
                        comp.zoomToOneToOne();
                        JZoomScrollPane.this.moveViewportRelativeMouse(clickPos, boundsBefore);
                    }
                }
            }

            private void dragViewport(MouseEvent e) {
                if (this.plantPoint == null) {
                    JZoomScrollPane.this.setCursor(Cursor.getPredefinedCursor(12));
                    this.plantPoint = e.getPoint();
                }
                Point viewPos = JZoomScrollPane.this.getViewport().getViewPosition();
                Point mousePos = e.getPoint();
                e.translatePoint(-this.plantPoint.x, -this.plantPoint.y);
                Point mouseChange = e.getPoint();
                this.plantPoint = mousePos;
                viewPos.x -= mouseChange.x;
                viewPos.y -= mouseChange.y;
                JZoomScrollPane.ensurePositive(viewPos);
                JZoomScrollPane.this.getViewport().setViewPosition(viewPos);
            }
        };
        this.getViewport().addMouseMotionListener(ma);
        this.getViewport().addMouseWheelListener(ma);
        this.getViewport().addMouseListener(ma);
    }

    public void setViewPosition(Point p) {
        JZoomScrollPane.ensurePositive(p);
        this.getViewport().setViewPosition(p);
    }

    public double getZoomLevel() {
        return this.getImageComponent().getZoomLevel();
    }

    public void setZoomLevel(double zoomLevel) {
        JImageComponent comp = this.getImageComponent();
        Rectangle boundsBefore = comp.getImageBounds();
        comp.setZoomLevel(zoomLevel);
        Rectangle r = this.getViewport().getViewRect();
        Point clickPos = new Point(r.x + r.width / 2, r.y + r.height / 2);
        this.moveViewportRelativeMouse(clickPos, boundsBefore);
    }

    public void zoomBySteps(MouseWheelEvent e) {
        JImageComponent comp = this.getImageComponent();
        Point clickPos = this.mousePosRelativeImage(e);
        Rectangle boundsBefore = comp.getImageBounds();
        double rotation = this.filter.get(e.getPreciseWheelRotation());
        comp.changeZoomLevel(-rotation / this.factor);
        this.moveViewportRelativeMouse(clickPos, boundsBefore);
    }

    private Point mousePosRelativeImage(MouseEvent e) {
        JImageComponent comp = this.getImageComponent();
        Rectangle ib = comp.getImageBounds();
        MouseEvent converted = SwingUtilities.convertMouseEvent(this, e, comp);
        Point clickPos = converted.getPoint();
        clickPos.x -= ib.x;
        clickPos.y -= ib.y;
        return clickPos;
    }

    private void moveViewportRelativeMouse(Point clickPos, Rectangle boundsBefore) {
        JImageComponent comp = this.getImageComponent();
        JZoomScrollPane.ensurePositive(clickPos);
        Point vPos = this.getViewport().getViewPosition();
        Rectangle boundsAfter = comp.getImageBounds();
        float scale = (float)boundsAfter.width / (float)boundsBefore.width;
        Point scaled = new Point(Math.round((float)clickPos.x * scale), Math.round((float)clickPos.y * scale));
        Point newVPos = new Point(scaled.x - (clickPos.x - vPos.x), scaled.y - (clickPos.y - vPos.y));
        newVPos.x -= boundsBefore.x;
        newVPos.y -= boundsBefore.y;
        JZoomScrollPane.ensurePositive(newVPos);
        this.getViewport().setViewPosition(newVPos);
    }

    private static void ensurePositive(Point p) {
        if (p.x < 0) {
            p.x = 0;
        }
        if (p.y < 0) {
            p.y = 0;
        }
    }

    private static class DelayEffect {
        private double last;

        private DelayEffect() {
        }

        public double get(double val) {
            this.last = (val + this.last) / 2.0;
            return this.last;
        }
    }
}

