/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.component;

import java.awt.Color;
import java.awt.SystemColor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.DropMode;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import net.jalbum.component.JDraggableList;
import net.jalbum.component.MyDragListener;
import se.datadosen.jalbum.JAlbumColor;

public class JStaticList<E>
extends JDraggableList<E> {
    public JStaticList(DefaultListModel<E> dataModel) {
        super(dataModel);
        this.init();
    }

    public JStaticList(E[] listData) {
        super(listData);
        this.init();
    }

    public JStaticList() {
        this.init();
    }

    private void init() {
        this.setTransferHandler(new ConsumingDropHandler());
        this.setDropMode(DropMode.ON);
        Color c = UIManager.getColor("inactiveCaptionBorder");
        if (c == null) {
            c = SystemColor.textInactiveText;
        }
        this.setBackground(JAlbumColor.blend(c, this.getBackground(), 0.85));
    }

    private static class ConsumingDropHandler<E>
    extends TransferHandler {
        private ConsumingDropHandler() {
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            if (!support.isDataFlavorSupported(JDraggableList.listItemsFlavor)) {
                return false;
            }
            return support.getDropAction() == 2;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            try {
                if (!this.canImport(support)) {
                    return false;
                }
                try {
                    List items = (List)support.getTransferable().getTransferData(JDraggableList.listItemsFlavor);
                    DefaultListModel sourceModel = MyDragListener.currentSource != null ? (DefaultListModel)MyDragListener.currentSource.getModel() : null;
                    for (Object item : items) {
                        int existingIndex;
                        if (support.getDropAction() != 2 || sourceModel == null || (existingIndex = sourceModel.indexOf(item)) == -1) continue;
                        sourceModel.removeElementAt(existingIndex);
                    }
                }
                catch (UnsupportedFlavorException | IOException ex) {
                    Logger.getLogger(ConsumingDropHandler.class.getName()).log(Level.SEVERE, null, ex);
                }
                return true;
            }
            catch (RuntimeException ex) {
                ex.printStackTrace(System.err);
                return false;
            }
        }
    }
}

