/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.component;

import java.awt.GraphicsConfiguration;
import java.awt.HeadlessException;
import java.awt.Window;
import javax.swing.JFrame;
import net.jalbum.component.RememberedName;
import se.datadosen.jalbum.Config;
import se.datadosen.util.WindowUtilities;

public class JRememberedFrame
extends JFrame {
    public JRememberedFrame() throws HeadlessException {
        super(WindowUtilities.getLastScreen(JRememberedFrame.getAnnotatedWindowClass()));
        WindowUtilities.loadBounds(this);
    }

    public JRememberedFrame(GraphicsConfiguration gc) {
        super(gc);
        WindowUtilities.loadBounds(this);
    }

    public JRememberedFrame(String title) throws HeadlessException {
        super(title, WindowUtilities.getLastScreen(JRememberedFrame.getAnnotatedWindowClass()));
        WindowUtilities.loadBounds(this);
    }

    public JRememberedFrame(String title, GraphicsConfiguration gc) {
        super(title, gc);
        WindowUtilities.loadBounds(this);
    }

    @Override
    public void setVisible(boolean visible) {
        if (!visible) {
            WindowUtilities.saveBounds(this);
        }
        super.setVisible(visible);
    }

    private static Class getAnnotatedWindowClass() {
        StackTraceElement[] stackTrace;
        for (StackTraceElement element : stackTrace = Thread.currentThread().getStackTrace()) {
            try {
                RememberedName rn;
                Class<?> clazz = Class.forName(element.getClassName());
                if (!JRememberedFrame.class.isAssignableFrom(clazz) || clazz == JRememberedFrame.class || (rn = clazz.getAnnotation(RememberedName.class)) == null) continue;
                return clazz;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace(System.out);
            }
        }
        return null;
    }

    public static void onExit() {
        for (Window win : Window.getWindows()) {
            WindowUtilities.saveBounds(win);
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (Config.getConfig().isRememberWindowBounds()) {
                JRememberedFrame.onExit();
            }
        }));
    }
}

