/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.component;

import io.nayuki.qrcodegen.QrCode;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.imageio.ImageIO;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import net.jalbum.util.JavaImageSelection;
import net.jalbum.util.QR;
import se.datadosen.component.ChooserFactory;
import se.datadosen.component.FileChooser;
import se.datadosen.component.RiverLayout;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.MyDesktop;
import se.datadosen.util.Debug;
import se.datadosen.util.LambdaAction;
import se.datadosen.util.annotations.Icon;
import se.datadosen.util.annotations.Text;

public class JQRComponent
extends JPanel {
    String url;
    JLabel qrLabel = new JLabel();
    @Icon(value="16x16/open-in-browser.svg")
    @Text(value="edit.open")
    Action openUrl = new LambdaAction(() -> {
        try {
            Desktop.getDesktop().browse(new URI(this.url));
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
        catch (IOException ex) {
            Debug.showErrorDialog(this, ex);
        }
    });
    @Text(value="ui.copyURLToClipboard")
    @Icon(value="16x16/copy.svg")
    Action copyURLToClipboard = new LambdaAction(() -> {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(new StringSelection(this.url), null);
    });
    @Text(value="ui.copyToClipboard")
    @Icon(value="16x16/copy.svg")
    Action copyToClipboard = new LambdaAction(() -> {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(new JavaImageSelection(this.getImage(this.qrLabel.getForeground(), this.qrLabel.getBackground())), null);
    });
    @Text(value="ui.saveAs", postfix="...")
    Action saveAs = new LambdaAction(() -> {
        FileChooser chooser = ChooserFactory.createFileChooser(SwingUtilities.getWindowAncestor(this));
        chooser.setSelectedFile(new File("qr-code.png"));
        chooser.showSaveDialog(this);
        File selected = chooser.getSelectedFile();
        if (selected != null) {
            try {
                ImageIO.write((RenderedImage)this.getImage(Color.black, Color.white), "png", selected);
                MyDesktop.getDesktop().browseFileDirectory(selected);
            }
            catch (IOException ex) {
                Debug.showErrorDialog(this, ex);
            }
        }
    });
    @Text(value="print.print")
    @Icon(value="16x16/printer.svg")
    Action print = new LambdaAction(() -> {
        try {
            File tmpFile = File.createTempFile("qr-code", "png");
            ImageIO.write((RenderedImage)this.getImage(Color.black, Color.white), "png", tmpFile);
            tmpFile.deleteOnExit();
            Desktop.getDesktop().print(tmpFile);
        }
        catch (IOException ex) {
            Debug.showErrorDialog(this, ex);
        }
    });
    @Text(value="ui.keepOpen")
    JCheckBoxMenuItem keepOpenItem = new JCheckBoxMenuItem();
    @Text(value="ui.qrCodePrompt")
    JLabel promptLabel = new JLabel();
    JLabel rightClickLabel = new JLabel();

    public JQRComponent() {
        this("");
    }

    public JQRComponent(String url) {
        super(new RiverLayout());
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        Msg.setTexts(this);
        Msg.setIcons(this);
        this.rightClickLabel.setText("(" + Msg.get("ui.rightClickForOptions") + ")");
        this.rightClickLabel.setFont(this.rightClickLabel.getFont().deriveFont(this.rightClickLabel.getFont().getSize2D() - 1.0f));
        this.add("center", this.promptLabel);
        this.add("br", this.qrLabel);
        this.add("br", this.rightClickLabel);
        this.qrLabel.setBackground(Color.white);
        this.qrLabel.setForeground(Color.black);
        JPopupMenu popup = new JPopupMenu();
        popup.add(this.openUrl);
        popup.add(this.copyURLToClipboard);
        popup.add(this.copyToClipboard);
        popup.add(this.saveAs);
        popup.add(this.print);
        popup.addSeparator();
        popup.add(this.keepOpenItem);
        this.setComponentPopupMenu(popup);
        this.setUrl(url);
    }

    public void setUrl(String url) {
        this.url = url;
        this.openUrl.putValue("Name", Msg.get("edit.open") + " " + this.shortenUrl(url));
        this.qrLabel.setIcon(new ImageIcon(this.getImage(this.qrLabel.getForeground(), this.qrLabel.getBackground())));
        this.repaint();
    }

    private BufferedImage getImage(Color foreground, Color background) {
        QrCode qr = QrCode.encodeText((CharSequence)this.url, (QrCode.Ecc)QrCode.Ecc.MEDIUM);
        return QR.toImage(qr, 6, 2, JQRComponent.toInt(background), JQRComponent.toInt(foreground));
    }

    private static int toInt(Color c) {
        return c.getRed() << 16 | c.getGreen() << 8 | c.getBlue();
    }

    private String shortenUrl(String url) {
        int questionIndex = url.indexOf(63);
        return questionIndex != -1 ? url.substring(0, questionIndex) : url;
    }

    public boolean isKeepOpen() {
        return this.keepOpenItem.isSelected();
    }
}

