/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.component;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.channels.ClosedByInterruptException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableValue;
import javax.swing.JComponent;
import javax.swing.JViewport;
import se.datadosen.jalbum.JAlbumColor;
import se.datadosen.util.GraphicsUtilities;
import se.datadosen.util.NamedThreadFactory;

public class JImageComponent
extends JComponent {
    public final BooleanProperty workingProperty = new SimpleBooleanProperty();
    private final IntegerProperty workersProperty = new SimpleIntegerProperty(0);
    private ScheduledExecutorService delayedService = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("Delayed service"));
    private ImageProvider provider;
    private ScheduledFuture imageLoader;
    private Image initial;
    private Image image;
    private Dimension fullImageSize = new Dimension();
    private double zoomLevel;
    private boolean scaleToMaxSize = false;

    public JImageComponent() {
        this.init();
    }

    public JImageComponent(BufferedImage image) {
        this.setImage(image);
        this.init();
    }

    private void init() {
        this.setBackground(JAlbumColor.imageBackground);
        this.setOpaque(true);
        this.workingProperty.bind((ObservableValue)this.workersProperty.greaterThan(0));
    }

    public Image getImage() {
        return this.image != null ? this.image : this.initial;
    }

    public void setImage(BufferedImage image) {
        if (image != null) {
            this.setImage(image, new Dimension(image.getWidth(), image.getHeight()));
        } else {
            this.setImage(null, null);
        }
    }

    public void setImage(Image image, Dimension fullSize) {
        Image oldImage = this.getImage();
        this.initial = image;
        this.image = null;
        this.fullImageSize = new Dimension();
        this.zoomToMin();
        if (image != null) {
            if (fullSize != null) {
                this.fullImageSize = fullSize;
            } else {
                this.fullImageSize.width = image.getWidth(null);
                this.fullImageSize.height = image.getHeight(null);
            }
        }
        this.revalidate();
        this.repaint();
        this.firePropertyChange("image", oldImage, image);
    }

    public Future setImageAsync(ImageProvider imageProvider, Dimension fullSize) {
        if (this.imageLoader != null && !this.imageLoader.isDone()) {
            this.imageLoader.cancel(true);
        }
        Future<?> future = this.delayedService.submit(() -> {
            try {
                this.workStarted();
                this.setImage(imageProvider.getImage(this.getPreferredSize()), fullSize);
            }
            catch (ClosedByInterruptException closedByInterruptException) {
            }
            catch (IOException ex) {
                System.err.println(ex);
            }
            finally {
                this.workDone();
            }
        });
        return future;
    }

    public void setImageProvider(ImageProvider provider) {
        this.provider = provider;
    }

    public void scheduleReload(Dimension newDim) {
        if (this.provider == null) {
            throw new IllegalStateException("No image provider installed");
        }
        if (this.imageLoader != null && !this.imageLoader.isDone()) {
            this.imageLoader.cancel(true);
        }
        this.imageLoader = this.delayedService.schedule(() -> {
            try {
                this.workStarted();
                this.replaceImage(this.provider.getImage(newDim));
            }
            catch (ClosedByInterruptException closedByInterruptException) {
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
            }
            finally {
                this.workDone();
            }
        }, 200L, TimeUnit.MILLISECONDS);
    }

    public void replaceImage(Image fullSizeImage) {
        Image oldImage = this.getImage();
        this.initial = fullSizeImage;
        this.image = null;
        this.firePropertyChange("imageReplaced", oldImage, fullSizeImage);
        this.repaint();
    }

    private JViewport getParentViewport() {
        Container parent;
        for (parent = this.getParent(); parent != null && !(parent instanceof JViewport); parent = parent.getParent()) {
        }
        return (JViewport)parent;
    }

    private boolean isInstalled() {
        Dimension bounds = this.getParentViewport().getExtentSize();
        boolean installed = bounds.width > 0 && bounds.height > 0;
        return installed;
    }

    @Override
    public Dimension getPreferredSize() {
        boolean installed = this.isInstalled();
        Dimension pref = new Dimension();
        double zoomFactor = this.zoomLevel;
        if (installed) {
            zoomFactor = this.toZoomFactor(this.zoomLevel);
        }
        pref.width = (int)((double)this.fullImageSize.width * zoomFactor);
        pref.height = (int)((double)this.fullImageSize.height * zoomFactor);
        if (installed) {
            Dimension bounds = this.getParentViewport().getExtentSize();
            pref.width = Math.max(pref.width, bounds.width);
            pref.height = Math.max(pref.height, bounds.height);
        }
        return pref;
    }

    public boolean isScaleToMaxSize() {
        return this.scaleToMaxSize;
    }

    public void setScaleToMaxSize(boolean scaleToMaxSize) {
        this.scaleToMaxSize = scaleToMaxSize;
    }

    @Override
    protected void paintComponent(Graphics g2d) {
        Graphics2D g = (Graphics2D)g2d;
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        if (this.image == null && this.initial != null) {
            this.image = this.getGraphicsConfiguration().createCompatibleImage(this.initial.getWidth(null), this.initial.getHeight(null));
            Graphics tmp = this.image.getGraphics();
            tmp.drawImage(this.initial, 0, 0, null);
            this.initial = null;
        }
        if (this.image != null) {
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            Rectangle bounds = this.getImageBounds();
            if (this.scaleToMaxSize && bounds.width < this.getWidth() && bounds.height < this.getHeight()) {
                double widthScale = (double)this.getWidth() / (double)bounds.width;
                double heightScale = (double)this.getHeight() / (double)bounds.height;
                double minScale = Math.min(widthScale, heightScale);
                bounds.width = (int)((double)bounds.width * minScale + 0.5);
                bounds.height = (int)((double)bounds.height * minScale + 0.5);
                bounds.x = (this.getWidth() - bounds.width) / 2;
                bounds.y = (this.getHeight() - bounds.height) / 2;
            }
            g.drawImage(this.image, bounds.x, bounds.y, bounds.width, bounds.height, null);
        }
    }

    private double getMinZoomFactor() {
        Dimension bounds = this.getParentViewport().getExtentSize();
        double widthScale = (double)this.fullImageSize.width / (double)bounds.width;
        double heightScale = (double)this.fullImageSize.height / (double)bounds.height;
        double factor = 1.0 / Math.max(widthScale, heightScale);
        return Math.min(factor, 1.0);
    }

    public boolean isZoomeable() {
        return this.getImage() != null && this.getMinZoomFactor() < 1.0;
    }

    public void zoomToMin() {
        this.setZoomLevel(0.0);
    }

    void zoomToOneToOne() {
        this.setZoomLevel(1.0);
    }

    public double getZoomLevel() {
        return this.zoomLevel;
    }

    private Dimension getCachedImageSize() {
        Image im = this.getImage();
        if (im != null) {
            return new Dimension(im.getWidth(null), im.getHeight(null));
        }
        return new Dimension(0, 0);
    }

    public void setZoomLevel(double zoomLevel) {
        if (zoomLevel == 0.0 || this.isZoomeable()) {
            double oldZoomLevel = this.zoomLevel;
            zoomLevel = Math.max(zoomLevel, 0.0);
            this.zoomLevel = zoomLevel = Math.min(zoomLevel, 1.0);
            Dimension newDim = this.getPreferredSize();
            this.setSize(newDim);
            this.firePropertyChange("zoomLevel", oldZoomLevel, zoomLevel);
            if (zoomLevel > 0.0 && this.provider != null && JImageComponent.largerThan(newDim, this.getCachedImageSize())) {
                this.scheduleReload(newDim);
            }
        }
    }

    public void changeZoomLevel(double delta) {
        this.setZoomLevel(this.zoomLevel + delta);
    }

    public double toZoomFactor(double zoomLevel) {
        zoomLevel = Math.max(zoomLevel, 0.0);
        double zoomFactor = zoomLevel = Math.min(zoomLevel, 1.0);
        if (zoomLevel < 1.0) {
            double minZoomFactor = this.getMinZoomFactor();
            zoomFactor = minZoomFactor + (1.0 - minZoomFactor) * zoomLevel;
        }
        return zoomFactor;
    }

    public Dimension getImageSize() {
        Dimension compSize = this.getSize();
        Dimension is = GraphicsUtilities.fitWithinBounds(this.fullImageSize.width, this.fullImageSize.height, compSize);
        return is;
    }

    public Rectangle getImageBounds() {
        Dimension bounds = this.getSize();
        Dimension fitted = GraphicsUtilities.fitWithinBounds(this.fullImageSize.width, this.fullImageSize.height, bounds);
        int x = 0;
        int y = 0;
        if (fitted.width < bounds.width) {
            x = (bounds.width - fitted.width) / 2;
        }
        if (fitted.height < bounds.height) {
            y = (bounds.height - fitted.height) / 2;
        }
        return new Rectangle(x, y, fitted.width, fitted.height);
    }

    private static boolean largerThan(Dimension d1, Dimension d2) {
        return d1.width > d2.width || d1.height > d2.height;
    }

    private synchronized void workStarted() {
        this.workersProperty.set(this.workersProperty.get() + 1);
    }

    private synchronized void workDone() {
        if (this.workersProperty.get() > 0) {
            this.workersProperty.set(this.workersProperty.get() - 1);
        }
    }

    @FunctionalInterface
    public static interface ImageProvider {
        public Image getImage(Dimension var1) throws IOException;
    }
}

