/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.component;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import net.jalbum.component.Selectable;

public class JCheckBoxList<E>
extends JList<Selectable<E>> {
    protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    private Icon checkIcon;

    public JCheckBoxList() {
        this(false);
    }

    public JCheckBoxList(ListModel<Selectable<E>> dataModel) {
        super(dataModel);
        this.init(false);
    }

    public JCheckBoxList(Selectable<E>[] listData) {
        super(listData);
        this.init(false);
    }

    public JCheckBoxList(boolean checkOnSelect) {
        this.init(false);
    }

    private void init(final boolean checkOnSelect) {
        this.setCellRenderer(new CheckBoxCellRenderer());
        this.checkIcon = UIManager.getIcon("CheckBox.icon");
        this.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ JCheckBoxList this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void mousePressed(MouseEvent e) {
                int index = this.this$0.locationToIndex(e.getPoint());
                if (index != -1 && index == this.this$0.getSelectedIndex()) {
                    Selectable s = (Selectable)this.this$0.getModel().getElementAt(index);
                    Point p = e.getPoint();
                    if (checkOnSelect || p.x <= this.this$0.checkIcon.getIconWidth()) {
                        s.toggleSelection();
                        this.this$0.repaint();
                    }
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int index;
                if (e.getKeyCode() == 32 && (index = JCheckBoxList.this.getSelectedIndex()) != -1) {
                    Selectable s = (Selectable)JCheckBoxList.this.getModel().getElementAt(index);
                    s.toggleSelection();
                    JCheckBoxList.this.repaint();
                }
            }
        });
        this.setSelectionMode(0);
    }

    public JCheckBoxList small() {
        Font f = this.getFont();
        float newSize = Math.max(f.getSize2D() - 3.0f, 9.0f);
        this.setFont(f.deriveFont(newSize));
        return this;
    }

    public class CheckBoxCellRenderer<E>
    extends JCheckBox
    implements ListCellRenderer<Selectable<E>> {
        private Color fg = this.getForeground();
        private Color bg = this.getBackground();

        @Override
        public Component getListCellRendererComponent(JList<? extends Selectable<E>> list, Selectable<E> value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setBackground(isSelected ? JCheckBoxList.this.getSelectionBackground() : this.bg);
            this.setForeground(isSelected ? JCheckBoxList.this.getSelectionForeground() : this.fg);
            this.setSelected(value.isSelected());
            this.setFocusPainted(false);
            this.setBorderPainted(true);
            this.setText(value.toString());
            this.setFont(JCheckBoxList.this.getFont());
            return this;
        }
    }
}

