/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.component;

import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.border.Border;

class DraggableBorder
implements Border {
    private static DraggableBorder instance;
    private static final int KNOB_SIZE = 9;
    private static final int KNOB_MARGIN = 5;
    private final boolean horizontal;
    private final boolean small;
    private final int scale;
    private final Insets borderInsets;

    public static DraggableBorder getInstance(boolean horizontal, boolean small) {
        if (instance == null || DraggableBorder.instance.horizontal != horizontal || DraggableBorder.instance.small != small) {
            instance = new DraggableBorder(horizontal, small);
        }
        return instance;
    }

    private DraggableBorder(boolean horizontal, boolean small) {
        this.horizontal = horizontal;
        this.small = small;
        this.scale = small ? 1 : 2;
        this.borderInsets = new Insets(this.scale * 2, this.scale * 2, this.scale * 2, 5 * this.scale * 2 + 9);
    }

    @Override
    public void paintBorder(Component c, Graphics g2d, int x, int y, int width, int height) {
        Graphics2D g = (Graphics2D)g2d;
        g.translate(x, y);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g.setStroke(new BasicStroke(g.getFont().getSize2D() / 11.0f));
        int nLines = 3;
        int spacing = 3;
        int knobHeight = (nLines - 1) * spacing;
        if (this.horizontal) {
            int knobY = (height - 9) / 2;
            for (int i = 0; i < 3; ++i) {
                g.drawLine(width - 5 * this.scale - 9 + spacing * i, knobY, width - 5 * this.scale - 9 + spacing * i, knobY + knobHeight);
            }
        } else {
            int knobY = (height - knobHeight) / 2;
            for (int i = 0; i < 3; ++i) {
                g.drawLine(width - 5 * this.scale - 9, knobY + spacing * i, width - 5 * this.scale, knobY + spacing * i);
            }
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.borderInsets;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

