/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.browser;

import java.awt.EventQueue;
import java.awt.SecondaryLoop;
import java.awt.Toolkit;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.concurrent.Worker;
import javafx.embed.swing.JFXPanel;
import javafx.event.EventHandler;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.TextInputDialog;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebErrorEvent;
import javafx.scene.web.WebEvent;
import javafx.scene.web.WebHistory;
import javafx.scene.web.WebView;
import javafx.stage.Stage;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import net.jalbum.browser.BrowserWindow;
import net.jalbum.browser.WebBrowser;
import netscape.javascript.JSObject;
import org.w3c.dom.Document;
import se.datadosen.util.IO;

public class WebViewBrowser
implements WebBrowser {
    private WebView webView;
    private WebEngine engine;
    private Worker<Void> loadWorker;
    private ObjectProperty<Worker.State> stateProperty = new AWTObjectProperty<Worker.State>(Worker.State.READY);
    private StringProperty locationProperty = new AWTStringProperty();
    private StringProperty titleProperty = new AWTStringProperty();
    private BooleanProperty canGoBackProperty = new AWTBooleanProperty(false);
    private BooleanProperty canGoForwardProperty = new AWTBooleanProperty(false);
    private JFXPanel jxPanel = new JFXPanel();
    private Throwable throwable;
    final EventQueue eventQueue;
    SecondaryLoop loop;
    private JavaBridge bridge = new JavaBridge();
    public static WebEngine webEngine;

    public WebViewBrowser() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        this.eventQueue = tk.getSystemEventQueue();
        this.loop = this.eventQueue.createSecondaryLoop();
        Platform.runLater(() -> {
            try {
                this.webView = new WebView();
                this.jxPanel.setScene(new Scene((Parent)this.webView));
                this.engine = this.webView.getEngine();
                this.engine.setJavaScriptEnabled(true);
                this.loadWorker = this.engine.getLoadWorker();
                this.stateProperty.bind((ObservableValue)this.loadWorker.stateProperty());
                this.locationProperty.bind((ObservableValue)this.engine.locationProperty());
                this.titleProperty.bind((ObservableValue)this.engine.titleProperty());
                WebHistory history = this.engine.getHistory();
                this.canGoBackProperty.bind((ObservableValue)history.currentIndexProperty().greaterThan(0));
                this.canGoForwardProperty.bind((ObservableValue)history.currentIndexProperty().add(1).lessThan((ObservableNumberValue)Bindings.size((ObservableList)history.getEntries())));
                this.loadWorker.stateProperty().addListener((observable, oldValue, newValue) -> {
                    JSObject window = (JSObject)this.engine.executeScript("window");
                    window.setMember("java", this.bridge);
                    this.engine.executeScript("console.log = function(message)\n{\n java.log(message);\n};console.warn = function(message)\n{\n java.warn(message);\n};console.error = function(message)\n{\n java.error(message);\n};console.info = function(message)\n{\n java.info(message);\n};");
                    switch (newValue) {
                        case FAILED: {
                            this.engine.loadContent("<html><body style=\"margin-left:20px;margin-top:20px\">Browser error: " + this.loadWorker.getException().getMessage() + "</body></html>", "text/html");
                        }
                        case SUCCEEDED: 
                        case CANCELLED: {
                            SecondaryLoop tmpLoop = this.loop;
                            if (tmpLoop != null) {
                                tmpLoop.exit();
                            }
                            this.loop = null;
                        }
                    }
                });
                this.engine.setOnError(e -> {
                    System.err.println(e.getMessage());
                    e.getException().printStackTrace(System.err);
                });
                this.engine.setOnAlert(event -> {
                    Alert alert = new Alert(Alert.AlertType.NONE, (String)event.getData(), new ButtonType[]{ButtonType.OK});
                    ((Stage)alert.getDialogPane().getScene().getWindow()).setAlwaysOnTop(true);
                    alert.showAndWait();
                });
                this.engine.setConfirmHandler(message -> {
                    Alert alert = new Alert(Alert.AlertType.CONFIRMATION, message, new ButtonType[0]);
                    ((Stage)alert.getDialogPane().getScene().getWindow()).setAlwaysOnTop(true);
                    Optional result = alert.showAndWait();
                    return result.isPresent() && result.get() == ButtonType.OK;
                });
                this.engine.setPromptHandler(promptData -> {
                    TextInputDialog input = new TextInputDialog(promptData.getDefaultValue());
                    ((Stage)input.getDialogPane().getScene().getWindow()).setAlwaysOnTop(true);
                    input.setHeaderText(promptData.getMessage());
                    Optional answer = input.showAndWait();
                    return answer.isPresent() ? (String)answer.get() : null;
                });
                this.engine.setCreatePopupHandler(popupFeatures -> {
                    BrowserWindow bw = new BrowserWindow();
                    bw.setResizable(popupFeatures.isResizable());
                    bw.show();
                    return bw.getEngine();
                });
            }
            catch (Throwable t) {
                this.throwable = t;
            }
            finally {
                this.loop.exit();
                this.loop = null;
            }
        });
        SecondaryLoop tmp = this.loop;
        if (tmp != null) {
            tmp.enter();
        }
        if (this.throwable != null) {
            throw new RuntimeException(this.throwable);
        }
    }

    @Override
    public JComponent getView() {
        return this.jxPanel;
    }

    @Override
    public boolean elementIDExists(String id) {
        return this.getDocument().getElementById(id) != null;
    }

    private boolean isReady() {
        Worker.State state = (Worker.State)this.stateProperty.get();
        return state != Worker.State.RUNNING && state != Worker.State.SCHEDULED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureReady() {
        if (!this.isReady()) {
            WebViewBrowser webViewBrowser = this;
            synchronized (webViewBrowser) {
                SecondaryLoop tmpLoop = this.loop;
                if (tmpLoop != null) {
                    tmpLoop.exit();
                }
                this.loop = tmpLoop = this.eventQueue.createSecondaryLoop();
                this.stop();
                tmpLoop.enter();
            }
        }
    }

    @Override
    public void load(String url) {
        this.ensureReady();
        this.loop = this.eventQueue.createSecondaryLoop();
        Platform.runLater(() -> {
            try {
                Object finalUrl = url.indexOf(58) == -1 ? "http://" + url : url;
                URI finalURI = null;
                try {
                    finalURI = new URI((String)finalUrl);
                }
                catch (URISyntaxException ex) {
                    finalUrl = IO.urlEncode((String)finalUrl);
                    finalURI = new URI((String)finalUrl);
                }
                String loc = this.engine.getLocation();
                loc = loc != null ? loc : "";
                loc = URLDecoder.decode(loc, "UTF8").replaceAll(" ", "%20");
                URI existingURI = new URI(loc != null ? loc : "");
                if (finalURI.equals(existingURI)) {
                    this.engine.reload();
                } else {
                    this.engine.load((String)(url.indexOf(58) == -1 ? "http://" + url : url));
                }
            }
            catch (UnsupportedEncodingException | URISyntaxException ex) {
                throw new RuntimeException(ex);
            }
        });
    }

    @Override
    public void loadContent(String content) {
        this.ensureReady();
        this.loop = this.eventQueue.createSecondaryLoop();
        Platform.runLater(() -> this.engine.loadContent(content));
    }

    @Override
    public void reload() {
        this.ensureReady();
        this.loop = this.eventQueue.createSecondaryLoop();
        Platform.runLater(() -> this.engine.reload());
    }

    @Override
    public void reloadIgnoringCache() {
        Platform.runLater(() -> this.engine.executeScript("location.reload(true);"));
    }

    @Override
    public void waitUntilLoaded() throws InterruptedException {
        if (this.loop != null) {
            this.loop.enter();
        }
    }

    @Override
    public String getLocation() {
        String location = this.engine.getLocation();
        return location != null ? location : "";
    }

    @Override
    public ReadOnlyStringProperty locationProperty() {
        return this.locationProperty;
    }

    @Override
    public void stop() {
        if (Platform.isFxApplicationThread()) {
            this.loadWorker.cancel();
        } else {
            Platform.runLater(() -> this.loadWorker.cancel());
        }
    }

    @Override
    public ReadOnlyObjectProperty<Worker.State> stateProperty() {
        return this.stateProperty;
    }

    @Override
    public void goBack() {
        Platform.runLater(() -> this.engine.getHistory().go(-1));
    }

    @Override
    public void goForward() {
        Platform.runLater(() -> this.engine.getHistory().go(1));
    }

    @Override
    public ReadOnlyBooleanProperty canGoBackProperty() {
        return this.canGoBackProperty;
    }

    @Override
    public ReadOnlyBooleanProperty canGoForwardProperty() {
        return this.canGoForwardProperty;
    }

    @Override
    public String getTitle() {
        return this.engine.getTitle();
    }

    @Override
    public ReadOnlyStringProperty titleProperty() {
        return this.titleProperty;
    }

    @Override
    public void onPageLoaded(Runnable r) {
        this.stateProperty.addListener((observable, oldValue, newValue) -> {
            if (newValue == Worker.State.SUCCEEDED) {
                r.run();
            }
        });
    }

    public void onError(Runnable r) {
        this.stateProperty.addListener((observable, oldValue, newValue) -> {
            if (newValue == Worker.State.FAILED) {
                r.run();
            }
        });
    }

    @Override
    public void dispose() {
        this.load("about:blank");
    }

    public WebEngine getEngine() {
        return this.engine;
    }

    public WebView getWebView() {
        return this.webView;
    }

    private static void trustAllCerts() {
        TrustManager[] trustManager = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sslContext = null;
        try {
            sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, trustManager, new SecureRandom());
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Document getDocument() {
        return this.engine.getDocument();
    }

    @Override
    public <T> T executeScript(String command) {
        return (T)this.engine.executeScript(command);
    }

    @Override
    public void setOnAlert(EventHandler<WebEvent<String>> eventHandler) {
        this.engine.setOnAlert(eventHandler);
    }

    @Override
    public void setOnError(EventHandler<WebErrorEvent> eventHandler) {
        this.engine.setOnError(eventHandler);
    }

    @Override
    public void openDeveloperTools() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void viewSource() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    static {
        WebViewBrowser.trustAllCerts();
    }

    private static class AWTObjectProperty<T>
    extends SimpleObjectProperty<T> {
        public AWTObjectProperty() {
        }

        public AWTObjectProperty(T initialValue) {
            super(initialValue);
        }

        protected void fireValueChangedEvent() {
            SwingUtilities.invokeLater(() -> super.fireValueChangedEvent());
        }
    }

    static class AWTStringProperty
    extends SimpleStringProperty {
        public AWTStringProperty() {
        }

        public AWTStringProperty(String initialValue) {
            super(initialValue);
        }

        protected void fireValueChangedEvent() {
            SwingUtilities.invokeLater(() -> super.fireValueChangedEvent());
        }
    }

    private static class AWTBooleanProperty
    extends SimpleBooleanProperty {
        private AWTBooleanProperty(boolean b) {
            super(b);
        }

        protected void fireValueChangedEvent() {
            SwingUtilities.invokeLater(() -> super.fireValueChangedEvent());
        }
    }

    public static class JavaBridge {
        public void log(String text) {
            System.out.println(text);
        }

        public void warn(String text) {
            System.err.println(text);
        }

        public void error(String text) {
            System.err.println(text);
        }

        public void info(String text) {
            System.out.println(text);
        }
    }
}

