/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.browser;

import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.concurrent.Worker;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import net.jalbum.browser.WebBrowser;
import se.datadosen.component.JCleanToolBar;
import se.datadosen.component.JMenuButton;
import se.datadosen.component.JRoundedToggleButtonGroup;
import se.datadosen.component.JSmartTextField;
import se.datadosen.component.JToolBarButton;
import se.datadosen.component.MiddleLayout;
import se.datadosen.component.ShareIcons;
import se.datadosen.component.ToggleAction;
import se.datadosen.component.ToggleAliasAction;
import se.datadosen.explorer.JAlbumExplorer;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JPhonePreviewer;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.Tracer;
import se.datadosen.net.NetUtil;
import se.datadosen.util.AliasAction;
import se.datadosen.util.LambdaAction;
import se.datadosen.util.Platform;
import se.datadosen.util.annotations.Icon;
import se.datadosen.util.annotations.Text;
import se.datadosen.util.annotations.ToolTipText;

public class BrowserToolBar
extends JCleanToolBar {
    private JAlbumContext context = JAlbumContext.getInstance();
    @Text(value="ui.share")
    JMenuButton shareButton = new JMenuButton();
    Action jalbumAction;
    Action facebookAction;
    Action twitterAction;
    Action tumblrAction;
    Action redditAction;
    Action pinterestAction;
    Action mailAction;
    @Icon(value="16x16/upload.svg")
    Action uploadAction;
    @Text(value="ui.openFolder")
    @ToolTipText(value="browser.folder")
    @Icon(value="16x16/open-folder.svg")
    Action folderAction;
    @Text(value="browser.openexternal")
    @ToolTipText(value="browser.openexternal")
    @Icon(value="16x16/open-in-browser.svg")
    Action openExternalAction;
    @Icon(value="16x16/qr-code.svg")
    @ToolTipText(value="ui.phonePreviewer")
    Action phonePreviewerAction;
    @Text(value="ui.localView")
    public ToggleAction localViewAction;
    @Text(value="ui.publishedView")
    public ToggleAction publishedViewAction;
    @Text(value="ui.rotateDevice")
    @Icon(value="16x16/rotate-device.svg")
    Action rotateDeviceAction;
    @ToolTipText(value="ui.responsive")
    @Icon(value="16x16/responsive.svg")
    JMenuButton responsiveButton;
    @Text(value="ui.viewSource")
    Action viewSourceAction;
    @Text(value="ui.developerTools")
    Action developerToolsAction;
    private final WebBrowser browser;
    @Text(value="ui.backward")
    @Icon(value="16x16/previous.svg")
    final Action backwardAction;
    @Text(value="ui.forward")
    @Icon(value="16x16/next.svg")
    final Action forwardAction;
    @Text(value="ui.reload")
    @Icon(value="16x16/refresh.svg")
    final Action reloadAction;
    @Text(value="ui.stop")
    @Icon(value="16x16/cancel.svg")
    final Action stopAction;

    public BrowserToolBar(WebBrowser browser) {
        this.jalbumAction = new AliasAction(this.context.getExplorer().sharePanel.jalbumSharingAction, (javax.swing.Icon)ShareIcons.jalbum);
        this.facebookAction = new SocialAction(this.context.getExplorer().sharePanel.facebookAction, (javax.swing.Icon)ShareIcons.facebook);
        this.twitterAction = new SocialAction(this.context.getExplorer().sharePanel.twitterAction, (javax.swing.Icon)ShareIcons.twitter);
        this.tumblrAction = new SocialAction(this.context.getExplorer().sharePanel.tumblrAction, (javax.swing.Icon)ShareIcons.tumblr);
        this.redditAction = new SocialAction(this.context.getExplorer().sharePanel.redditAction, (javax.swing.Icon)ShareIcons.reddit);
        this.pinterestAction = new SocialAction(this.context.getExplorer().sharePanel.pinterestAction, (javax.swing.Icon)ShareIcons.pinterest);
        this.mailAction = new SocialAction(this.context.getExplorer().sharePanel.emailAction, (javax.swing.Icon)ShareIcons.email);
        this.uploadAction = new AliasAction(this.context.getFrame().actions.publishAction);
        this.folderAction = new OfflineAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Tracer.getInstance().trace("open album folder clicked");
                    BrowserLauncher.openLocal(BrowserToolBar.this.context.getFrame().engine.getOutputDir());
                }
                catch (IOException ex) {
                    Logger.getLogger(BrowserToolBar.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        };
        this.openExternalAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    BrowserLauncher.openURL(URLDecoder.decode(BrowserToolBar.this.browser.getLocation(), "UTF-8"));
                }
                catch (IOException ex) {
                    Logger.getLogger(BrowserToolBar.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        };
        this.phonePreviewerAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPhonePreviewer.showDialog((Component)BrowserToolBar.this.browser.getView(), JAlbumContext.getInstance().getFrame(), BrowserToolBar.this.browser.getLocation());
            }
        };
        this.localViewAction = new ToggleAliasAction(this.context.getFrame().actions.viewAlbumAction);
        this.publishedViewAction = new ToggleAliasAction(this.context.getFrame().actions.viewRemoteAlbumAction);
        this.rotateDeviceAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Dimension browserSize = BrowserToolBar.this.browser.getView().getSize();
                BrowserToolBar.this.setScreenSize(new Dimension(browserSize.height, browserSize.width));
            }
        };
        this.responsiveButton = new JMenuButton(){
            {
                Config.getConfig().bind("previewMode", pce -> this.setVisible(Config.getConfig().getPreviewMode() == Config.PreviewMode.windowed));
                this.menu.setName(Msg.get("ui.responsive"));
                this.menu.add(BrowserToolBar.this.rotateDeviceAction);
                this.menu.addSeparator();
                LinkedHashMap<String, Dimension> devices = new LinkedHashMap<String, Dimension>(){
                    {
                        this.put("Galaxy Note 3", new Dimension(360, 640));
                        this.put("Nexus 10", new Dimension(800, 1280));
                        this.put("Pixel 2", new Dimension(411, 731));
                        this.put("Pixel 2XL", new Dimension(411, 823));
                        this.put("iPhone 5SE", new Dimension(320, 568));
                        this.put("iPhone 6/7/8", new Dimension(375, 667));
                        this.put("iPhone 6/7/8 Plus", new Dimension(414, 736));
                        this.put("iPhone X", new Dimension(375, 812));
                        this.put("iPad", new Dimension(768, 1024));
                        this.put("iPad Mini", new Dimension(768, 1024));
                        this.put("iPad Pro", new Dimension(1024, 1366));
                        this.put("Laptop with HiDpi Screen", new Dimension(1440, 900));
                        this.put("Laptop with touch", new Dimension(1280, 950));
                    }
                };
                for (Map.Entry e : ((HashMap)devices).entrySet()) {
                    JMenuItem mi = new JMenuItem((String)e.getKey() + " (" + ((Dimension)e.getValue()).width + "x" + ((Dimension)e.getValue()).height + ")");
                    mi.addActionListener(al -> BrowserToolBar.this.setScreenSize((Dimension)e.getValue()));
                    this.menu.add(mi);
                }
            }
        };
        this.viewSourceAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrowserToolBar.this.browser.viewSource();
            }
        };
        this.developerToolsAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrowserToolBar.this.browser.openDeveloperTools();
            }
        };
        this.browser = browser;
        this.backwardAction = new LambdaAction(browser::goBack);
        this.forwardAction = new LambdaAction(browser::goForward);
        this.reloadAction = new LambdaAction(ae -> {
            boolean altDown;
            boolean bl = altDown = ae != null && (ae.getModifiers() & 8) != 0;
            if (altDown) {
                browser.reloadIgnoringCache();
            } else {
                browser.reload();
            }
        });
        this.stopAction = new LambdaAction(browser::stop);
        this.createActionsToolBar();
        if (Platform.isLinux()) {
            this.add(this.createAddressBar());
        } else {
            this.add(MiddleLayout.wrap(this.createAddressBar()));
        }
        this.createRightToolBar();
        Msg.maintainTranslated(this);
    }

    private void setScreenSize(Dimension dim) {
        Window win = SwingUtilities.getWindowAncestor(this);
        Dimension winSize = win.getSize();
        Dimension browserSize = this.browser.getView().getSize();
        int extraWidth = winSize.width - browserSize.width;
        int extraHeight = winSize.height - browserSize.height;
        win.setSize(dim.width + extraWidth, dim.height + extraHeight);
    }

    private void createActionsToolBar() {
        this.add(this.responsiveButton);
        this.addFirst(new JToolBarButton(this.backwardAction, false));
        this.addMiddle(new JToolBarButton(this.forwardAction, false));
        this.addMiddle(new JToolBarButton(this.reloadAction, false));
        this.addLast(new JToolBarButton(this.stopAction, false));
    }

    private void createRightToolBar() {
        this.add(new JToolBarButton(this.openExternalAction, false));
        this.add(new JToolBarButton(this.phonePreviewerAction, false));
        this.add(new JToolBarButton(this.folderAction, false));
        this.add(new JToolBarButton(this.uploadAction, true));
        this.shareButton.addActions(this.jalbumAction, this.facebookAction, this.twitterAction, this.tumblrAction, this.redditAction, this.pinterestAction, this.mailAction);
        this.add(this.shareButton);
        this.addSeparator();
        this.localViewAction.setSelected(true);
        this.add(new JRoundedToggleButtonGroup(this.localViewAction, this.publishedViewAction));
    }

    private JTextField createAddressBar() {
        JSmartTextField address = new JSmartTextField("about:blank");
        address.addActionListener(e -> this.browser.load(address.getText()));
        this.browser.canGoBackProperty().addListener((observable, oldValue, newValue) -> this.backwardAction.setEnabled((boolean)newValue));
        this.browser.canGoForwardProperty().addListener((observable, oldValue, newValue) -> this.forwardAction.setEnabled((boolean)newValue));
        this.browser.locationProperty().addListener((observable, oldValue, newValue) -> this.phonePreviewerAction.setEnabled(newValue.toLowerCase().startsWith("http")));
        this.backwardAction.setEnabled(false);
        this.forwardAction.setEnabled(false);
        this.browser.stateProperty().addListener((observable, oldValue, newValue) -> {
            this.reloadAction.setEnabled(newValue != Worker.State.RUNNING);
            this.stopAction.setEnabled(newValue == Worker.State.RUNNING);
        });
        this.browser.locationProperty().addListener((observable, oldValue, newValue) -> {
            String loc = newValue;
            if (loc != null && loc.length() > 0) {
                address.setText(this.browser.getLocation());
            }
        });
        return address;
    }

    void updateIconStates(String location, WebBrowser browser) {
        try {
            URL url = new URL(location);
            boolean online = !NetUtil.isLocal(url);
            this.publishedViewAction.setSelected(online);
            this.localViewAction.setSelected(!online);
            this.shareButton.setEnabled(online);
            this.shareButton.setToolTipText(online ? "" : Msg.get("ui.notAvailableOffline"));
            this.folderAction.setEnabled(!online);
            if (online) {
                JAlbumExplorer ax = this.context.getExplorer();
                String albumURL = (String)ax.getRootFolder().getProperties().get("albumURL");
                this.shareButton.setEnabled(albumURL != null);
                if (albumURL != null) {
                    String title = (String)ax.getRootFolder().getProperties().get("title");
                    if (title == null) {
                        title = ax.getRootFolder().getName();
                    }
                    ax.sharePanel.updateAlbumInformation(albumURL, title, ax.getRootFolder().getThumbnailPath());
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    private class SocialAction
    extends AliasAction {
        public SocialAction(Action target, javax.swing.Icon icon) {
            super(target, icon);
        }

        @Override
        public void setEnabled(boolean newValue) {
            boolean oldValue = this.isEnabled();
            super.setEnabled(newValue);
            if (newValue != oldValue) {
                this.firePropertyChange("Name", "", this.getValue("Name"));
            }
        }

        @Override
        public Object getValue(String key) {
            if (key.equals("Name") && !this.isEnabled()) {
                return Msg.get("ui.notAvailableOffline");
            }
            return super.getValue(key);
        }
    }

    abstract class OfflineAction
    extends AbstractAction {
        public OfflineAction() {
        }

        public OfflineAction(javax.swing.Icon icon) {
            super(null, icon);
        }

        @Override
        public void setEnabled(boolean newValue) {
            boolean oldValue = this.isEnabled();
            super.setEnabled(newValue);
            if (newValue != oldValue) {
                this.firePropertyChange("ShortDescription", "", this.getValue("ShortDescription"));
            }
        }

        @Override
        public Object getValue(String key) {
            if (key.equals("ShortDescription") && !this.isEnabled()) {
                return Msg.get("ui.notAvailableOnline");
            }
            return super.getValue(key);
        }
    }
}

