/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.browser;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javax.script.ScriptException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.OverlayLayout;
import javax.swing.SwingUtilities;
import net.jalbum.browser.BrowserPane;
import net.jalbum.browser.Browsers;
import net.jalbum.browser.WebBrowser;
import net.jalbum.component.JProgressManager;
import se.datadosen.component.JNotification;
import se.datadosen.component.JProgressSpinner;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumBeanEvent;
import se.datadosen.jalbum.AlbumBeanListener;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumProject;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.FolderVisitResult;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.InvalidLicenseException;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumUtilities;
import se.datadosen.jalbum.MakeResult;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.jalbum.SkinProperties;
import se.datadosen.jalbum.event.IsPersistent;
import se.datadosen.jalbum.event.JAlbumAdapter;
import se.datadosen.jalbum.event.JAlbumEvent;
import se.datadosen.net.NetUtil;
import se.datadosen.tags.ElementException;
import se.datadosen.util.ContextHelp;
import se.datadosen.util.Stopwatch;

public class BrowserPanel
extends JPanel {
    static final KeyStroke f5 = KeyStroke.getKeyStroke(116, 0);
    public Action refreshAction;
    private JNotification flashWarning;
    private BrowserPane browserPane = null;
    private final JProgressSpinner rebuildSpinner = new JProgressSpinner(150);
    private final JAlbumContext context;
    private AlbumBean previewEngine;
    private final JFrame previewWindow;
    private RebuildThread rebuildThread = null;
    private ScheduledFuture<Long> lastModifiedFuture;
    private boolean projectLoaded;
    private AlbumProject lastProject;
    private PropertyChangeListener rootPropertyListener;
    public static final String NAME = "browserPanel";
    public static final String BROWSER_REFRESH = "browserRefresh";

    private long getLastModified() {
        if (this.lastModifiedFuture == null) {
            return 0L;
        }
        try {
            return (Long)this.lastModifiedFuture.get();
        }
        catch (InterruptedException | ExecutionException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void updateLastModified(AlbumObject root) {
        this.updateLastModified(root, 0L);
    }

    private void updateLastModified(AlbumObject root, long delay) {
    }

    private void flashCheck() {
        if (this.context.getEngine() == null) {
            return;
        }
        SkinProperties sp = this.context.getEngine().getSkinProperties();
        try {
            if (sp.getRepositoryProperties().isUsesFlash()) {
                if (this.flashWarning == null || !this.flashWarning.isShowing()) {
                    this.flashWarning = new JNotification(Msg.get("browser.flashWarning", this.browserPane.getBrowser().getLocation()));
                    this.flashWarning.setBackground(Color.yellow.brighter());
                    this.flashWarning.setIcon(Icons.small("warning-1"));
                    this.flashWarning.setPriority(JNotification.Priority.HIGH);
                    this.context.getFrame().showNotification(this.flashWarning);
                }
            } else if (this.flashWarning != null && this.flashWarning.isShowing()) {
                this.flashWarning.setVisible(false);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private URI getIndexURI() {
        File indexFile = this.context.getFrame().getIndexFile();
        if (indexFile.exists()) {
            if (Config.getConfig().isServerBasedPreview()) {
                try {
                    return new URI(this.context.getFrame().prepareServerBasedPreview(indexFile).toExternalForm().replace(" ", "%20"));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            return indexFile.toURI();
        }
        try {
            return new URI("about:blank");
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    public BrowserPanel(final JAlbumContext context, JFrame previewWindow) {
        this.context = context;
        this.previewWindow = previewWindow;
        this.context.getFrame().addPropertyChangeListener("settings", evt -> {
            JAlbum.logger.config("Settings changed");
            if (!context.getFrame().isLoadingProject()) {
                this.rebuildPreview(false);
            }
        });
        this.context.getFrame().addPropertyChangeListener("skinLoaded", evt -> {
            this.previewEngine = null;
            if (!this.projectLoaded && this.browserPane != null) {
                this.rebuildPreview(!this.browserPane.getBrowser().getLocation().equals(this.getIndexURI().toString()));
            }
            this.projectLoaded = false;
        });
        this.context.getFrame().addPropertyChangeListener("projectLoaded", evt -> {
            JAlbum.logger.config("Project loaded");
            this.previewEngine = null;
            if (Config.getConfig().getPreviewMode() != Config.PreviewMode.external) {
                this.updateLastModified(context.getExplorer().getRootFolder(), 1000L);
            }
            if (this.browserPane != null && this.isShowing()) {
                this.safelyLoadURL(this.getIndexURI().toString());
                if (this.rebuildThread != null) {
                    this.rebuildThread.abort();
                }
            }
        });
        this.context.getFrame().addPropertyChangeListener("projectLoading", evt -> {
            JAlbum.logger.fine("Project loading");
            this.projectLoaded = true;
        });
        PropertyChangeListener rootListener = evt -> {
            AlbumObject root = this.context.getExplorer().getRootFolder();
            this.rootPropertyListener = evt1 -> {
                if (this.isShowing() && (evt1.getPropertyName().equals("title") || evt1.getPropertyName().equals("comment"))) {
                    this.rebuildPreview(!this.browserPane.getBrowser().getLocation().equals(this.getIndexURI().toString()));
                }
            };
            root.addPropertyChangeListener(this.rootPropertyListener);
        };
        this.context.getFrame().addPropertyChangeListener("rootFolder", rootListener);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                BrowserPanel.this.abortRebuilding();
            }

            @Override
            public void componentShown(ComponentEvent e) {
                BrowserPanel.this.requestFocusInWindow();
            }
        });
        previewWindow.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                BrowserPanel.this.abortRebuilding();
            }
        });
        this.context.getFrame().addJAlbumListener(new ChangeAdapter());
        this.setLayout(new OverlayLayout(this));
        this.setName(NAME);
        this.rebuildSpinner.setMaximumSize(new Dimension(150, 150));
        this.rebuildSpinner.setAlignmentX(0.5f);
        this.rebuildSpinner.setAlignmentY(0.5f);
        this.rebuildSpinner.setVisible(false);
        this.add(this.rebuildSpinner);
        this.refreshAction = new AbstractAction(this){
            final /* synthetic */ BrowserPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e != null && e.getActionCommand() != null && e.getActionCommand().equals(BrowserPanel.BROWSER_REFRESH)) {
                    this.this$0.browserPane.reload();
                }
                long previousLastModified = this.this$0.getLastModified();
                this.this$0.updateLastModified(context.getExplorer().getRootFolder());
                long newLastModified = this.this$0.getLastModified();
                if (newLastModified != previousLastModified) {
                    this.this$0.rebuildPreview(this.this$0.isOnlineViewing());
                }
            }
        };
        this.registerKeyboardAction(this.refreshAction, BROWSER_REFRESH, f5, 2);
        ContextHelp.getInstance().add(this, "Preview");
    }

    private boolean isOnlineViewing() {
        return this.browserPane.getBrowser().getLocation().startsWith("http");
    }

    public void showPanel() {
        JAlbum.logger.finer("showPanel");
        this.context.getFrame().ui2Engine();
        String url = this.getIndexURI().toString();
        if (!this.isInitialized()) {
            this.getBrowserPane();
        }
        this.safelyLoadURL(url);
        AlbumProject currentProject = this.context.getExplorer().albumManager.getCurrentProject();
        if (this.lastProject == null) {
            this.lastProject = currentProject;
        }
        if (!this.lastProject.equals(currentProject)) {
            this.lastProject = currentProject;
        } else if (this.context.getEngine().isDirty()) {
            this.rebuildPreview(this.browserPane.getBrowser().getLocation().startsWith("http"));
        } else {
            long previousLastModified = this.getLastModified();
            this.updateLastModified(this.context.getExplorer().getRootFolder());
            long lastModified = this.getLastModified();
            if (lastModified != previousLastModified && previousLastModified > 0L && lastModified > this.context.getExplorer().getRootFolder().getProperties().get("lastMadeDate", 0L)) {
                this.rebuildPreview(false);
            }
        }
    }

    private void safelyLoadURL(String url) {
        JAlbumUtilities.runOnAWT(() -> this.browserPane.getBrowser().load(url));
    }

    private void initBrowser() {
        WebBrowser browser = Browsers.create();
        this.browserPane = new BrowserPane(browser);
        this.add(this.browserPane);
        this.browserPane.getBrowser().stateProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue == Worker.State.SUCCEEDED) {
                this.flashCheck();
            }
        });
        this.browserPane.getBrowser().titleProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue observable, Object oldValue, Object newValue) {
                BrowserPanel.this.previewWindow.setTitle((String)newValue);
            }
        });
        this.validate();
        browser.load("about:blank");
        try {
            browser.waitUntilLoaded();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void openURL(URL url) {
        this.getBrowserPane();
        JAlbumUtilities.runOnAWT(() -> {
            this.browserPane.getBrowser().load(url.toString());
            this.checkModified(url);
        });
    }

    private void checkModified(URL url) {
        AlbumProject currentProject = this.context.getExplorer().albumManager.getCurrentProject();
        if (this.lastProject != null && this.lastProject.equals(currentProject)) {
            if (NetUtil.isLocal(url)) {
                long previousLastModified = this.getLastModified();
                this.updateLastModified(this.context.getExplorer().getRootFolder());
                long lastModified = this.getLastModified();
                if (lastModified != previousLastModified) {
                    this.rebuildPreview(false);
                }
            }
        } else {
            this.lastProject = currentProject;
        }
    }

    public synchronized BrowserPane getBrowserPane() {
        if (this.browserPane == null) {
            this.initBrowser();
        }
        return this.browserPane;
    }

    public void dispose() {
        if (this.isInitialized()) {
            this.getBrowserPane().dispose();
        }
    }

    public void reload() {
        this.getBrowserPane().reload();
    }

    private boolean isInitialized() {
        return this.browserPane != null;
    }

    private void rebuildPreview(boolean goToRoot) {
        JAlbum.logger.fine("Rebuilding preview");
        if (this.isShowing()) {
            if (this.rebuildThread != null) {
                this.rebuildThread.abort();
            }
            this.rebuildThread = new RebuildThread();
            this.rebuildThread.goToRoot(goToRoot);
            this.rebuildThread.start();
        }
    }

    public boolean isRebuilding() {
        if (this.rebuildThread == null) {
            return false;
        }
        return this.rebuildThread.isAlive();
    }

    private void abortRebuilding() {
        if (this.rebuildThread != null) {
            this.rebuildThread.abort();
            if (this.flashWarning != null) {
                this.flashWarning.setVisible(false);
            }
        }
    }

    private AlbumBean getEngine() {
        AlbumBean local = this.previewEngine;
        if (local == null) {
            this.previewEngine = local = new AlbumBean();
        }
        return local;
    }

    private void ui2Engine(AlbumBean engine) {
        this.context.getFrame().ui2Engine(engine);
        engine.setImageVariants(this.context.getEngine().getImageVariants());
        engine.setThumbVariants(this.context.getEngine().getThumbVariants());
    }

    private static String removeElipsis(String s) {
        return s.replaceAll("\\.\\.\\.", "");
    }

    private static /* synthetic */ Long lambda$updateLastModified$0(AlbumObject root) throws Exception {
        Stopwatch sw = new Stopwatch("Getting last modified");
        sw.start();
        long ret = JAlbumUtilities.deepLastModified(root);
        JAlbum.logger.fine(sw.toString());
        return ret;
    }

    class RebuildThread
    extends Thread {
        private boolean aborted = false;
        private final JProgressManager.TaskStatus taskStatus = new JProgressManager.TaskStatus();
        private boolean goToRoot = false;
        Action instantPreviewAction = new AbstractAction("Instant preview"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                BrowserPanel.this.rebuildSpinner.setVisible(true);
                if (BrowserPanel.this.lastModifiedFuture != null) {
                    BrowserPanel.this.lastModifiedFuture.cancel(true);
                }
                boolean shouldEnable = true;
                BrowserPanel.this.context.getFrame().actions.makeAction.setEnabled(false);
                BrowserPanel.this.context.getFrame().actions.publishAction.setEnabled(false);
                RebuildThread.this.taskStatus.setMessage(BrowserPanel.removeElipsis(Msg.get("browser.roughPreview")));
                RebuildThread.this.taskStatus.onAbort(() -> RebuildThread.this.abort());
                BrowserPanel.this.context.getFrame().progressManager.addTask(RebuildThread.this.taskStatus);
                AlbumBean engine = BrowserPanel.this.getEngine();
                BrowserPanel.this.ui2Engine(engine);
                AlbumBeanListener withoutScale = new AlbumBeanListener(){

                    @Override
                    public void imageProcessingStarted(AlbumBeanEvent e) {
                        if (RebuildThread.this.aborted) {
                            e.abortProcessing();
                        }
                        RebuildThread.this.taskStatus.setSubMessage(e.msg);
                        RebuildThread.this.taskStatus.setProgress(Msg.get("progress.processingInfo2", e.getProcessedFiles(), e.getTotalFiles()), e.getProcessedFiles(), e.getTotalFiles());
                    }

                    @Override
                    public void imageProcessingFinished(AlbumBeanEvent e) {
                        if (RebuildThread.this.aborted) {
                            e.abortProcessing();
                        }
                    }

                    @Override
                    public void videoProcessingProgress(AlbumBeanEvent e, float progress) {
                        RebuildThread.this.taskStatus.setSubMessage(e.msg);
                        RebuildThread.this.taskStatus.setProgress(Msg.get("progress.processingInfo2", e.getProcessedFiles(), e.getTotalFiles()), (int)progress * 100, 1);
                        if (RebuildThread.this.aborted) {
                            e.abortProcessing();
                        }
                    }

                    @Override
                    public FolderVisitResult folderProcessingFinished(AlbumObject folder) {
                        block6: {
                            if (folder.getParent() == null) {
                                try {
                                    URI raw = new URL(BrowserPanel.this.browserPane.getBrowser().getLocation()).toURI();
                                    URI uri = new URI(raw.getScheme(), null, raw.getHost(), raw.getPort(), raw.getPath(), null, null);
                                    if (RebuildThread.this.goToRoot || uri.equals(BrowserPanel.this.getIndexURI())) {
                                        BrowserPanel.this.rebuildSpinner.setVisible(false);
                                        BrowserPanel.this.browserPane.load(BrowserPanel.this.getIndexURI().toString());
                                        break block6;
                                    }
                                    BrowserPanel.this.browserPane.reload();
                                }
                                catch (IllegalArgumentException | MalformedURLException | URISyntaxException exception) {}
                            } else if (BrowserPanel.this.browserPane.getBrowser().getLocation().contains(folder.getName())) {
                                BrowserPanel.this.browserPane.reload();
                                BrowserPanel.this.rebuildSpinner.setVisible(false);
                            }
                        }
                        return FolderVisitResult.proceed;
                    }
                };
                BrowserPanel.this.ui2Engine(engine);
                try {
                    try {
                        engine.addAlbumBeanListener(withoutScale);
                        engine.setAppendImages(true);
                        BrowserPanel.this.context.getFrame().progressSpinner.workStarted();
                        BrowserPanel.this.context.getFrame().progressManager.startTask(RebuildThread.this.taskStatus);
                        BrowserPanel.this.browserPane.waitUntilLoaded();
                        MakeResult result = engine.makeAlbum();
                        if (result.isDirty()) {
                            this.finalBuild(engine);
                            shouldEnable = false;
                        }
                        BrowserPanel.this.updateLastModified(BrowserPanel.this.context.getExplorer().getRootFolder(), 0L);
                    }
                    finally {
                        engine.removeAlbumBeanListener(withoutScale);
                    }
                }
                catch (OperationAbortedException result) {
                }
                catch (InvalidLicenseException ex) {
                    ex.showDialog((JFrame)SwingUtilities.getWindowAncestor(BrowserPanel.this));
                }
                catch (IOException | IllegalArgumentException | ScriptException | ElementException ex) {
                    ex.printStackTrace(System.err);
                }
                finally {
                    BrowserPanel.this.rebuildSpinner.setVisible(false);
                    BrowserPanel.this.context.getFrame().progressManager.removeTask(RebuildThread.this.taskStatus);
                    BrowserPanel.this.context.getFrame().progressSpinner.workDone();
                    if (shouldEnable) {
                        BrowserPanel.this.context.getFrame().actions.makeAction.setEnabled(true);
                        BrowserPanel.this.context.getFrame().actions.publishAction.setEnabled(true);
                    }
                }
            }

            private void finalBuild(AlbumBean engine) {
                RebuildThread.this.taskStatus.setMessage(BrowserPanel.removeElipsis(Msg.get("browser.finalPreview")));
                BrowserPanel.this.context.getFrame().progressSpinner.workStarted();
                try {
                    BrowserPanel.this.browserPane.waitUntilLoaded();
                    engine.smartMakeAlbum();
                }
                catch (OperationAbortedException ex) {
                }
                catch (IOException | IllegalArgumentException | ScriptException | ElementException ex) {
                    ex.printStackTrace(System.err);
                }
                finally {
                    try {
                        SwingUtilities.invokeAndWait(() -> {
                            BrowserPanel.this.context.getFrame().actions.makeAction.setEnabled(true);
                            BrowserPanel.this.context.getFrame().actions.publishAction.setEnabled(true);
                            BrowserPanel.this.browserPane.reload();
                            BrowserPanel.this.context.getFrame().progressSpinner.workDone();
                        });
                    }
                    catch (InterruptedException | InvocationTargetException ex) {
                        Logger.getLogger(BrowserPanel.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        };

        RebuildThread() {
        }

        public void abort() {
            this.aborted = true;
            BrowserPanel.this.context.getFrame().progressManager.removeTask(this.taskStatus);
        }

        public void goToRoot(boolean bool) {
            this.goToRoot = bool;
        }

        @Override
        public void run() {
            this.instantPreviewAction.actionPerformed(null);
        }
    }

    private class ChangeAdapter
    extends JAlbumAdapter
    implements IsPersistent {
        private ChangeAdapter() {
        }

        @Override
        public void styleChanged(JAlbumEvent e) {
            JAlbum.logger.config("Style changed");
            if (!BrowserPanel.this.context.getFrame().mainSettingsPanel.isLoadingSkin() && !BrowserPanel.this.context.getFrame().isLoadingProject()) {
                BrowserPanel.this.rebuildPreview(false);
            }
        }

        @Override
        public void skinChanged(JAlbumEvent e) {
            JAlbum.logger.config("Skin changed");
            if (BrowserPanel.this.rebuildThread != null) {
                BrowserPanel.this.rebuildThread.abort();
            }
        }
    }
}

