/*
 * Decompiled with CFR 0.152.
 */
package xyz.gianlu.zeroconf;

import java.io.Closeable;
import java.io.IOException;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketOption;
import java.net.StandardProtocolFamily;
import java.net.StandardSocketOptions;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.gianlu.zeroconf.ABLock;
import xyz.gianlu.zeroconf.DiscoveredService;
import xyz.gianlu.zeroconf.Packet;
import xyz.gianlu.zeroconf.PacketListener;
import xyz.gianlu.zeroconf.Record;
import xyz.gianlu.zeroconf.RecordANY;
import xyz.gianlu.zeroconf.RecordPTR;
import xyz.gianlu.zeroconf.RecordSRV;
import xyz.gianlu.zeroconf.Service;

public final class Zeroconf
implements Closeable {
    private static final String DISCOVERY = "_services._dns-sd._udp.local";
    private static final InetSocketAddress BROADCAST4;
    private static final InetSocketAddress BROADCAST6;
    private static final Logger LOGGER;
    private final ListenerThread thread;
    private final List<Record> registry;
    private final Collection<Service> services;
    private final CopyOnWriteArrayList<DiscoveredServices> discoverers;
    private final CopyOnWriteArrayList<PacketListener> receiveListeners;
    private final CopyOnWriteArrayList<PacketListener> sendListeners;
    private boolean useIpv4 = true;
    private boolean useIpv6 = true;
    private String hostname;
    private String domain;

    public Zeroconf() {
        this.setDomain(".local");
        try {
            this.setLocalHostName(Zeroconf.getOrCreateLocalHostName());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.receiveListeners = new CopyOnWriteArrayList();
        this.sendListeners = new CopyOnWriteArrayList();
        this.discoverers = new CopyOnWriteArrayList();
        this.thread = new ListenerThread();
        this.registry = new ArrayList<Record>();
        this.services = new HashSet<Service>();
    }

    @NotNull
    public static String getOrCreateLocalHostName() throws UnknownHostException {
        String host = InetAddress.getLocalHost().getHostName();
        if (Objects.equals(host, "localhost")) {
            host = Base64.getEncoder().encodeToString(BigInteger.valueOf(ThreadLocalRandom.current().nextLong()).toByteArray()) + ".local";
            LOGGER.log(Level.WARNING, "Hostname cannot be `localhost`, temporary hostname is {0}.", host);
            return host;
        }
        return host;
    }

    @NotNull
    public Zeroconf setUseIpv4(boolean ipv4) {
        this.useIpv4 = ipv4;
        return this;
    }

    @NotNull
    public Zeroconf setUseIpv6(boolean ipv6) {
        this.useIpv6 = ipv6;
        return this;
    }

    @Override
    public void close() {
        for (Service service : new ArrayList<Service>(this.services)) {
            this.unannounce(service);
        }
        this.services.clear();
        for (DiscoveredServices discoverer : new ArrayList<DiscoveredServices>(this.discoverers)) {
            discoverer.stop();
        }
        this.discoverers.clear();
        try {
            this.thread.close();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @NotNull
    public Zeroconf addReceiveListener(@NotNull PacketListener listener) {
        this.receiveListeners.addIfAbsent(listener);
        return this;
    }

    @NotNull
    public Zeroconf removeReceiveListener(@NotNull PacketListener listener) {
        this.receiveListeners.remove(listener);
        return this;
    }

    @NotNull
    public Zeroconf addSendListener(@NotNull PacketListener listener) {
        this.sendListeners.addIfAbsent(listener);
        return this;
    }

    @NotNull
    public Zeroconf removeSendListener(@NotNull PacketListener listener) {
        this.sendListeners.remove(listener);
        return this;
    }

    @NotNull
    public Zeroconf addNetworkInterface(@NotNull NetworkInterface nic) throws IOException {
        this.thread.addNetworkInterface(nic);
        return this;
    }

    @NotNull
    public Zeroconf addNetworkInterfaces(@NotNull Collection<NetworkInterface> nics) throws IOException {
        for (NetworkInterface nic : nics) {
            this.thread.addNetworkInterface(nic);
        }
        return this;
    }

    @NotNull
    public Zeroconf removeNetworkInterface(@NotNull NetworkInterface nic) throws IOException {
        this.thread.removeNetworkInterface(nic);
        return this;
    }

    @NotNull
    public Zeroconf addAllNetworkInterfaces() throws IOException {
        Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
        while (e.hasMoreElements()) {
            this.addNetworkInterface(e.nextElement());
        }
        return this;
    }

    public String getDomain() {
        return this.domain;
    }

    @NotNull
    public Zeroconf setDomain(@NotNull String domain) {
        this.domain = domain;
        return this;
    }

    public String getLocalHostName() {
        if (this.hostname == null) {
            throw new IllegalStateException("Hostname cannot be determined");
        }
        return this.hostname;
    }

    @NotNull
    public Zeroconf setLocalHostName(@NotNull String name) {
        this.hostname = name;
        return this;
    }

    public List<InetAddress> getLocalAddresses() {
        return this.thread.getLocalAddresses();
    }

    public void send(@NotNull Packet packet) {
        this.thread.push(packet);
    }

    public List<Record> getRegistry() {
        return this.registry;
    }

    public Collection<Service> getAnnouncedServices() {
        return Collections.unmodifiableCollection(this.services);
    }

    private void handlePacket(@NotNull Packet packet) {
        Packet response = null;
        HashSet<String> targets = null;
        for (Record question : packet.getQuestions()) {
            for (Record record : this.getRegistry()) {
                if (!question.getName().equals(DISCOVERY) && !question.getName().equals(record.getName()) || question.getType() != record.getType() && (question.getType() != 255 || record.getType() == 47)) continue;
                if (response == null) {
                    response = new Packet(packet.getID());
                    response.setAuthoritative(true);
                }
                response.addAnswer(record);
                if (!(record instanceof RecordSRV)) continue;
                if (targets == null) {
                    targets = new HashSet<String>();
                }
                targets.add(((RecordSRV)record).getTarget());
            }
            if (response == null || question.getType() == 255) continue;
            for (Record answer : response.getAnswers()) {
                if (answer.getType() != 12) continue;
                for (Record record : this.getRegistry()) {
                    if (!record.getName().equals(((RecordPTR)answer).getValue()) || record.getType() != 33 && record.getType() != 16) continue;
                    response.addAdditional(record);
                    if (!(record instanceof RecordSRV)) continue;
                    if (targets == null) {
                        targets = new HashSet();
                    }
                    targets.add(((RecordSRV)record).getTarget());
                }
            }
        }
        if (response != null) {
            if (targets != null) {
                for (String target : targets) {
                    for (Record record : this.getRegistry()) {
                        if (!record.getName().equals(target) || record.getType() != 1 && record.getType() != 28) continue;
                        response.addAdditional(record);
                    }
                }
            }
            this.send(response);
        }
    }

    @NotNull
    public DiscoveredServices discover(@NotNull String service, @NotNull String protocol, @NotNull String domain) {
        DiscoveredServices discoverer = new DiscoveredServices("_" + service + "._" + protocol + domain);
        new Thread((Runnable)discoverer, "zeroconf-discover-" + service + "-" + protocol + "-" + domain).start();
        this.discoverers.add(discoverer);
        return discoverer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean probe(String fqdn) {
        Packet probe = new Packet();
        probe.setResponse(false);
        probe.addQuestion(new RecordANY(fqdn));
        AtomicBoolean match = new AtomicBoolean(false);
        PacketListener probeListener = packet -> {
            if (packet.isResponse()) {
                AtomicBoolean atomicBoolean;
                for (Record r : packet.getAnswers()) {
                    if (!r.getName().equalsIgnoreCase(fqdn)) continue;
                    atomicBoolean = match;
                    synchronized (atomicBoolean) {
                        match.set(true);
                        match.notifyAll();
                    }
                }
                for (Record r : packet.getAdditionals()) {
                    if (!r.getName().equalsIgnoreCase(fqdn)) continue;
                    atomicBoolean = match;
                    synchronized (atomicBoolean) {
                        match.set(true);
                        match.notifyAll();
                    }
                }
            }
        };
        this.addReceiveListener(probeListener);
        for (int i = 0; i < 3 && !match.get(); ++i) {
            this.send(probe);
            AtomicBoolean atomicBoolean = match;
            synchronized (atomicBoolean) {
                try {
                    match.wait(250L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        this.removeReceiveListener(probeListener);
        return match.get();
    }

    public void announce(@NotNull Service service) {
        if (service.getDomain() == null) {
            service.setDomain(this.getDomain());
        }
        if (service.getHost() == null) {
            service.setHost(this.getLocalHostName());
        }
        if (!service.hasAddresses()) {
            service.addAddresses(this.getLocalAddresses());
        }
        Packet packet = service.getPacket();
        if (this.probe(service.getInstanceName())) {
            throw new IllegalArgumentException("Service " + service.getInstanceName() + " already on network");
        }
        this.getRegistry().addAll(packet.getAnswers());
        this.services.add(service);
        for (int i = 0; i < 3; ++i) {
            this.send(packet);
            try {
                Thread.sleep(225L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        LOGGER.log(Level.INFO, "Announced {0}.", service);
    }

    public void unannounce(@NotNull Service service) {
        Packet packet = service.getPacket();
        this.getRegistry().removeAll(packet.getAnswers());
        for (Record r : packet.getAnswers()) {
            this.getRegistry().remove(r);
            r.setTTL(0);
        }
        this.services.remove(service);
        for (int i = 0; i < 3; ++i) {
            this.send(packet);
            try {
                Thread.sleep(125L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        LOGGER.log(Level.INFO, "Unannounced {0}.", service);
    }

    static {
        LOGGER = Logger.getLogger(Zeroconf.class.getName());
        try {
            BROADCAST4 = new InetSocketAddress(InetAddress.getByName("224.0.0.251"), 5353);
            BROADCAST6 = new InetSocketAddress(InetAddress.getByName("FF02::FB"), 5353);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private class ListenerThread
    extends Thread {
        private final Deque<Packet> sendq;
        private final Map<NetworkInterface, SelectionKey> channels;
        private final Map<NetworkInterface, List<InetAddress>> localAddresses;
        private final ABLock selectorLock;
        private volatile boolean cancelled;
        private Selector selector;

        ListenerThread() {
            super("zeroconf-io-thread");
            this.selectorLock = new ABLock();
            this.setDaemon(false);
            this.sendq = new ArrayDeque<Packet>();
            this.channels = new HashMap<NetworkInterface, SelectionKey>();
            this.localAddresses = new HashMap<NetworkInterface, List<InetAddress>>();
        }

        private synchronized Selector getSelector() throws IOException {
            if (this.selector == null) {
                this.selector = Selector.open();
            }
            return this.selector;
        }

        void close() throws InterruptedException {
            this.cancelled = true;
            if (this.selector != null) {
                this.selector.wakeup();
                if (this.isAlive()) {
                    this.join();
                }
            }
        }

        void push(Packet packet) {
            this.sendq.addLast(packet);
            if (this.selector != null) {
                this.selector.wakeup();
            }
        }

        private Packet pop() {
            return this.sendq.pollFirst();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addNetworkInterface(@NotNull NetworkInterface nic) throws IOException {
            if (!this.channels.containsKey(nic) && nic.supportsMulticast() && nic.isUp() && !nic.isLoopback()) {
                boolean ipv4 = false;
                boolean ipv6 = false;
                ArrayList<InetAddress> locallist = new ArrayList<InetAddress>();
                Enumeration<InetAddress> e = nic.getInetAddresses();
                while (e.hasMoreElements()) {
                    InetAddress a = e.nextElement();
                    if (a instanceof Inet4Address && !Zeroconf.this.useIpv4 || a instanceof Inet6Address && !Zeroconf.this.useIpv6) continue;
                    ipv4 |= a instanceof Inet4Address;
                    ipv6 |= a instanceof Inet6Address;
                    if (a.isLoopbackAddress() || a.isMulticastAddress()) continue;
                    locallist.add(a);
                }
                DatagramChannel channel = DatagramChannel.open(StandardProtocolFamily.INET);
                channel.configureBlocking(false);
                channel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
                channel.setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_TTL, (Object)255);
                if (ipv4) {
                    channel.bind(new InetSocketAddress("0.0.0.0", BROADCAST4.getPort()));
                    channel.setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_IF, nic);
                    channel.join(BROADCAST4.getAddress(), nic);
                } else if (ipv6) {
                    channel.bind(new InetSocketAddress("::", BROADCAST6.getPort()));
                    channel.join(BROADCAST6.getAddress(), nic);
                }
                this.selectorLock.lockA1();
                try {
                    this.getSelector().wakeup();
                    this.selectorLock.lockA2();
                    try {
                        this.channels.put(nic, channel.register(this.getSelector(), 1));
                    }
                    finally {
                        this.selectorLock.unlockA2();
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    this.selectorLock.unlockA1();
                }
                this.localAddresses.put(nic, locallist);
                if (!this.isAlive()) {
                    this.start();
                }
            }
        }

        void removeNetworkInterface(@NotNull NetworkInterface nic) throws IOException {
            SelectionKey key = this.channels.remove(nic);
            if (key != null) {
                this.localAddresses.remove(nic);
                key.channel().close();
                this.getSelector().wakeup();
            }
        }

        List<InetAddress> getLocalAddresses() {
            ArrayList<InetAddress> list = new ArrayList<InetAddress>();
            for (List<InetAddress> pernic : this.localAddresses.values()) {
                for (InetAddress address : pernic) {
                    if (list.contains(address)) continue;
                    list.add(address);
                }
            }
            return list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ByteBuffer buf = ByteBuffer.allocate(65536);
            buf.order(ByteOrder.BIG_ENDIAN);
            while (!this.cancelled) {
                buf.clear();
                try {
                    Packet packet = this.pop();
                    if (packet != null) {
                        buf.clear();
                        packet.write(buf);
                        buf.flip();
                        for (PacketListener listener : Zeroconf.this.sendListeners) {
                            listener.packetEvent(packet);
                        }
                        for (SelectionKey key : this.channels.values()) {
                            DatagramChannel channel = (DatagramChannel)key.channel();
                            InetSocketAddress address = packet.getAddress();
                            if (address != null) {
                                buf.position(0);
                                channel.send(buf, address);
                                continue;
                            }
                            if (Zeroconf.this.useIpv4) {
                                buf.position(0);
                                channel.send(buf, BROADCAST4);
                            }
                            if (!Zeroconf.this.useIpv6) continue;
                            buf.position(0);
                            channel.send(buf, BROADCAST6);
                        }
                    }
                    Selector selector = this.getSelector();
                    this.selectorLock.lockB();
                    try {
                        selector.select();
                    }
                    finally {
                        this.selectorLock.unlockB();
                    }
                    Set<SelectionKey> selected = selector.selectedKeys();
                    for (SelectionKey key : selected) {
                        DatagramChannel channel = (DatagramChannel)key.channel();
                        InetSocketAddress address = (InetSocketAddress)channel.receive(buf);
                        if (address == null || buf.position() == 0) continue;
                        buf.flip();
                        packet = new Packet();
                        packet.read(buf, address);
                        for (PacketListener listener : Zeroconf.this.receiveListeners) {
                            listener.packetEvent(packet);
                        }
                        Zeroconf.this.handlePacket(packet);
                    }
                    selected.clear();
                }
                catch (Exception exception) {}
            }
        }
    }

    public class DiscoveredServices
    implements Runnable {
        private final String serviceName;
        private final PacketListener listener;
        private final Set<DiscoveredService> services = Collections.synchronizedSet(new HashSet());
        private volatile boolean shouldStop = false;
        private int nextInterval = 1000;

        DiscoveredServices(String serviceName) {
            this.serviceName = serviceName;
            this.listener = packet -> {
                if (!packet.isResponse()) {
                    return;
                }
                for (Record r : packet.getAnswers()) {
                    if (r instanceof RecordSRV) {
                        this.addService((RecordSRV)r);
                        continue;
                    }
                    this.addRelated(r);
                }
                for (Record r : packet.getAdditionals()) {
                    if (r instanceof RecordSRV) {
                        this.addService((RecordSRV)r);
                        continue;
                    }
                    this.addRelated(r);
                }
            };
            Zeroconf.this.addReceiveListener(this.listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addRelated(@NotNull Record record) {
            if (!record.getName().endsWith(this.serviceName)) {
                return;
            }
            Set<DiscoveredService> set = this.services;
            synchronized (set) {
                this.services.stream().filter(s -> s.serviceName.equals(record.getName())).forEach(s -> s.addRelatedRecord(record));
            }
        }

        private void addService(@NotNull RecordSRV record) {
            if (!record.getName().endsWith(this.serviceName)) {
                return;
            }
            this.services.removeIf(s -> s.isExpired() || s.serviceName.equals(record.getName()));
            this.services.add(new DiscoveredService(record));
        }

        public void stop() {
            this.shouldStop = true;
        }

        @NotNull
        public List<DiscoveredService> getServices() {
            return new ArrayList<DiscoveredService>(this.services);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public DiscoveredService getService(@NotNull String name) {
            Set<DiscoveredService> set = this.services;
            synchronized (set) {
                for (DiscoveredService service : this.services) {
                    if (!service.name.equals(name)) continue;
                    return service;
                }
                return null;
            }
        }

        @Override
        public void run() {
            while (!this.shouldStop) {
                Packet probe = new Packet();
                probe.setResponse(false);
                probe.addQuestion(new RecordPTR(this.serviceName));
                Zeroconf.this.send(probe);
                try {
                    Thread.sleep(this.nextInterval);
                    this.nextInterval *= 2;
                    if ((long)this.nextInterval < TimeUnit.MINUTES.toMillis(60L)) continue;
                    this.nextInterval = (int)((double)(TimeUnit.MINUTES.toMillis(60L) + 20L) + Math.random() * 100.0);
                }
                catch (InterruptedException ex) {
                    break;
                }
            }
            Zeroconf.this.removeReceiveListener(this.listener);
        }
    }
}

