/*
 * Decompiled with CFR 0.152.
 */
package xyz.gianlu.zeroconf;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.gianlu.zeroconf.Packet;
import xyz.gianlu.zeroconf.Record;

public final class RecordA
extends Record {
    private byte[] address;

    RecordA() {
        super(1);
    }

    RecordA(String name, Inet4Address address) {
        this();
        this.setName(name);
        this.setTTL(120);
        this.address = address.getAddress();
    }

    @Override
    protected void readData(int len, ByteBuffer in) {
        this.address = new byte[len];
        in.get(this.address);
    }

    @Override
    protected int writeData(ByteBuffer out, Packet packet) {
        if (this.address != null) {
            out.put(this.address);
            return this.address.length;
        }
        return -1;
    }

    @Nullable
    public Inet4Address getAddress() {
        try {
            return this.address == null ? null : (Inet4Address)InetAddress.getByAddress(this.address);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    @NotNull
    public String toString() {
        return "{type:a, name:\"" + this.getName() + "\", address:\"" + this.getAddress() + "\"}";
    }
}

