/*
 * Decompiled with CFR 0.152.
 */
package lizard;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import se.datadosen.util.IO;
import se.datadosen.util.PermissionDeniedException;

public class DiskCache {
    private static final int BUFSIZE = 262144;
    private File cacheDir;
    private String extension;
    private IOException lastException;

    public DiskCache(File primaryCacheDir, String extension) {
        this.cacheDir = primaryCacheDir;
        this.extension = extension;
    }

    public boolean load(String ... urls) {
        HashMap<String, URL> uList = new HashMap<String, URL>();
        try {
            for (String url : urls) {
                URL u = new URL(url);
                uList.put(DiskCache.getName(u), u);
            }
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
        this.cacheDir.mkdirs();
        Map<String, File> contents = this.getContents();
        contents.entrySet().stream().forEach(e -> {
            if (!uList.containsKey(e.getKey())) {
                ((File)e.getValue()).delete();
            }
        });
        this.lastException = null;
        uList.entrySet().parallelStream().forEach(e -> {
            try {
                DiskCache.cacheFile((URL)e.getValue(), new File(this.cacheDir, (String)e.getKey()));
            }
            catch (IOException ex) {
                this.lastException = ex;
            }
        });
        return this.lastException == null;
    }

    public IOException getLastException() {
        return this.lastException;
    }

    private static String getName(URL u) {
        String path;
        String name = path = u.getPath();
        int slashIndex = path.lastIndexOf(47);
        if (slashIndex != -1) {
            name = path.substring(slashIndex + 1);
        }
        return name;
    }

    public Map<String, File> getContents() {
        return DiskCache.getContents(this.cacheDir, this.extension);
    }

    public void syncTo(File targetDir) throws IOException {
        targetDir.mkdirs();
        Map<String, File> src = this.getContents();
        Map<String, File> dest = DiskCache.getContents(targetDir, this.extension);
        dest.entrySet().forEach(e -> {
            if (!src.containsKey(e.getKey())) {
                ((File)e.getValue()).delete();
            }
        });
        for (Map.Entry<String, File> e2 : src.entrySet()) {
            File targetFile = dest.get(e2.getKey());
            if (targetFile != null && targetFile.lastModified() >= e2.getValue().lastModified()) continue;
            IO.copyFile((File)e2.getValue(), (File)new File(targetDir, e2.getKey()));
        }
    }

    private static File cacheFile(URL url, File dest) throws PermissionDeniedException, IOException {
        FileOutputStream fos;
        if (dest.isDirectory()) {
            dest = new File(dest, DiskCache.getName(url));
        }
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        if (dest.exists()) {
            conn.setIfModifiedSince(dest.lastModified());
        }
        conn.setConnectTimeout(10000);
        conn.setReadTimeout(10000);
        long lastModified = conn.getLastModified();
        if (conn.getResponseCode() == 304) {
            return dest;
        }
        File tmp = new File(dest.getParentFile(), dest.getName() + ".downloading");
        try {
            fos = new FileOutputStream(tmp);
        }
        catch (IOException ex) {
            throw new PermissionDeniedException("Can't write to " + dest, (Throwable)ex);
        }
        try {
            DiskCache.cacheFile(conn, fos);
            fos.close();
            tmp.renameTo(dest);
            if (lastModified != 0L) {
                dest.setLastModified(lastModified);
            }
            return dest;
        }
        catch (IOException ex) {
            tmp.delete();
            throw ex;
        }
    }

    private static boolean cacheFile(HttpURLConnection conn, OutputStream out) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(conn.getInputStream());){
            if (conn.getResponseCode() != 200) {
                throw new IOException("Error accessing " + conn.getURL() + ". Server reported " + conn.getResponseCode() + " " + conn.getResponseMessage());
            }
            BufferedOutputStream bout = new BufferedOutputStream(out);
            byte[] data = new byte[262144];
            int x = 0;
            while ((x = in.read(data, 0, data.length)) >= 0) {
                bout.write(data, 0, x);
            }
            bout.flush();
        }
        return true;
    }

    private static Map<String, File> getContents(File dir, String ext) {
        HashMap<String, File> map = new HashMap<String, File>();
        for (File f : dir.listFiles((d, name) -> name.toLowerCase().endsWith("." + ext))) {
            map.put(f.getName(), f);
        }
        return map;
    }
}

