/*
 * Decompiled with CFR 0.152.
 */
package lucid;

import edu.stanford.ejalbert.BrowserLauncher;
import icons.Lazaicon;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import lucid.GuiBase;
import lucid.SkinModel;
import net.jalbum.browser.WebViewBrowser;
import net.jalbum.component.JDraggableList;
import se.datadosen.component.ChooserFactory;
import se.datadosen.component.ComponentUtilities;
import se.datadosen.component.ControlPanel;
import se.datadosen.component.DeferredSVGIcon;
import se.datadosen.component.FileChooser;
import se.datadosen.component.JAlphaColorSelector;
import se.datadosen.component.JColorSelector;
import se.datadosen.component.JLabelFor;
import se.datadosen.component.JLinkLabel;
import se.datadosen.component.JNotification;
import se.datadosen.component.JPlaylist;
import se.datadosen.component.JSmartTextArea;
import se.datadosen.component.JSmartTextField;
import se.datadosen.component.RiverLayout;
import se.datadosen.component.StateMonitor;
import se.datadosen.component.WrappableJLabel;
import se.datadosen.jalbum.AccountManager;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.JAlbumColor;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumSite;
import se.datadosen.jalbum.ParameterException;
import se.datadosen.jalbum.SignInManager;
import se.datadosen.jalbum.SkinProperties;
import se.datadosen.jalbum.event.JAlbumAdapter;
import se.datadosen.jalbum.event.JAlbumEvent;
import se.datadosen.jalbum.event.JAlbumListener;
import se.datadosen.tags.ElementException;
import se.datadosen.util.IO;
import se.datadosen.util.Item;
import se.datadosen.util.Languages;
import se.datadosen.util.NameValue;
import se.datadosen.util.VersionNumber;

public class Gui
extends GuiBase {
    private boolean skinReady = false;
    private final VersionNumber jalbumVersion = new VersionNumber(AlbumBean.getInternalVersion());
    private final String skinVer = new SkinProperties(this.skinDirectory).getProperty("version");
    private final String supportForum = new SkinProperties(this.skinDirectory).getProperty("supportForum");
    private final String helpRoot = "http://jalbum.net/help/en/Skin/" + this.skin + "/";
    private final int uiHeight = 480;
    private final int uiWidth = 400;
    private final int previewWidth = 480;
    private final String tabStyle = "style='padding:3px 4px;margin:3px 4px;'";
    private String licensee = this.licenseManager.isLicenseValid() ? this.licenseManager.getUserName() : "";
    private String license = this.licenseManager.isLicenseValid() ? this.licenseManager.getLicenseType() : "";
    private boolean commercialUseAllowed = this.license.length() > 0 && "pro".equals(this.license);
    private Font mono = new Font("monospaced", 0, 12);
    private Border emptyBorder = BorderFactory.createEmptyBorder();
    private final Double FULLY_TRANSP = 1.0E-4;
    private final Double FULLY_OPAQUE = 0.9999;
    private final String[] imageFiles = new String[]{"jpg", "jpeg", "png", "gif", "svg"};
    private final FileChooser fc = ChooserFactory.createFileChooser((Window)this.window);
    private StateMonitor commercialMonitor = new StateMonitor(){

        public void onChange() {
            if (((JCheckBox)this.source).isSelected() && !Gui.this.commercialUseAllowed) {
                if (Gui.this.skinReady) {
                    Object[] options = new Object[]{Gui.this.getText("ui.signUp"), Gui.this.getText("ui.noThanks")};
                    int n = JOptionPane.showOptionDialog((Component)Gui.this.window, Gui.this.getText("ui.licenseWarningText"), Gui.this.getText("ui.licenseWarningTitle"), 0, 1, null, options, options[1]);
                    if (n == 0) {
                        try {
                            BrowserLauncher.openURL((String)(JAlbumSite.getTrueInstance().getMyJAlbumUpgradeUrl() + "/?referrer=" + Gui.this.skin + Gui.this.attemptSignIn()));
                        }
                        catch (IOException | ElementException throwable) {
                            // empty catch block
                        }
                    }
                }
                ((JCheckBox)this.source).setSelected(false);
            }
        }
    };
    private Date skinLoadedOn = new Date();
    ControlPanel skinUi = new ControlPanel(){
        private JTextField styleName;
        private Icon infoIcon;
        private Icon mandatory;
        JTextField skinVersion;
        private boolean skinChangeReported;
        JTextField facebookAppId;
        JColorSelector backgroundColor;
        JColorSelector controlsBackgroundColor;
        JColorSelector textColor;
        JColorSelector buttonColor;
        JColorSelector buttonTextColor;
        private final JComboBox fontSuggestions;
        JComboBox fontFamily;
        JComboBox headlineFont;
        JSpinner thumbGap;
        JComboBox thumbStyle;
        JSpinner neighboringItemsOpacity;
        JSpinner fillHorizontally;
        JSpinner fillVertically;
        JCheckBox showFullscreen;
        JCheckBox showImageNumbers;
        JTextArea imageCaptionTemplate;
        JComboBox captionPlacement;
        JComboBox captionStyle;
        JCheckBox printImageButton;
        JCheckBox showDownload;
        JCheckBox showPhotoData;
        WebViewBrowser designPreview;
        WebViewBrowser thumbsPreview;
        private String lastThumbDimSuggestion;
        PropertyChangeListener setupMonitors;
        ControlPanel design;
        ControlPanel typography;
        ControlPanel titlePage;
        ControlPanel markNew;
        ControlPanel topNavigation;
        ControlPanel thumbnailStrip;
        ControlPanel titlePanel;
        ControlPanel social;
        ControlPanel map;
        ControlPanel backgroundMusic;
        ControlPanel customCodePanel;
        ControlPanel siteAdminPanel;
        ControlPanel mainImage;
        ControlPanel imageCaption;
        ControlPanel buttons;
        ControlPanel site;
        ControlPanel controls;
        ControlPanel advanced;
        ControlPanel about;
        JTabbedPane tabs;
        private final String designTemplate;
        private final String thumbsTemplate;
        {
            this.styleName = new JTextField(Gui.this.getStyleName());
            this.infoIcon = Gui.icon("info");
            this.mandatory = Gui.svgIcon("asterisk", new Dimension(16, 16));
            this.skinVersion = new JTextField(Gui.this.engine.getSkinProperties().getProperty("version", "0.0"));
            this.skinChangeReported = false;
            this.facebookAppId = new JSmartTextField(16);
            this.backgroundColor = new JAlphaColorSelector(Gui.this.getText("ui.backgroundColor"), (JTextField)new JSmartTextField(10));
            this.controlsBackgroundColor = new JAlphaColorSelector(Gui.this.getText("ui.controlsBackgroundColor"), (JTextField)new JSmartTextField(10));
            this.textColor = new JColorSelector(Gui.this.getText("ui.textColor"), (JTextField)new JSmartTextField(10));
            this.buttonColor = new JAlphaColorSelector(Gui.this.getText("ui.button"), (JTextField)new JSmartTextField(10));
            this.buttonTextColor = new JColorSelector(Gui.this.getText("ui.buttonText"), (JTextField)new JSmartTextField(10));
            this.fontSuggestions = new JComboBox<Object>(new Object[]{"[" + Gui.this.getText("ui.suggestedFonts") + "]", "Cinzel Decorative / Raleway", "Dosis Bold / Montserrat", "Exo 2 / Exo 2", "Fjalla One / Roboto", "IBM Plex Serif / IBM Plex Sans", "Jura / Roboto Condensed", "Martel / Roboto", "Merriweather / Merriweather Sans", "Oswald / Open Sans", "Raleway / Open Sans", "Roboto Condensed / Roboto", "Roboto Slab / Montserrat", "Special Elite / Yanone Kaffeesatz", "Unica One / Lato", "Yanone Kaffeesatz Bold / Muli"});
            this.fontFamily = new JComboBox<Object>(new Object[]{new Item((Object)"Arial, \"Helvetica Neue\", Helvetica, sans-serif", (Object)"Arial"), new Item((Object)"Baskerville, \"Baskerville Old Face\", \"Hoefler Text\", Garamond, \"Times New Roman\", serif", (Object)"Baskerville"), new Item((Object)"Calibri, Candara, Segoe, \"Segoe UI\", Optima, Arial, sans-serif", (Object)"Calibri"), new Item((Object)"Cambria, Georgia, Times, \"Times New Roman\", serif", (Object)"Cambria"), new Item((Object)"\"Century Gothic\", \"Apple Gothic\", \"Goudy Old Style\", sans-serif", (Object)"Century Gothic"), new Item((Object)"\"Comic Sans MS\", cursive", (Object)"Comic Sans"), new Item((Object)"Consolas, \"Lucida Console\", Monaco, monospace", (Object)"Consolas"), new Item((Object)"Constantia, Palatino, \"Palatino Linotype\", \"Palatino LT STD\", Georgia, serif", (Object)"Constantia"), new Item((Object)"\"Copperplate Light\", \"Copperplate Gothic Light\", serif", (Object)"Copperplate Light"), new Item((Object)"\"Courier New\", Courier, monospace", (Object)"Courier New"), new Item((Object)"\"Franklin Gothic Medium\", \"Arial Narrow Bold\", Arial, sans-serif", (Object)"Franklin Gothic"), new Item((Object)"Futura, \"Century Gothic\", AppleGothic, sans-serif", (Object)"Futura"), new Item((Object)"Garamond, \"Hoefler Text\", Times New Roman, Times, serif", (Object)"Garamond"), new Item((Object)"Geneva, \"Lucida Sans\", \"Lucida Grande\", \"Lucida Sans Unicode\", Verdana, sans-serif", (Object)"Geneva"), new Item((Object)"Georgia, Palatino, \"Palatino Linotype\", Times, \"Times New Roman\", serif", (Object)"Georgia"), new Item((Object)"\"Gill Sans\", \"Gill Sans MT\", Calibri, \"Trebuchet MS\", sans-serif", (Object)"Gill Sans"), new Item((Object)"\"Goudy Old Style\", Garamond, \"Big Caslon\", \"Times New Roman\", serif", (Object)"Goudy Old Style"), new Item((Object)"\"Helvetica Neue\", Helvetica, Arial, sans-serif", (Object)"Helvetica Neue"), new Item((Object)"\"Hoefler Text\", Constantia, Palatino, \"Palatino Linotype\", \"Book Antiqua\", Georgia, serif", (Object)"Hoefler Text"), new Item((Object)"Impact, Haettenschweiler, \"Arial Narrow Bold\", sans-serif", (Object)"Impact"), new Item((Object)"\"Lucida Sans\", \"Lucida Grande\", \"Lucida Sans Unicode\", Verdana, sans-serif", (Object)"Lucida Sans"), new Item((Object)"\"Lucida Bright\", Georgia, serif", (Object)"Lucida Bright"), new Item((Object)"Palatino, \"Palatino Linotype\", \"Book Antiqua\", Georgia, serif", (Object)"Palatino"), new Item((Object)"Segoe, \"Segoe UI\", Tahoma, Geneva, \"Nimbus Sans L\", sans-serif", (Object)"Segoe"), new Item((Object)"Tahoma, Geneva, Verdana, sans-serif", (Object)"Tahoma"), new Item((Object)"Times, \"Times New Roman\", Georgia, serif", (Object)"Times"), new Item((Object)"\"Trebuchet MS\", \"Lucida Sans Unicode\", \"Lucida Grande\", \"Lucida Sans\", Tahoma, sans-serif", (Object)"Trebuchet MS"), new Item((Object)"Verdana, Geneva, Tahoma, sans-serif", (Object)"Verdana"), new Item((Object)"Alegreya Sans:300,300i,500,500i", (Object)"Alegreya Sans Light"), new Item((Object)"Barlow:300,300i,600,600i", (Object)"Barlow Light"), new Item((Object)"Barlow Semi Condensed:300,300i,500,500i", (Object)"Barlow Semi Condensed"), new Item((Object)"Exo 2:300,300i,600,600i", (Object)"Exo 2"), new Item((Object)"Fira Sans:300,300i,600,600i", (Object)"Fira Sans"), new Item((Object)"IBM Plex Sans:300,300i,600,600i", (Object)"IBM Plex Sans"), new Item((Object)"Josefin Sans:300,300i,600,600i", (Object)"Josefin Sans"), new Item((Object)"Josefin Slab:300,300i,600,600i", (Object)"Josefin Slab"), new Item((Object)"Lato:300,300i,700,700i", (Object)"Lato"), new Item((Object)"Merriweather Sans:300,300i,700,700i", (Object)"Merriweather Sans"), new Item((Object)"Merriweather:300,300i,700,700i", (Object)"Merriweather Serif"), new Item((Object)"Montserrat:300,300i,600,600i", (Object)"Montserrat"), new Item((Object)"Muli:300,300i,700,700i", (Object)"Muli"), new Item((Object)"Open Sans:300,300i,600,600i", (Object)"Open Sans"), new Item((Object)"Raleway:300,300i,600,600i", (Object)"Raleway"), new Item((Object)"Roboto:300,300i,500,500i", (Object)"Roboto"), new Item((Object)"Roboto Condensed:300,300i,700,700i", (Object)"Roboto Condensed"), new Item((Object)"Source Sans Pro:300,300i,600,600i", (Object)"Source Sans Pro"), new Item((Object)"Yanone Kaffeesatz:300,500", (Object)"Yanone Kaffeesatz")});
            this.headlineFont = new JComboBox<Object>(new Object[]{new Item((Object)"", (Object)("[ " + Gui.this.getText("ui.sameAsBaseFont") + " ]")), new Item((Object)"Abril Fatface", (Object)"Abril Fatface"), new Item((Object)"Amaranth", (Object)"Amaranth"), new Item((Object)"Amatic SC:700", (Object)"Amatic SC Bold"), new Item((Object)"Arapey", (Object)"Arapey"), new Item((Object)"Barlow:300", (Object)"Barlow Light"), new Item((Object)"Barlow Semi Condensed:300", (Object)"Barlow Semi Condensed Light"), new Item((Object)"Barlow Condensed", (Object)"Barlow Condensed"), new Item((Object)"Cinzel Decorative", (Object)"Cinzel Decorative"), new Item((Object)"Dosis:600", (Object)"Dosis Bold"), new Item((Object)"Euphoria Script", (Object)"Euphoria Script"), new Item((Object)"Exo 2:300", (Object)"Exo 2"), new Item((Object)"Fauna One", (Object)"Fauna One"), new Item((Object)"Fjalla One", (Object)"Fjalla One"), new Item((Object)"Gilda Display", (Object)"Gilda Display"), new Item((Object)"Grand Hotel", (Object)"Grand Hotel"), new Item((Object)"Great Vibes", (Object)"Great Vibes"), new Item((Object)"IBM Plex Serif:300", (Object)"IBM Plex Serif"), new Item((Object)"Josefin Slab", (Object)"Josefin Slab"), new Item((Object)"Julius Sans One", (Object)"Julius Sans One"), new Item((Object)"Jura", (Object)"Jura"), new Item((Object)"Libre Baskerville", (Object)"Libre Baskerville"), new Item((Object)"Lobster", (Object)"Lobster"), new Item((Object)"Lobster Two", (Object)"Lobster Two"), new Item((Object)"Martel:300", (Object)"Martel"), new Item((Object)"Marvel:700", (Object)"Marvel Bold"), new Item((Object)"Merriweather:300", (Object)"Merriweather"), new Item((Object)"Oswald", (Object)"Oswald"), new Item((Object)"Poiret One", (Object)"Poiret One"), new Item((Object)"PT Sans Narrow", (Object)"PT Sans Narrow"), new Item((Object)"Raleway:300", (Object)"Raleway"), new Item((Object)"Raleway:600", (Object)"Raleway Bold"), new Item((Object)"Roboto Condensed", (Object)"Roboto Condensed"), new Item((Object)"Roboto Slab:300", (Object)"Roboto Slab"), new Item((Object)"Roboto Slab:600", (Object)"Roboto Slab Bold"), new Item((Object)"Scope One", (Object)"Scope One"), new Item((Object)"Six Caps", (Object)"Six Caps"), new Item((Object)"Sofia", (Object)"Sofia"), new Item((Object)"Special Elite", (Object)"Special Elite"), new Item((Object)"Unica One", (Object)"Unica One"), new Item((Object)"Vidaloka", (Object)"Vidaloka"), new Item((Object)"Yanone Kaffeesatz:300", (Object)"Yanone Kaffeesatz"), new Item((Object)"Yanone Kaffeesatz:500", (Object)"Yanone Kaffeesatz Bold")});
            this.thumbGap = new JSpinner(new SpinnerNumberModel(1, 0, 20, 1));
            this.thumbStyle = new JComboBox<Object>(new Object[]{new Item((Object)"grid", (Object)Gui.this.getText("ui.grid")), new Item((Object)"dots", (Object)Gui.this.getText("ui.dots")), new Item((Object)"masonry", (Object)Gui.this.getText("ui.masonry"))});
            this.neighboringItemsOpacity = new JSpinner(new SpinnerNumberModel(25, 0, 100, 5));
            this.fillHorizontally = new JSpinner(new SpinnerNumberModel(90, 50, 100, 1));
            this.fillVertically = new JSpinner(new SpinnerNumberModel(100, 50, 100, 1));
            this.showFullscreen = new JCheckBox(Gui.this.getText("ui.showFullScreenButton"), true);
            this.showImageNumbers = new JCheckBox(Gui.this.getText("ui.showNumbers"));
            this.imageCaptionTemplate = new JSmartTextArea(5, 12);
            this.captionPlacement = new JComboBox<Object>(new Object[]{new Item((Object)"left top", (Object)Gui.this.getText("ui.left_top")), new Item((Object)"center top", (Object)Gui.this.getText("ui.center_top")), new Item((Object)"right top", (Object)Gui.this.getText("ui.right_top")), new Item((Object)"left middle", (Object)Gui.this.getText("ui.left_middle")), new Item((Object)"center middle", (Object)Gui.this.getText("ui.center_middle")), new Item((Object)"right middle", (Object)Gui.this.getText("ui.right_middle")), new Item((Object)"left bottom", (Object)Gui.this.getText("ui.left_bottom")), new Item((Object)"center bottom", (Object)Gui.this.getText("ui.center_bottom")), new Item((Object)"right bottom", (Object)Gui.this.getText("ui.right_bottom"))});
            this.captionStyle = new JComboBox<Object>(new Object[]{new Item((Object)"white", (Object)Gui.this.getText("ui.white")), new Item((Object)"light", (Object)Gui.this.getText("ui.light")), new Item((Object)"transparent", (Object)Gui.this.getText("ui.transparent")), new Item((Object)"dark", (Object)Gui.this.getText("ui.dark")), new Item((Object)"black", (Object)Gui.this.getText("ui.black"))});
            this.printImageButton = new JCheckBox(Gui.this.getText("ui.printImageButton"));
            this.showDownload = new JCheckBox(Gui.this.getText("ui.showDownload"));
            this.showPhotoData = new JCheckBox(Gui.this.getText("ui.showPhotoData"));
            this.designPreview = new WebViewBrowser();
            this.thumbsPreview = new WebViewBrowser();
            this.lastThumbDimSuggestion = "";
            this.setupMonitors = pce -> {
                StateMonitor.monitoring((JComponent[])new JComponent[]{this.fontSuggestions}).onChange(src -> {
                    if (Gui.this.skinReady && src != null) {
                        this.setFontBoxes();
                    }
                });
                StateMonitor.monitoring((JComponent[])new JComponent[]{this.thumbGap, this.thumbStyle}).onChange(src -> {
                    if (Gui.this.skinReady && src != null) {
                        this.refreshThumbsPreview();
                    }
                });
                StateMonitor.monitoring((JComponent[])new JComponent[]{this.styleName, this.backgroundColor, this.controlsBackgroundColor, this.textColor, this.buttonColor, this.buttonTextColor, this.fontFamily, this.headlineFont, this.neighboringItemsOpacity, this.fillHorizontally, this.fillVertically, this.showFullscreen, this.showImageNumbers, this.captionPlacement, this.captionStyle, this.imageCaptionTemplate, this.printImageButton, this.showDownload, this.showPhotoData}).onChange(src -> {
                    if (Gui.this.skinReady && src != null) {
                        this.refreshDesignPreview();
                    }
                });
                this.refreshDesignPreview();
                this.refreshThumbsPreview();
            };
            this.design = new ControlPanel(){
                JComboBox<Item> language = new JComboBox<Item>(){
                    {
                        this.setModel(Languages.modelFrom((File)new File(Gui.this.skinDirectory, "texts")));
                        this.insertItemAt(new Item((Object)"jalbum", (Object)("[ " + Gui.this.getText("ui.jAlbumPreference") + " ]")), 0);
                        this.setSelectedIndex(0);
                    }
                };
                JSmartTextField backgroundImageName = new JSmartTextField(12);
                JButton selectImage = new JButton();
                JComboBox backgroundPos;
                JComboBox backgroundRepeat;
                JComboBox modalWindowsTheme;
                JComboBox iconStyle;
                {
                    this.backgroundPos = new JComboBox<Object>(Gui.this.getPosition());
                    this.backgroundRepeat = new JComboBox<Object>(new Object[]{new Item((Object)"no-repeat", (Object)Gui.this.getText("ui.no_repeat")), new Item((Object)"repeat-x", (Object)Gui.this.getText("ui.repeat_x")), new Item((Object)"repeat-y", (Object)Gui.this.getText("ui.repeat_y")), new Item((Object)"repeat", (Object)Gui.this.getText("ui.repeat_both")), new Item((Object)"stretch", (Object)Gui.this.getText("ui.stretch"))});
                    this.modalWindowsTheme = new JComboBox<Object>(new Object[]{new Item((Object)"auto", (Object)Gui.this.getText("ui.auto")), new Item((Object)"light", (Object)Gui.this.getText("ui.light")), new Item((Object)"dark", (Object)Gui.this.getText("ui.dark"))});
                    this.iconStyle = new JComboBox<Object>(new Object[]{new Item((Object)"thin", (Object)Gui.this.getText("ui.thin")), new Item((Object)"fat", (Object)Gui.this.getText("ui.fat"))});
                    this.language.setToolTipText(Gui.this.getText("ui.languageInfo"));
                    this.selectImage.setText(Gui.this.getText("ui.select"));
                    this.selectImage.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Gui.this.getFileToRes(Gui.this.imageFiles, (JTextField)backgroundImageName, (Component)Gui.this.skinUi);
                        }
                    });
                    backgroundColor.setToolTipText(Gui.this.getText("ui.backgroundColorInfo"));
                    backgroundColor.getTextComponent().setFont(Gui.this.mono);
                    controlsBackgroundColor.setToolTipText(Gui.this.getText("ui.controlsBackgroundColorInfo"));
                    textColor.setToolTipText(Gui.this.getText("ui.textColorInfo"));
                    controlsBackgroundColor.getTextComponent().setFont(Gui.this.mono);
                    textColor.getTextComponent().setFont(Gui.this.mono);
                    buttonColor.getTextComponent().setFont(Gui.this.mono);
                    buttonTextColor.getTextComponent().setFont(Gui.this.mono);
                    this.add("", (Component)new JLabelFor(Gui.this.getText("ui.language"), this.language));
                    this.add("tab", this.language);
                    this.add("br", (Component)new JLabelFor(Gui.this.getText("ui.backgroundImage"), (JComponent)this.backgroundImageName));
                    this.add("tab", (Component)this.backgroundImageName);
                    this.add("", this.selectImage);
                    this.add("br", (Component)new JLabelFor(Gui.this.getText("ui.position"), (JComponent)this.backgroundPos));
                    this.add("tab", this.backgroundPos);
                    this.add("br tab", this.backgroundRepeat);
                    this.add("br", (Component)new JLabelFor(Gui.this.getText("ui.backgroundColor"), (JComponent)backgroundColor));
                    this.add("tab", (Component)backgroundColor);
                    this.add("tab", backgroundColor.getTextComponent());
                    this.add("br", (Component)new JLabelFor(Gui.this.getText("ui.controlsBackgroundColor"), (JComponent)controlsBackgroundColor));
                    this.add("tab", (Component)controlsBackgroundColor);
                    this.add("tab", controlsBackgroundColor.getTextComponent());
                    this.add("br", (Component)new JLabelFor(Gui.this.getText("ui.textColor"), (JComponent)textColor));
                    this.add("tab", (Component)textColor);
                    this.add("tab", textColor.getTextComponent());
                    this.add("br", (Component)new JLabelFor(Gui.this.getText("ui.button") + " / " + Gui.this.getText("ui.highlight"), (JComponent)buttonColor));
                    this.add("tab", (Component)buttonColor);
                    this.add("tab", buttonColor.getTextComponent());
                    this.add("br", (Component)new JLabelFor(Gui.this.getText("ui.buttonText"), (JComponent)buttonTextColor));
                    this.add("tab", (Component)buttonTextColor);
                    this.add("tab", buttonTextColor.getTextComponent());
                    this.add("br", (Component)new JLabelFor(Gui.this.getText("ui.modalWindowsTheme"), (JComponent)this.modalWindowsTheme));
                    this.add("tab", this.modalWindowsTheme);
                    this.add("br", new JLabel(Gui.this.getText("ui.iconStyle")));
                    this.add("tab", this.iconStyle);
                }
            };
            this.typography = new ControlPanel(){
                {
                    headlineFont.setEditable(true);
                    this.add((Component)new JLabelFor(Gui.this.getText("ui.fontFamily"), (JComponent)fontFamily));
                    this.add("tab", fontFamily);
                    this.add("br", (Component)new JLabelFor(Gui.this.getText("ui.headlineFont"), (JComponent)headlineFont));
                    this.add("tab", headlineFont);
                    this.add("br", (Component)new JLabelFor(Gui.this.getText("ui.pairingSuggestions"), (JComponent)fontSuggestions));
                    this.add("tab", fontSuggestions);
                }
            };
            this.titlePage = new ControlPanel(new BorderLayout(0, 0)){
                ControlPanel titlePageSettings;
                ControlPanel folderCaptionSettings;
                JTabbedPane titlePageTabs;
                {
                    this.titlePageSettings = new ControlPanel(){
                        JTextField logoName = new JSmartTextField(12);
                        JButton selectLogo;
                        JSmartTextArea headerContent;
                        JScrollPane headerContentPane;
                        JSmartTextArea footerContent;
                        JScrollPane footerContentPane;
                        {
                            this.selectLogo = new JButton(Gui.this.getText("ui.select"));
                            this.headerContent = new JSmartTextArea(6, 20);
                            this.headerContentPane = new JScrollPane((Component)this.headerContent);
                            this.footerContent = new JSmartTextArea(6, 20);
                            this.footerContentPane = new JScrollPane((Component)this.footerContent);
                            this.selectLogo.setText(Gui.this.getText("ui.select"));
                            this.selectLogo.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    Gui.this.getFileToRes(Gui.this.imageFiles, logoName, (Component)Gui.this.skinUi);
                                }
                            });
                            this.headerContent.setLineWrap(false);
                            this.headerContent.setFont(Gui.this.mono);
                            this.headerContent.setTabSize(2);
                            Gui.this.allowHTMLEditing(this.headerContent);
                            this.headerContentPane.setBorder(BorderFactory.createTitledBorder(Gui.this.getText("ui.aboveContent")));
                            this.footerContent.setLineWrap(false);
                            this.footerContent.setFont(Gui.this.mono);
                            this.footerContent.setTabSize(2);
                            Gui.this.allowHTMLEditing(this.footerContent);
                            this.footerContentPane.setBorder(BorderFactory.createTitledBorder(Gui.this.getText("ui.belowContent")));
                            this.add("", new JLabel(Gui.this.getText("ui.logo")));
                            this.add("tab hfill", this.logoName);
                            this.add("", this.selectLogo);
                            this.add("br hfill", this.headerContentPane);
                            this.add("br hfill", this.footerContentPane);
                        }
                    };
                    this.folderCaptionSettings = new ControlPanel(){
                        private JComboBox<NameValue<String>> presets;
                        JTextArea folderCaptionTemplate;
                        JScrollPane captionPane;
                        JComboBox folderDateSource;
                        JCheckBox showFolderImageCount;
                        {
                            this.presets = new JComboBox<NameValue>(new NameValue[]{new NameValue("[ " + Gui.this.getText("ui.choosePreset") + " ]", null), new NameValue(Gui.this.getText("ui.empty"), (Object)""), new NameValue(Gui.this.getText("ui.title"), (Object)"<h3>${title}</h3>"), new NameValue(Gui.this.getText("ui.title") + " + " + Gui.this.getText("ui.comment"), (Object)"<h3>${title}</h3>\n<div class=\"comment\">${comment}</div>"), new NameValue(Gui.this.getText("ui.title") + " + " + Gui.this.getText("ui.commentShort") + " (" + Gui.this.getText("ui.default") + ")", (Object)"<h3>${title}</h3>\n<div class=\"comment\">${commentShort}</div>"), new NameValue(Gui.this.getText("ui.title") + " + " + Gui.this.getText("ui.comment") + " + " + Gui.this.getText("ui.date"), (Object)"<h3>${title}</h3>\n<div class=\"comment\">${comment}</div>\n<div class=\"date\">${folderModDate}</div>"), new NameValue(Gui.this.getText("ui.fileLabel"), (Object)"<h3>${fileLabel}</h3>"), new NameValue(Gui.this.getText("ui.fileLabel") + " + " + Gui.this.getText("ui.comment"), (Object)"<h3>${fileLabel}</h3>\n<div class=\"comment\">${comment}</div>"), new NameValue(Gui.this.getText("ui.fileLabel") + " + " + Gui.this.getText("ui.comment") + " + " + Gui.this.getText("ui.date"), (Object)"<h3>${fileLabel}</h3>\n<div class=\"comment\">${comment}</div>\n<div class=\"date\">${folderModDate}</div>")});
                            this.folderCaptionTemplate = new JTextArea(6, 20);
                            this.captionPane = new JScrollPane(this.folderCaptionTemplate);
                            this.folderDateSource = new JComboBox<Object>(new Object[]{new Item((Object)"none", (Object)Gui.this.getText("ui.none")), new Item((Object)"fileDate", (Object)Gui.this.getText("ui.fileDate")), new Item((Object)"folderModDate", (Object)Gui.this.getText("ui.folderModDate")), new Item((Object)"lastCameraDate", (Object)Gui.this.getText("ui.lastCameraDate")), new Item((Object)"cameraDateRange", (Object)Gui.this.getText("ui.cameraDateRange"))});
                            this.showFolderImageCount = new JCheckBox(Gui.this.getText("ui.showFolderImageCount"));
                            this.folderCaptionTemplate.setEditable(true);
                            this.folderCaptionTemplate.setLineWrap(true);
                            this.folderCaptionTemplate.setWrapStyleWord(true);
                            this.folderCaptionTemplate.setFont(Gui.this.mono);
                            this.folderCaptionTemplate.setTabSize(2);
                            this.captionPane.setBorder(BorderFactory.createTitledBorder(Gui.this.getText("ui.captionTemplate")));
                            this.presets.addItemListener(listener -> {
                                if (this.presets.getSelectedIndex() > 0) {
                                    this.folderCaptionTemplate.setText((String)((NameValue)this.presets.getSelectedItem()).value);
                                }
                            });
                            this.add("", (Component)new JLabelFor(Gui.this.getText("ui.presets"), this.presets));
                            this.add("tab", this.presets);
                            this.add("br hfill", this.captionPane);
                            this.add("br", (Component)new JLabelFor("${folderModDate} = ", (JComponent)this.folderDateSource));
                            this.add(" ", this.folderDateSource);
                            this.add("br", this.showFolderImageCount);
                        }
                    };
                    this.titlePageTabs = new JTabbedPane(){
                        {
                            titlePageSettings.setBorder(Gui.this.emptyBorder);
                            folderCaptionSettings.setBorder(Gui.this.emptyBorder);
                            this.addTab("<html><h4 style='padding:3px 4px;margin:3px 4px;'>" + Gui.this.getText("ui.layout") + "</h4></html>", (Component)titlePageSettings);
                            this.addTab("<html><h4 style='padding:3px 4px;margin:3px 4px;'>" + Gui.this.getText("ui.folderCaption") + "</h4></html>", (Component)folderCaptionSettings);
                        }
                    };
                    ((BorderLayout)this.getLayout()).setVgap(0);
                    ((BorderLayout)this.getLayout()).setHgap(0);
                    this.add(this.titlePageTabs);
                }
            };
            this.markNew = new ControlPanel(){
                JCheckBox markFilesNew;
                JTextField newDaysCount;
                JComboBox newDaysRef;
                JComboBox newDaysMark;
                JTextField newDaysText;
                JLabel newIcon;
                {
                    this.markFilesNew = new JCheckBox(Gui.this.getText("ui.markFilesNew"));
                    this.newDaysCount = new JSmartTextField("60", 3);
                    this.newDaysRef = new JComboBox<Object>(new Object[]{new Item((Object)"dateTaken", (Object)Gui.this.getText("ui.dateTaken")), new Item((Object)"fileModified", (Object)Gui.this.getText("ui.fileModified")), new Item((Object)"added", (Object)Gui.this.getText("ui.addedToAlbum"))});
                    this.newDaysMark = new JComboBox<Object>(new Object[]{new Item((Object)"icon", (Object)Gui.this.getText("ui.icon")), new Item((Object)"text", (Object)Gui.this.getText("ui.text"))});
                    this.newDaysText = new JSmartTextField(Gui.this.getText("new"), 6);
                    this.newIcon = new JLabel(Gui.icon("new-fill"));
                    this.newDaysCount.setToolTipText(Gui.this.getText("ui.newDaysCountInfo"));
                    this.newDaysMark.addItemListener(listener -> {
                        int i = this.newDaysMark.getSelectedIndex();
                        this.newDaysText.setVisible(i == 1);
                        this.newIcon.setVisible(i == 0);
                    });
                    this.newDaysText.setVisible(false);
                    ComponentUtilities.whenSelectedEnable((AbstractButton)this.markFilesNew, (JComponent[])new JComponent[]{this.newDaysCount, this.newDaysRef, this.newDaysMark, this.newDaysText, this.newIcon});
                    this.add("", this.markFilesNew);
                    this.add("", this.newDaysCount);
                    this.add(new JLabel(Gui.this.getText("ui.daysOld")));
                    this.add("br", new JLabel(Gui.this.getText("ui.reference")));
                    this.add("tab", this.newDaysRef);
                    this.add("br", new JLabel(Gui.this.getText("ui.marker")));
                    this.add("tab", this.newDaysMark);
                    this.add(this.newIcon);
                    this.add(this.newDaysText);
                }
            };
            this.topNavigation = new ControlPanel(){
                JCheckBox showUpButton;
                ControlPanel folderTree;
                {
                    this.showUpButton = new JCheckBox(Gui.this.getText("ui.showUpButton"));
                    this.folderTree = new ControlPanel(Gui.this.getText("ui.folderTree")){
                        JCheckBox topNavigationVisible;
                        JCheckBox topNavigationIncludeFolders;
                        JCheckBox topNavigationIncludePages;
                        JCheckBox topNavigationIncludeWebLocations;
                        JSpinner topNavigationDepth;
                        {
                            this.topNavigationVisible = new JCheckBox(Gui.this.getText("ui.visibleByDefault"), false);
                            this.topNavigationIncludeFolders = new JCheckBox(Gui.this.getText("ui.includeFolders"), true);
                            this.topNavigationIncludePages = new JCheckBox(Gui.this.getText("ui.includePages"));
                            this.topNavigationIncludeWebLocations = new JCheckBox(Gui.this.getText("ui.includeWebLocations"));
                            this.topNavigationDepth = new JSpinner(new SpinnerNumberModel(4, 1, 6, 1));
                            this.add("", this.topNavigationVisible);
                            this.add("br", this.topNavigationIncludeFolders);
                            this.add("br", this.topNavigationIncludePages);
                            this.add("br", this.topNavigationIncludeWebLocations);
                            this.add("br", new JLabel(Gui.this.getText("ui.depth")));
                            this.add("", this.topNavigationDepth);
                            this.add("", new JLabel(Gui.this.getText("ui.levels")));
                        }
                    };
                    this.add("br", this.showUpButton);
                    this.add("br hfill", (Component)this.folderTree);
                }
            };
            this.thumbnailStrip = new ControlPanel(){
                {
                    thumbsPreview.getView().setPreferredSize(new Dimension(480, 360));
                    new StateMonitor(){

                        public void onChange() {
                            this.setThumbDimensions();
                        }
                    }.add(thumbStyle);
                    this.add("br", (Component)new JLabelFor(Gui.this.getText("ui.style"), (JComponent)thumbStyle));
                    this.add("tab", thumbStyle);
                    this.add("br", (Component)new JLabelFor(Gui.this.getText("ui.gap"), (JComponent)thumbGap));
                    this.add("tab", thumbGap);
                    this.add("br tab", thumbsPreview.getView());
                }
            };
            this.titlePanel = new ControlPanel(){
                JCheckBox showTitle;
                JCheckBox showDescription;
                JCheckBox showDateRange;
                JCheckBox showCounts;
                JCheckBox showBreadcrumbPath;
                ControlPanel titleSubPanel;
                {
                    this.showTitle = new JCheckBox(Gui.this.getText("ui.showTitle"));
                    this.showDescription = new JCheckBox(Gui.this.getText("ui.showDescription"));
                    this.showDateRange = new JCheckBox(Gui.this.getText("ui.showDateRange"));
                    this.showCounts = new JCheckBox(Gui.this.getText("ui.showCounts"));
                    this.showBreadcrumbPath = new JCheckBox(Gui.this.getText("ui.showBreadcrumbPath"));
                    this.titleSubPanel = new ControlPanel(){
                        {
                            showBreadcrumbPath.setToolTipText(Gui.this.getText("ui.showBreadcrumbPathInfo"));
                            this.add(showDescription);
                            this.add("br", showDateRange);
                            this.add("br", showCounts);
                            this.add("br", showBreadcrumbPath);
                        }
                    };
                    ComponentUtilities.whenSelectedEnable((AbstractButton)this.showTitle, (JComponent)this.titleSubPanel);
                    this.add(this.showTitle);
                    this.add("br hfill", (Component)this.titleSubPanel);
                }
            };
            this.social = new ControlPanel(){
                ControlPanel shares;
                ControlPanel links;
                JLabel mandatoryInfo;
                {
                    this.shares = new ControlPanel(Gui.this.getText("ui.shareButtonFor")){
                        JCheckBox shareFacebook;
                        JCheckBox shareTwitter;
                        JCheckBox sharePinterest;
                        JCheckBox shareLinkedin;
                        JCheckBox shareDigg;
                        JCheckBox shareReddit;
                        JCheckBox shareTumblr;
                        {
                            this.shareFacebook = new JCheckBox("Facebook");
                            this.shareTwitter = new JCheckBox("Twitter");
                            this.sharePinterest = new JCheckBox("Pinterest");
                            this.shareLinkedin = new JCheckBox("LinkedIn");
                            this.shareDigg = new JCheckBox("Digg");
                            this.shareReddit = new JCheckBox("Reddit");
                            this.shareTumblr = new JCheckBox("Tumblr");
                            this.setLayout((LayoutManager)new RiverLayout(4, 5));
                            this.add(new JLabel(Gui.icon("facebook")));
                            this.add(this.shareFacebook);
                            this.add("br", new JLabel(Gui.icon("twitter")));
                            this.add(this.shareTwitter);
                            this.add("br", new JLabel(Gui.icon("tumblr")));
                            this.add(this.shareTumblr);
                            this.add("br", new JLabel(Gui.icon("pinterest")));
                            this.add(this.sharePinterest);
                            this.add("br", new JLabel(Gui.icon("linkedin")));
                            this.add(this.shareLinkedin);
                            this.add("br", new JLabel(Gui.icon("digg")));
                            this.add(this.shareDigg);
                            this.add("br", new JLabel(Gui.icon("reddit")));
                            this.add(this.shareReddit);
                        }
                    };
                    this.links = new ControlPanel(){
                        JCheckBox shareEmail = new JCheckBox("Email");
                        JLabel emailSubjectLabel;
                        JTextField emailSubject;
                        JCheckBox shareLink;
                        {
                            this.emailSubjectLabel = new JLabel(Gui.this.getText("ui.subject"));
                            this.emailSubject = new JSmartTextField(18);
                            this.shareLink = new JCheckBox(Gui.this.getText("ui.link"));
                            ComponentUtilities.whenSelectedEnable((AbstractButton)this.shareEmail, (JComponent[])new JComponent[]{this.emailSubjectLabel, this.emailSubject});
                            this.add("", new JLabel(Gui.icon("email")));
                            this.add("tab", this.shareEmail);
                            this.add("br tab", this.emailSubjectLabel);
                            this.add("", this.emailSubject);
                            this.add("br", new JLabel(Gui.icon("link")));
                            this.add("tab", this.shareLink);
                        }
                    };
                    this.mandatoryInfo = new JLabel(mandatory);
                    this.mandatoryInfo.setToolTipText(Gui.this.getText("ui.mandatory"));
                    this.links.setBorder(Gui.this.emptyBorder);
                    this.add("", (Component)this.shares);
                    this.add("hfill", (Component)this.links);
                    this.add("br", (Component)new JLabelFor(Gui.this.getText("ui.facebookAppId"), (JComponent)facebookAppId));
                    this.add(this.mandatoryInfo);
                    this.add("tab", facebookAppId);
                    this.add((Component)new JLinkLabel("https://developers.facebook.com/apps", Gui.this.getText("ui.signUp")));
                }
            };
            this.map = new ControlPanel(){
                JCheckBox showMap;
                JComboBox mapType;
                JSlider mapZoom;
                JTextField googleApiKey;
                JLabel mandatoryInfo;
                WrappableJLabel note;
                ControlPanel mapPanel;
                {
                    this.showMap = new JCheckBox(Gui.this.getText("ui.showMap"), true);
                    this.mapType = new JComboBox<Object>(new Object[]{new Item((Object)"roadmap", (Object)Gui.this.getText("ui.roadmap")), new Item((Object)"satellite", (Object)Gui.this.getText("ui.satellite")), new Item((Object)"hybrid", (Object)Gui.this.getText("ui.hybrid")), new Item((Object)"terrain", (Object)Gui.this.getText("ui.terrain"))});
                    this.mapZoom = new JSlider(0, 1, 20, 18);
                    this.googleApiKey = new JSmartTextField(24);
                    this.mandatoryInfo = new JLabel(mandatory);
                    this.note = new WrappableJLabel("<html><i>" + Gui.this.getText("ui.gooleMapsApiNote") + "</i></html>");
                    this.mapPanel = new ControlPanel(){
                        {
                            mapZoom.setOrientation(0);
                            mapZoom.setMinimum(0);
                            mapZoom.setMaximum(20);
                            mapZoom.setValue(18);
                            mapZoom.setMajorTickSpacing(10);
                            mapZoom.setMinorTickSpacing(1);
                            mapZoom.setPaintTicks(true);
                            mapZoom.setPaintLabels(true);
                            mapZoom.setSnapToTicks(true);
                            mandatoryInfo.setToolTipText(Gui.this.getText("ui.mandatory"));
                            note.setPreferredWidth(280);
                            this.add("br", (Component)new JLabelFor(Gui.this.getText("ui.initialView"), (JComponent)mapType));
                            this.add("tab", mapType);
                            this.add("br", (Component)new JLabelFor(Gui.this.getText("ui.initialZoom"), (JComponent)mapZoom));
                            this.add("tab", mapZoom);
                            this.add("br", (Component)new JLabelFor(Gui.this.getText("ui.googleApiKey"), (JComponent)googleApiKey));
                            this.add(mandatoryInfo);
                            this.add("tab", googleApiKey);
                            this.add("br tab", (Component)new JLinkLabel("https://console.developers.google.com/apis/credentials", Gui.this.getText("ui.createNew")));
                            this.add("br tab", (Component)note);
                            this.add("br tab", (Component)new JLinkLabel("https://developers.google.com/maps/documentation/javascript/tutorial", Gui.this.getText("ui.readMore")));
                        }
                    };
                    ComponentUtilities.whenSelectedEnable((AbstractButton)this.showMap, (JComponent)this.mapPanel);
                    this.add(this.showMap);
                    this.add("br hfill", (Component)this.mapPanel);
                }
            };
            this.backgroundMusic = new ControlPanel(){
                JPlaylist backgroundAudio = new JPlaylist();
                JCheckBox backgroundAudioAutoPlay;
                JSpinner backgroundAudioVolume;
                JCheckBox backgroundAudioSlideshowControl;
                JCheckBox backgroundAudioLoop;
                JCheckBox backgroundAudioRetainPosition;
                {
                    this.backgroundAudioAutoPlay = new JCheckBox(Gui.this.getText("ui.autoStart"));
                    this.backgroundAudioVolume = new JSpinner(new SpinnerNumberModel(25, 1, 100, 1));
                    this.backgroundAudioSlideshowControl = new JCheckBox(Gui.this.getText("ui.slideshowControl"));
                    this.backgroundAudioLoop = new JCheckBox(Gui.this.getText("ui.loop"));
                    this.backgroundAudioRetainPosition = new JCheckBox(Gui.this.getText("ui.retainPosition"), true);
                    this.backgroundAudioSlideshowControl.setToolTipText(Gui.this.getText("ui.slideshowControlInfo"));
                    this.backgroundAudioRetainPosition.setToolTipText(Gui.this.getText("ui.retainPositionInfo"));
                    this.add("br hfill", (Component)this.backgroundAudio);
                    this.add("br", new JLabel(Gui.this.getText("ui.initialVolume")));
                    this.add("", this.backgroundAudioVolume);
                    this.add("", new JLabel("%"));
                    this.add("br", this.backgroundAudioAutoPlay);
                    this.add("tab", this.backgroundAudioSlideshowControl);
                    this.add("br", this.backgroundAudioLoop);
                    this.add("tab", this.backgroundAudioRetainPosition);
                }
            };
            this.customCodePanel = new ControlPanel(){
                ControlPanel headHookTab = new ControlPanel(){
                    JTextArea headHook = new JSmartTextArea(7, 20);
                    JScrollPane headHookPane = new JScrollPane(this.headHook);
                    {
                        this.headHook.setEditable(true);
                        this.headHook.setLineWrap(false);
                        this.headHook.setFont(Gui.this.mono);
                        this.headHook.setTabSize(2);
                        this.headHookPane.setBorder(BorderFactory.createTitledBorder(Gui.this.getText("ui.headText")));
                        this.add("hfill vfill", this.headHookPane);
                    }
                };
                ControlPanel bodyHookTab = new ControlPanel(){
                    JTextArea bodyHook = new JSmartTextArea(7, 20);
                    JScrollPane bodyHookPane = new JScrollPane(this.bodyHook);
                    {
                        this.bodyHook.setEditable(true);
                        this.bodyHook.setLineWrap(false);
                        this.bodyHook.setFont(Gui.this.mono);
                        this.bodyHook.setTabSize(2);
                        this.bodyHookPane.setBorder(BorderFactory.createTitledBorder(Gui.this.getText("ui.bodyText")));
                        this.add("hfill vfill", this.bodyHookPane);
                    }
                };
                ControlPanel cssHookTab = new ControlPanel(){
                    JTextArea cssHook = new JSmartTextArea(15, 20);
                    JScrollPane cssHookPane = new JScrollPane(this.cssHook);
                    WrappableJLabel info;
                    {
                        this.info = new WrappableJLabel("<html><i>" + Gui.this.getText("ui.cssText") + "</i></html>");
                        this.cssHook.setEditable(true);
                        this.cssHook.setLineWrap(false);
                        this.cssHook.setFont(Gui.this.mono);
                        this.cssHook.setTabSize(2);
                        this.cssHookPane.setBorder(BorderFactory.createTitledBorder(Gui.this.getText("ui.cssTitle")));
                        this.info.setPreferredWidth(700);
                        this.add("hfill vfill", this.cssHookPane);
                        this.add("br", (Component)this.info);
                    }
                };
                ControlPanel jsHookTab = new ControlPanel(){
                    JTextArea jsHook = new JSmartTextArea(15, 20);
                    JScrollPane jsHookPane = new JScrollPane(this.jsHook);
                    WrappableJLabel info;
                    {
                        this.info = new WrappableJLabel("<html><i>" + Gui.this.getText("ui.javascriptText") + "</i></html>");
                        this.jsHook.setEditable(true);
                        this.jsHook.setLineWrap(false);
                        this.jsHook.setFont(Gui.this.mono);
                        this.jsHook.setTabSize(2);
                        this.jsHookPane.setBorder(BorderFactory.createTitledBorder(Gui.this.getText("ui.javascriptTitle")));
                        this.info.setPreferredWidth(700);
                        this.add("hfill vfill", this.jsHookPane);
                        this.add("br", (Component)this.info);
                    }
                };
                JTabbedPane customCodeTabs = new JTabbedPane(){
                    {
                        this.addTab("<HEAD>", Gui.icon("code"), (Component)headHookTab);
                        this.addTab("<BODY>", Gui.icon("code"), (Component)bodyHookTab);
                        this.addTab("CSS", Gui.icon("css"), (Component)cssHookTab);
                        this.addTab("JavaScript", Gui.icon("javascript"), (Component)jsHookTab);
                    }
                };
                {
                    this.add("hfill vfill", this.customCodeTabs);
                }
            };
            this.siteAdminPanel = new ControlPanel(){
                ControlPanel serverRelatedPanel;
                ControlPanel googlePanel;
                ControlPanel seoPanel;
                ControlPanel cookiePolicyPanel;
                JCheckBox debugMode;
                ControlPanel leftPanel;
                ControlPanel rightPanel;
                {
                    this.serverRelatedPanel = new ControlPanel(Gui.this.getText("ui.serverRelated")){
                        JTextField uploadPath;
                        JCheckBox useFavicon;
                        JCheckBox useMsServer;
                        JCheckBox useExpiry;
                        JCheckBox useRobotsTxt;
                        JCheckBox avoidCDNs;
                        JCheckBox copyGoogleFonts;
                        WrappableJLabel uploadPathInfo;
                        {
                            this.uploadPath = new JSmartTextField(16);
                            this.useFavicon = new JCheckBox(Gui.this.getText("ui.useTheSkinsFavicon"), true);
                            this.useMsServer = new JCheckBox(Gui.this.getText("ui.useMsServer"));
                            this.useExpiry = new JCheckBox(Gui.this.getText("ui.useExpiry"), false);
                            this.useRobotsTxt = new JCheckBox(Gui.this.getText("ui.useRobotsTxt"), false);
                            this.avoidCDNs = new JCheckBox(Gui.this.getText("ui.avoidCDNs"), true);
                            this.copyGoogleFonts = new JCheckBox(Gui.this.getText("ui.copyGoogleFonts"), true);
                            this.uploadPathInfo = new WrappableJLabel("<html><i>" + Gui.this.getText("ui.copyPasteAlbumURLHere") + "</i></html>");
                            this.uploadPath.setToolTipText(Gui.this.getText("ui.uploadPathInfo"));
                            this.uploadPathInfo.setPreferredWidth(360);
                            this.useFavicon.setToolTipText(Gui.this.getText("ui.useFaviconInfo"));
                            this.useMsServer.setToolTipText(Gui.this.getText("ui.useMsServerInfo"));
                            this.useExpiry.setToolTipText(Gui.this.getText("ui.useExpiryInfo"));
                            this.useRobotsTxt.setToolTipText(Gui.this.getText("ui.useRobotsTxtInfo"));
                            this.avoidCDNs.setToolTipText(Gui.this.getText("ui.avoidCDNsInfo"));
                            this.copyGoogleFonts.setToolTipText(Gui.this.getText("ui.copyGoogleFontsInfo"));
                            this.add(new JLabel(Gui.this.getText("ui.uploadPath")));
                            this.add("tab hfill", this.uploadPath);
                            this.add("br", new JLabel(infoIcon));
                            this.add("", (Component)this.uploadPathInfo);
                            this.add("br", this.useFavicon);
                            this.add(" ", new JLabel(Gui.svgIcon("logo-lucid", new Dimension(24, 24))));
                            this.add("br", this.useMsServer);
                            this.add("br", this.useExpiry);
                            this.add("br", this.useRobotsTxt);
                            this.add("br", this.avoidCDNs);
                            this.add("br", this.copyGoogleFonts);
                        }
                    };
                    this.googlePanel = new ControlPanel(Gui.this.getText("ui.googleAnalytics")){
                        JComboBox googleAnalytics;
                        JTextField googleSiteID;
                        JLabel mandatoryInfo;
                        JCheckBox supportDoubleclick;
                        {
                            this.googleAnalytics = new JComboBox<Object>(new Object[]{new Item((Object)"none", (Object)Gui.this.getText("ui.none")), new Item((Object)"gtag", (Object)"Global Site Tag (gtag.js)"), new Item((Object)"universal", (Object)"Universal (analytics.js)"), new Item((Object)"classic", (Object)"Classic (ga.js) [Legacy]")});
                            this.googleSiteID = new JSmartTextField(12);
                            this.mandatoryInfo = new JLabel(mandatory);
                            this.supportDoubleclick = new JCheckBox(Gui.this.getText("ui.supportDoubleclick"), false);
                            this.googleSiteID.setToolTipText(Gui.this.getText("ui.googleSiteIDInfo"));
                            this.mandatoryInfo.setToolTipText(Gui.this.getText("ui.mandatory"));
                            this.add("", (Component)new JLabelFor(Gui.this.getText("ui.version"), (JComponent)this.googleAnalytics));
                            this.add(" ", this.googleAnalytics);
                            this.add(" ", (Component)new JLinkLabel("https://www.google.com/analytics/", Gui.this.getText("ui.signUp")));
                            this.add("br", (Component)new JLabelFor(Gui.this.getText("ui.googleSiteID"), (JComponent)this.googleSiteID));
                            this.add(this.mandatoryInfo);
                            this.add("hfill", this.googleSiteID);
                            this.add("br", this.supportDoubleclick);
                        }
                    };
                    this.seoPanel = new ControlPanel(Gui.this.getText("ui.searchEngineOptimization")){
                        JTextField titleSEOText;
                        JTextField descriptionSEOText;
                        JSpinner preloadThumbs;
                        JCheckBox addAltTags;
                        JCheckBox writeSitemapXml;
                        JCheckBox sitemapIncludeSlides;
                        {
                            this.titleSEOText = new JSmartTextField(12);
                            this.descriptionSEOText = new JSmartTextField(12);
                            this.preloadThumbs = new JSpinner(new SpinnerNumberModel(20, 0, 1000, 10));
                            this.addAltTags = new JCheckBox(Gui.this.getText("ui.addAltTags"), true);
                            this.writeSitemapXml = new JCheckBox(Gui.this.getText("ui.createSitemapXml"));
                            this.sitemapIncludeSlides = new JCheckBox(Gui.this.getText("ui.includeSlides"), true);
                            this.titleSEOText.setToolTipText(Gui.this.getText("ui.titleSEOTextInfo"));
                            this.descriptionSEOText.setToolTipText(Gui.this.getText("ui.descriptionSEOTextInfo"));
                            this.addAltTags.setToolTipText(Gui.this.getText("ui.addAltTagsInfo"));
                            this.writeSitemapXml.setToolTipText(Gui.this.getText("ui.createSitemapXmlInfo"));
                            ComponentUtilities.whenSelectedEnable((AbstractButton)this.writeSitemapXml, (JComponent[])new JComponent[]{this.sitemapIncludeSlides});
                            this.sitemapIncludeSlides.setToolTipText(Gui.this.getText("ui.sitemapIncludeSlidesInfo"));
                            this.add("", (Component)new JLabelFor(Gui.this.getText("ui.titleSEOText"), (JComponent)this.titleSEOText));
                            this.add("tab hfill", this.titleSEOText);
                            this.add("br", (Component)new JLabelFor(Gui.this.getText("ui.descriptionSEOText"), (JComponent)this.descriptionSEOText));
                            this.add("tab hfill", this.descriptionSEOText);
                            this.add("br", new JLabel(Gui.this.getText("ui.preloadThumbs")));
                            this.add("", this.preloadThumbs);
                            this.add("br", this.addAltTags);
                            this.add("br", this.writeSitemapXml);
                            this.add("", this.sitemapIncludeSlides);
                        }
                    };
                    this.cookiePolicyPanel = new ControlPanel(Gui.this.getText("ui.trackingConsentAndCookiePolicy")){
                        JCheckBox askTrackingConsent;
                        JCheckBox showCookiePolicy;
                        JTextField cookiePolicyStay;
                        JTextField cookiePolicyUrl;
                        WrappableJLabel cookiePolicyUrlInfo;
                        {
                            this.askTrackingConsent = new JCheckBox(Gui.this.getText("ui.askTrackingConsent"), false);
                            this.showCookiePolicy = new JCheckBox(Gui.this.getText("ui.showCookiePolicy"), false);
                            this.cookiePolicyStay = new JSmartTextField("8", 3);
                            this.cookiePolicyUrl = new JSmartTextField(18);
                            this.cookiePolicyUrlInfo = new WrappableJLabel("<html><i>" + Gui.this.getText("ui.cookiePolicyUrlInfo") + " </i></html>");
                            this.askTrackingConsent.setToolTipText(Gui.this.getText("ui.askTrackingConsentInfo"));
                            this.showCookiePolicy.setToolTipText(Gui.this.getText("ui.showCookiePolicyInfo"));
                            this.cookiePolicyUrlInfo.setPreferredWidth(320);
                            this.add(this.askTrackingConsent);
                            this.add("br", this.showCookiePolicy);
                            this.add(" ", new JLabel(Gui.this.getText("ui.stay")));
                            this.add("", this.cookiePolicyStay);
                            this.add("", new JLabel("s"));
                            this.add("br", new JLabel("URL"));
                            this.add("tab hfill", this.cookiePolicyUrl);
                            this.add("br", new JLabel(infoIcon));
                            this.add("tab", (Component)this.cookiePolicyUrlInfo);
                        }
                    };
                    this.debugMode = new JCheckBox(Gui.this.getText("ui.debugMode"));
                    this.leftPanel = new ControlPanel(){
                        JComboBox shareImageDims = new JComboBox<Object>(new Object[]{"640x480", "1024x768", "1200x900", "1600x1200"});
                        {
                            this.shareImageDims.setEditable(true);
                            this.add("hfill", (Component)serverRelatedPanel);
                            this.add("br hfill", (Component)googlePanel);
                            this.add("br", new JLabel(Gui.this.getText("ui.shareImageDimensions")));
                            this.add("", this.shareImageDims);
                        }
                    };
                    this.rightPanel = new ControlPanel(){
                        {
                            this.add("hfill", (Component)seoPanel);
                            this.add("br hfill", (Component)cookiePolicyPanel);
                            this.add("br", debugMode);
                        }
                    };
                    this.add((Component)this.leftPanel);
                    this.add((Component)this.rightPanel);
                }
            };
            this.mainImage = new ControlPanel(){
                JSpinner hideControls = new JSpinner(new SpinnerNumberModel(3, 0, 999, 1));
                private String[] hideControlsLabel;
                JSpinner transitionSpeed;
                JCheckBox slideshowAuto;
                JSpinner slideshowDelay;
                JComboBox afterLast;
                JCheckBox neverScaleUp;
                JCheckBox videoAutoPlay;
                JLabel videoAutoPlayInfo;
                JCheckBox enableMouseWheel;
                JCheckBox enableKeyboard;
                JCheckBox clickForNext;
                JCheckBox rightClickProtect;
                {
                    this.hideControlsLabel = Gui.this.getText("ui.hideControlsAfter").split("\\{0\\}");
                    this.transitionSpeed = new JSpinner(new SpinnerNumberModel(1000, 50, 10000, 50));
                    this.slideshowAuto = new JCheckBox(Gui.this.getText("ui.autoStart"));
                    this.slideshowDelay = new JSpinner(new SpinnerNumberModel(3.0, 0.0, 20.0, 0.1));
                    this.afterLast = new JComboBox<Object>(new Object[]{new Item((Object)"donothing", (Object)Gui.this.getText("ui.doNothing")), new Item((Object)"startover", (Object)Gui.this.getText("startOver")), new Item((Object)"onelevelup", (Object)Gui.this.getText("upOneLevel")), new Item((Object)"nextfolder", (Object)Gui.this.getText("nextFoldersFirstImage")), new Item((Object)"nextindex", (Object)Gui.this.getText("nextIndex")), new Item((Object)"ask", (Object)Gui.this.getText("ui.ask"))});
                    this.neverScaleUp = new JCheckBox(Gui.this.getText("ui.neverScaleUp"));
                    this.videoAutoPlay = new JCheckBox(Gui.this.getText("ui.startVideo"));
                    this.videoAutoPlayInfo = new JLabel(infoIcon);
                    this.enableMouseWheel = new JCheckBox(Gui.this.getText("ui.enableMouseWheel"));
                    this.enableKeyboard = new JCheckBox(Gui.this.getText("ui.enableKeyboard"));
                    this.clickForNext = new JCheckBox(Gui.this.getText("ui.clickForNext"));
                    this.rightClickProtect = new JCheckBox(Gui.this.getText("ui.rightClickProtect"));
                    showImageNumbers.setToolTipText(Gui.this.getText("ui.showNumbersInfo"));
                    this.afterLast.setToolTipText(Gui.this.getText("ui.afterLastInfo"));
                    this.transitionSpeed.setToolTipText(Gui.this.getText("ui.transitionSpeedInfo"));
                    this.slideshowDelay.setToolTipText(Gui.this.getText("ui.slideshowDelayInfo"));
                    this.neverScaleUp.setToolTipText(Gui.this.getText("ui.neverScaleUpInfo"));
                    this.videoAutoPlayInfo.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mouseReleased(MouseEvent e) {
                            JOptionPane.showMessageDialog((Component)Gui.this.window, Gui.this.getText("ui.videoAutoplayInfo1"), "Warning", 2);
                        }
                    });
                    this.enableMouseWheel.setToolTipText(Gui.this.getText("ui.enableMouseWheelInfo"));
                    this.enableKeyboard.setToolTipText(Gui.this.getText("ui.enableKeyboardInfo"));
                    this.clickForNext.setToolTipText(Gui.this.getText("ui.clickForNextInfo"));
                    this.add("", new JLabel(this.hideControlsLabel[0]));
                    this.add("tab", this.hideControls);
                    if (this.hideControlsLabel.length > 1) {
                        this.add(new JLabel(this.hideControlsLabel[1]));
                    }
                    this.add("br tab", new JLabel("<html><i>" + Gui.this.getText("ui.hideControlsInfo") + "</i></html>"));
                    this.add("br", showImageNumbers);
                    this.add("br", showFullscreen);
                    this.add(new JLabel(Gui.icon("fullscreen")));
                    this.add("br", this.slideshowAuto);
                    this.add("br", (Component)new JLabelFor(Gui.this.getText("ui.transitionSpeed"), (JComponent)this.transitionSpeed));
                    this.add("tab", this.transitionSpeed);
                    this.add(new JLabel("ms"));
                    this.add("br", new JLabel(Gui.this.getText("ui.slideshowDelay")));
                    this.add("tab", this.slideshowDelay);
                    this.add(new JLabel("s"));
                    this.add("br", (Component)new JLabelFor(Gui.this.getText("ui.afterLast"), (JComponent)this.afterLast));
                    this.add("tab", this.afterLast);
                    this.add("br", (Component)new JLabelFor(Gui.this.getText("ui.neighboringItemsVisibility"), (JComponent)neighboringItemsOpacity));
                    this.add("tab", neighboringItemsOpacity);
                    this.add("br", (Component)new JLabelFor(Gui.this.getText("ui.fillHorizontally"), (JComponent)fillHorizontally));
                    this.add("tab", fillHorizontally);
                    this.add("br", (Component)new JLabelFor(Gui.this.getText("ui.fillVertically"), (JComponent)fillVertically));
                    this.add("tab", fillVertically);
                    this.add("br", this.neverScaleUp);
                    this.add("br", this.videoAutoPlay);
                    this.add("", this.videoAutoPlayInfo);
                    this.add("br", this.enableMouseWheel);
                    this.add("br", this.enableKeyboard);
                    this.add("br", this.clickForNext);
                    this.add("br", this.rightClickProtect);
                }
            };
            this.imageCaption = new ControlPanel(){
                private JComboBox<NameValue<String>> presets;
                JScrollPane imageCaptionPane;
                {
                    this.presets = new JComboBox<NameValue>(new NameValue[]{new NameValue("[ " + Gui.this.getText("ui.choosePreset") + " ]", null), new NameValue(Gui.this.getText("ui.empty"), (Object)""), new NameValue(Gui.this.getText("ui.title"), (Object)"<div class=\"title\">${fileTitle}</div>"), new NameValue(Gui.this.getText("ui.title") + " + " + Gui.this.getText("ui.comment"), (Object)"<div class=\"title\">${fileTitle}</div>\n<div class=\"comment\">${comment}</div>"), new NameValue(Gui.this.getText("ui.title") + " + " + Gui.this.getText("ui.commentShort"), (Object)"<div class=\"title\">${fileTitle}</div>\n<div class=\"comment\">${commentShort}</div>"), new NameValue(Gui.this.getText("ui.fileLabel"), (Object)"<div class=\"title\">${fileLabel}</div>"), new NameValue(Gui.this.getText("ui.fileLabel") + " + " + Gui.this.getText("ui.comment") + " (" + Gui.this.getText("ui.default") + ")", (Object)"<div class=\"title\">${fileLabel}</div>\n<div class=\"comment\">${comment}</div>"), new NameValue(Gui.this.getText("ui.fileLabel") + " + " + Gui.this.getText("ui.commentShort"), (Object)"<div class=\"title\">${fileLabel}</div>\n<div class=\"comment\">${commentShort}</div>"), new NameValue(Gui.this.getText("ui.title") + " + " + Gui.this.getText("ui.comment") + " + " + Gui.this.getText("author") + " + " + Gui.this.getText("keywords"), (Object)"<div class=\"title\">${fileLabel}</div>\n<div class=\"comment\">${comment}</div>\n<div class=\"comment\"><small class=\"icon-user\"> ${author}</small> <small class=\"icon-label\"> ${keywords}</small></div>")});
                    this.imageCaptionPane = new JScrollPane(imageCaptionTemplate);
                    this.presets.addItemListener(listener -> {
                        if (this.presets.getSelectedIndex() > 0) {
                            imageCaptionTemplate.setText((String)((NameValue)this.presets.getSelectedItem()).value);
                        }
                    });
                    imageCaptionTemplate.setEditable(true);
                    imageCaptionTemplate.setLineWrap(true);
                    imageCaptionTemplate.setWrapStyleWord(true);
                    imageCaptionTemplate.setFont(Gui.this.mono);
                    imageCaptionTemplate.setTabSize(2);
                    this.imageCaptionPane.setBorder(BorderFactory.createTitledBorder(Gui.this.getText("ui.captionTemplate")));
                    this.add("", (Component)new JLabelFor(Gui.this.getText("ui.position"), (JComponent)captionPlacement));
                    this.add("tab", captionPlacement);
                    this.add("br", (Component)new JLabelFor(Gui.this.getText("ui.style"), (JComponent)captionStyle));
                    this.add("tab", captionStyle);
                    this.add("br", (Component)new JLabelFor(Gui.this.getText("ui.presets"), this.presets));
                    this.add("tab", this.presets);
                    this.add("br hfill", this.imageCaptionPane);
                }
            };
            this.buttons = new ControlPanel(){
                ControlPanel downloadOptions = new ControlPanel(){
                    JCheckBox downloadNonImages;
                    JCheckBox downloadScaled;
                    {
                        this.downloadNonImages = new JCheckBox(Gui.this.getText("ui.enableDownloadNonImages"));
                        this.downloadScaled = new JCheckBox(Gui.this.getText("ui.enableDownloadScaledImages"));
                        this.downloadNonImages.setToolTipText(Gui.this.getText("ui.enableDownloadNonImagesInfo"));
                        this.add(this.downloadScaled);
                        this.add("br", this.downloadNonImages);
                    }
                };
                JCheckBox useFotomoto;
                ControlPanel photodataOptions;
                {
                    this.useFotomoto = new JCheckBox(Gui.this.getText("ui.useFotomoto"));
                    this.photodataOptions = new ControlPanel(){
                        JCheckBox showPhotoDataLabel;
                        JTextArea photoDataTemplate;
                        JScrollPane photoDataPane;
                        JButton reset;
                        WrappableJLabel listMetadataHint;
                        {
                            this.showPhotoDataLabel = new JCheckBox(Gui.this.getText("ui.showLabel"), true);
                            this.photoDataTemplate = new JSmartTextArea(12, 16);
                            this.photoDataPane = new JScrollPane(this.photoDataTemplate);
                            this.reset = new JButton(Gui.this.getText("ui.resetToDefaults"));
                            this.listMetadataHint = new WrappableJLabel("<html><i>" + Gui.this.getText("ui.listMetadataHint") + "</i></html>");
                            this.showPhotoDataLabel.setToolTipText(Gui.this.getText("ui.showLabelInfo"));
                            this.photoDataTemplate.setEditable(true);
                            this.photoDataTemplate.setLineWrap(false);
                            this.photoDataTemplate.setFont(Gui.this.mono);
                            this.reset.addMouseListener(new MouseAdapter(){

                                @Override
                                public void mouseReleased(MouseEvent e) {
                                    String s;
                                    if (reset.isEnabled() && (s = new SkinModel().photoDataTemplate) != null && s.length() > 0) {
                                        photoDataTemplate.setText(s);
                                    }
                                }
                            });
                            this.photoDataPane.setPreferredSize(new Dimension(380, 240));
                            this.listMetadataHint.setPreferredWidth(380);
                            this.add(" ", this.showPhotoDataLabel);
                            this.add(" ", this.reset);
                            this.add("br", this.photoDataPane);
                            this.add("br", (Component)this.listMetadataHint);
                        }
                    };
                    printImageButton.setToolTipText(Gui.this.getText("ui.printImageButtonInfo"));
                    showDownload.setToolTipText(Gui.this.getText("ui.showDownloadInfo"));
                    ComponentUtilities.whenSelectedEnable((AbstractButton)showDownload, (JComponent[])new JComponent[]{this.downloadOptions});
                    showPhotoData.setToolTipText(Gui.this.getText("ui.showPhotoDataInfo"));
                    ComponentUtilities.whenSelectedEnable((AbstractButton)showPhotoData, (JComponent[])new JComponent[]{this.photodataOptions});
                    this.add("", new JLabel(Gui.icon("printer")));
                    this.add("tab", printImageButton);
                    this.add("br", new JLabel(Gui.icon("download")));
                    this.add("tab", showDownload);
                    this.add("br tab hfill", (Component)this.downloadOptions);
                    this.add("br", new JLabel(Gui.icon("camera")));
                    this.add("tab", showPhotoData);
                    this.add("br tab hfill vfill", (Component)this.photodataOptions);
                }
            };
            this.site = new ControlPanel(new BorderLayout(0, 0)){
                JTabbedPane siteTabs;
                ControlPanel designPreviewPanel;
                {
                    this.siteTabs = new JTabbedPane(){
                        JScrollPane mainImagePane;
                        {
                            this.mainImagePane = new JScrollPane((Component)mainImage, 20, 31);
                            this.mainImagePane.setBorder(Gui.this.emptyBorder);
                            this.setTabPlacement(2);
                            this.addTab("<html><h4 style='padding:3px 4px;margin:3px 4px;'>" + Gui.this.getText("ui.design") + "</h4></html>", Gui.icon("design"), (Component)design);
                            this.addTab("<html><h4 style='padding:3px 4px;margin:3px 4px;'>" + Gui.this.getText("ui.typography") + "</h4></html>", Gui.icon("font"), (Component)typography);
                            this.addTab("<html><h4 style='padding:3px 4px;margin:3px 4px;'>" + Gui.this.getText("ui.titlePage") + "</h4></html>", Gui.icon("title"), (Component)titlePage);
                            this.addTab("<html><h4 style='padding:3px 4px;margin:3px 4px;'>" + Gui.this.getText("ui.lightbox") + "</h4></html>", Gui.icon("lightbox"), this.mainImagePane);
                            this.addTab("<html><h4 style='padding:3px 4px;margin:3px 4px;'>" + Gui.this.getText("ui.caption") + "</h4></html>", Gui.icon("comment"), (Component)imageCaption);
                            this.addTab("<html><h4 style='padding:3px 4px;margin:3px 4px;'>" + Gui.this.getText("ui.buttons") + "</h4></html>", Gui.icon("button"), (Component)buttons);
                            this.addTab("<html><h4 style='padding:3px 4px;margin:3px 4px;'>" + Gui.this.getText("ui.newImages") + "</h4></html>", Gui.icon("new"), (Component)markNew);
                        }
                    };
                    this.designPreviewPanel = new ControlPanel(new BorderLayout(0, 0)){
                        JPanel desPreview;
                        {
                            this.desPreview = new JPanel(new BorderLayout(0, 0)){
                                {
                                    this.add(designPreview.getView());
                                }
                            };
                            this.desPreview.setPreferredSize(new Dimension(476, 400));
                            this.desPreview.setBorder(BorderFactory.createLineBorder(JAlbumColor.imageBorder, 2));
                            this.add(this.desPreview, "North");
                        }
                    };
                    ((BorderLayout)this.getLayout()).setVgap(0);
                    ((BorderLayout)this.getLayout()).setHgap(0);
                    this.siteTabs.setBorder(Gui.this.emptyBorder);
                    this.add(this.siteTabs);
                    this.add((Component)this.designPreviewPanel, "East");
                }
            };
            this.controls = new ControlPanel(new BorderLayout(20, 0)){
                ControlPanel ordering;
                JTabbedPane controlTabs;
                {
                    this.ordering = new ControlPanel(){
                        JList controlsOrder;
                        {
                            this.controlsOrder = new JDraggableList(new Object[]{new JLabelFor("<html><p style=\"padding:3px 0;\">" + Gui.this.getText("ui.navigation") + "</p></html>", Gui.icon("menu")).name("navigation"), new JLabelFor("<html><p style=\"padding:3px 0;\">" + Gui.this.getText("ui.thumbnails") + "</p></html>", Gui.icon("thumbnails")).name("thumbnails"), new JLabelFor("<html><p style=\"padding:3px 0;\">" + Gui.this.getText("ui.title") + "</p></html>", Gui.icon("type")).name("title"), new JLabelFor("<html><p style=\"padding:3px 0;\">" + Gui.this.getText("ui.map") + "</p></html>", Gui.icon("location")).name("map"), new JLabelFor("<html><p style=\"padding:3px 0;\">" + Gui.this.getText("ui.social") + "</p></html>", Gui.icon("connect")).name("social"), new JLabelFor("<html><p style=\"padding:3px 0;\">" + Gui.this.getText("ui.backgroundMusic") + "</p></html>", Gui.icon("audio")).name("music")});
                            this.add("center", new JLabel("<html><h4>" + Gui.this.getText("ui.ordering") + "</h4></html>"));
                            this.add("br", this.controlsOrder);
                            this.add("br center", new JLabel("<html><i>" + Gui.this.getText("ui.dragToReorder") + "</i></html>"));
                        }
                    };
                    this.controlTabs = new JTabbedPane(){
                        {
                            this.setTabPlacement(2);
                            this.addTab("<html><h4 style='padding:3px 4px;margin:3px 4px;'>" + Gui.this.getText("ui.navigation") + "</h4></html>", Gui.icon("folders"), (Component)topNavigation);
                            this.addTab("<html><h4 style='padding:3px 4px;margin:3px 4px;'>" + Gui.this.getText("ui.thumbnails") + "</h4></html>", Gui.icon("thumbnails"), (Component)thumbnailStrip);
                            this.addTab("<html><h4 style='padding:3px 4px;margin:3px 4px;'>" + Gui.this.getText("ui.title") + "</h4></html>", Gui.icon("type"), (Component)titlePanel);
                            this.addTab("<html><h4 style='padding:3px 4px;margin:3px 4px;'>" + Gui.this.getText("ui.map") + "</h4></html>", Gui.icon("location"), (Component)map);
                            this.addTab("<html><h4 style='padding:3px 4px;margin:3px 4px;'>" + Gui.this.getText("ui.social") + "</h4></html>", Gui.icon("connect"), (Component)social);
                            this.addTab("<html><h4 style='padding:3px 4px;margin:3px 4px;'>" + Gui.this.getText("ui.backgroundMusic") + "</h4></html>", Gui.icon("audio"), (Component)backgroundMusic);
                        }
                    };
                    ((BorderLayout)this.getLayout()).setVgap(0);
                    ((BorderLayout)this.getLayout()).setHgap(0);
                    this.controlTabs.setBorder(Gui.this.emptyBorder);
                    this.add(this.controlTabs);
                    this.add((Component)this.ordering, "East");
                }
            };
            this.advanced = new ControlPanel(new BorderLayout(0, 0)){
                JTabbedPane advancedTabs;
                {
                    this.advancedTabs = new JTabbedPane(){
                        JScrollPane siteAdminPane;
                        {
                            this.siteAdminPane = new JScrollPane((Component)siteAdminPanel, 20, 31);
                            customCodePanel.setBorder(Gui.this.emptyBorder);
                            this.siteAdminPane.setBorder(Gui.this.emptyBorder);
                            this.setTabPlacement(2);
                            this.addTab("<html><h4 style='padding:3px 4px;margin:3px 4px;'>" + Gui.this.getText("ui.siteAdmin") + "</h4></html>", Gui.icon("wrench"), this.siteAdminPane);
                            this.addTab("<html><h4 style='padding:3px 4px;margin:3px 4px;'>" + Gui.this.getText("ui.customCode") + "</h4></html>", Gui.icon("code"), (Component)customCodePanel);
                        }
                    };
                    ((BorderLayout)this.getLayout()).setVgap(0);
                    ((BorderLayout)this.getLayout()).setHgap(0);
                    this.add(this.advancedTabs);
                }
            };
            this.about = new ControlPanel(new BorderLayout(20, 0)){
                private JTextArea readme;
                private JScrollPane aboutPane;
                ControlPanel info;
                {
                    this.readme = new JSmartTextArea(Gui.this.getFileContents("readme.txt"), 20, 30);
                    this.aboutPane = new JScrollPane(this.readme, 22, 31);
                    this.info = new ControlPanel(){
                        {
                            this.add("center", new JLabel(Gui.svgIcon("logo-lucid", new Dimension(120, 120))));
                            this.add("br center", new JLabel("<html><h2>" + Gui.this.skin + "</h2></html>"));
                            this.add("br center", new JLabel("Jalbum " + Gui.this.internalVersion));
                            this.add((Component)new JLinkLabel("https://jalbum.net/software/download", Gui.this.getText("ui.upgrade"), Gui.this.getText("ui.downloadJalbum")));
                            this.add("br center", new JLabel(Gui.this.skin + " skin " + Gui.this.skinVer));
                            this.add((Component)new JLinkLabel("https://jalbum.net/skins/skin/" + Gui.this.skin, Gui.this.getText("ui.upgrade"), Gui.this.getText("ui.downloadSkin")));
                            this.add("br center", (Component)new JLinkLabel(Gui.this.supportForum, Gui.this.getText("ui.support")));
                        }
                    };
                    ((BorderLayout)this.getLayout()).setVgap(0);
                    ((BorderLayout)this.getLayout()).setHgap(0);
                    this.readme.setLineWrap(true);
                    this.readme.setWrapStyleWord(true);
                    this.readme.setEditable(false);
                    this.readme.setFont(Gui.this.mono);
                    this.info.setPreferredSize(new Dimension(240, 480));
                    this.add((Component)this.info, "West");
                    this.add(this.aboutPane);
                }
            };
            this.tabs = new JTabbedPane(){
                {
                    site.setBorder(Gui.this.emptyBorder);
                    controls.setBorder(Gui.this.emptyBorder);
                    advanced.setBorder(Gui.this.emptyBorder);
                    about.setBorder(Gui.this.emptyBorder);
                    this.addTab("<html><h4 style='padding:4px 6px;margin:4px;'>" + Gui.this.getText("ui.site") + "</h4></html>", Gui.icon("site", 27), (Component)site);
                    this.addTab("<html><h4 style='padding:4px 6px;margin:4px;'>" + Gui.this.getText("ui.controls") + "</h4></html>", Gui.icon("header", 27), (Component)controls);
                    this.addTab("<html><h4 style='padding:4px 6px;margin:4px;'>" + Gui.this.getText("ui.advanced") + "</h4></html>", Gui.icon("wrench", 27), (Component)advanced);
                    this.addTab("<html><h4 style='padding:4px 6px;margin:4px;'>" + Gui.this.getText("ui.about") + "</h4></html>", Gui.icon("info", 27), (Component)about);
                }
            };
            this.designTemplate = Gui.this.getFileContents("lib/design-template.html");
            this.thumbsTemplate = Gui.this.getFileContents("lib/thumbs-template.html");
            ((RiverLayout)this.getLayout()).setVgap(0);
            ((RiverLayout)this.getLayout()).setHgap(0);
            this.tabs.setBorder(Gui.this.emptyBorder);
            this.add("vfill", this.tabs);
            Gui.this.window.addJAlbumListener((JAlbumListener)new JAlbumAdapter(){

                public void styleChanged(JAlbumEvent e) {
                    styleName.setText(Gui.this.getStyleName());
                }
            });
            Gui.this.window.addPropertyChangeListener("skinLoaded", this.setupMonitors);
            Gui.this.window.addJAlbumListener((JAlbumListener)new JAlbumAdapter(){

                public void skinChanged(JAlbumEvent e) {
                    Gui.this.window.removePropertyChangeListener("skinLoaded", setupMonitors);
                }
            });
        }

        public void importVariables(Map<String, Object> vars) {
            String lastSkin;
            boolean skinChanged;
            if (this.skinChangeReported || Gui.this.window.projectChooser.getSelectedFile() == null) {
                return;
            }
            Map skinVars = Gui.this.engine.getSkinVariables();
            int omv = Gui.this.getMajorVersion(skinVars.get("majorSkinVersion"));
            int cmv = Gui.this.getMajorVersion(Gui.this.skinVer);
            if (omv == -1) {
                omv = Gui.this.getMajorVersion(skinVars.get("skinVersion"));
            }
            boolean bl = skinChanged = (lastSkin = Gui.this.getLastSkinName()) != null && !Gui.this.getSkinName().equals(lastSkin);
            if (cmv != -1) {
                skinVars.put("majorSkinVersion", cmv);
            }
            if (skinChanged || cmv > omv) {
                JNotification jn;
                if (skinChanged) {
                    JAlbum.logger.log(Level.FINE, "Skin changed: {0} -> {1} v{2}", new Object[]{lastSkin, Gui.this.skin, cmv});
                    jn = new JNotification(Gui.this.getText("ui.madeWithAnotherSkin") + "\n" + Gui.this.getText("ui.backupSaved"), JNotification.Type.SKIN);
                    Gui.this.backupProjectFile(lastSkin != null ? lastSkin : "old");
                } else {
                    JAlbum.logger.log(Level.FINE, "Major version changed: {0} v{1} -> v{2}", new Object[]{Gui.this.skin, omv, cmv});
                    jn = new JNotification(Gui.this.getText("ui.madeWithOldVersion").replaceAll("\\{0\\}", Gui.this.skin) + (omv == -1 ? "" : "(" + omv + ")") + "\n\n" + Gui.this.getText("ui.backupSaved"), JNotification.Type.SKIN);
                    Gui.this.backupProjectFile(omv >= 0 ? String.valueOf(omv) : "old");
                }
                jn.setExpiration(3);
                jn.setRememberDismissed(true);
                Gui.this.window.showNotification(jn);
                this.skinChangeReported = true;
                Gui.this.engine.setUpdatedDirsOnly(false);
            }
        }

        private void setFontBoxes() {
            if (this.fontSuggestions.getSelectedIndex() == 0) {
                return;
            }
            String s = this.fontSuggestions.getSelectedItem().toString();
            String hf = s.split("/")[0].trim();
            String ff = s.split("/")[1].trim();
            Gui.this.setSelectedValue(this.fontFamily, ff);
            Gui.this.setSelectedValue(this.headlineFont, hf);
            this.fontSuggestions.setSelectedIndex(0);
        }

        private void setThumbDimensions() {
            String ndim;
            if (!Gui.this.skinReady) {
                return;
            }
            String style = ((Item)this.thumbStyle.getSelectedItem()).value.toString();
            String cdim = Gui.this.engine.getThumbSize();
            switch (style) {
                case "grid": {
                    ndim = "120x120";
                    break;
                }
                case "dots": {
                    ndim = "120x120";
                    break;
                }
                default: {
                    ndim = "200x120";
                }
            }
            if (!cdim.equals(ndim) && !this.lastThumbDimSuggestion.equals(ndim)) {
                Object[] options = new Object[]{Gui.this.getText("ui.yes"), Gui.this.getText("ui.no")};
                int n = JOptionPane.showOptionDialog((Component)Gui.this.window, Gui.this.getText("ui.changeThumbnailDimensionsQuestion").replace("{0}", ndim), Gui.this.getText("ui.updatingThumbnailDimensions"), 0, 1, null, options, options[0]);
                if (n == 0) {
                    try {
                        JAlbum.logger.log(Level.FINE, "Thumb size is changed to {0}px", ndim);
                        Gui.this.window.ui2Engine();
                        Gui.this.engine.setThumbSize(ndim);
                        Gui.this.window.engine2UI();
                    }
                    catch (ParameterException ex) {
                        throw new RuntimeException(ex);
                    }
                    this.lastThumbDimSuggestion = "";
                } else {
                    this.lastThumbDimSuggestion = ndim;
                }
            }
        }

        private void refreshDesignPreview() {
            String bc = Gui.this.getCssColor(this.backgroundColor.toString());
            String cbc = Gui.this.getCssColor(this.controlsBackgroundColor.toString());
            String caption = this.imageCaptionTemplate.getText().trim();
            Double cbo = Gui.this.getAlpha(this.controlsBackgroundColor.toString());
            if (caption.length() > 0) {
                caption = caption.replace("${fileLabel}", "Title or file name").replace("${fileTitle}", "Title").replace("${author}", "Author's Name.").replace("${keywords}", "Keyword 1, Keyword 2").replace("${comment}", "This is the comment.").replace("${commentShort}", "Short comment.");
            }
            String html = this.designTemplate.replace("{bodyClass}", cbo > 0.95 ? "opaque" : "transp").replace("{backgroundColor}", bc).replace("{controlsBgColor}", cbc).replace("{textColor}", this.textColor.toString()).replace("{buttonColor}", Gui.this.getCssColor(this.buttonColor.toString())).replace("{buttonTextColor}", Gui.this.getCssColor(this.buttonTextColor.toString())).replace("{fullscreenVisible}", this.showFullscreen.isSelected() ? "visible" : "hidden").replace("{numbersVisible}", this.showImageNumbers.isSelected() ? "visible" : "hidden").replace("{captionPlacement}", Gui.this.getSelectedValue(this.captionPlacement)).replace("{captionStyle}", Gui.this.getSelectedValue(this.captionStyle)).replace("{captionVisibility}", caption.length() > 0 || this.printImageButton.isSelected() || this.showDownload.isSelected() || this.showPhotoData.isSelected() ? "visible" : "hidden").replace("{caption}", caption).replace("{showPrint}", this.printImageButton.isSelected() ? "" : "hidden").replace("{showDownload}", this.showDownload.isSelected() ? "" : "hidden").replace("{showPhotodata}", this.showPhotoData.isSelected() ? "" : "hidden").replace("{fillHorizontal}", Gui.this.getSpinnerValueAsInt(this.fillHorizontally) + "").replace("{fillVertical}", Gui.this.getSpinnerValueAsInt(this.fillVertically) + "").replace("{neighboringItemsOpacity}", (double)Gui.this.getSpinnerValueAsInt(this.neighboringItemsOpacity) / 100.0 + "");
            String html1 = html = Gui.this.getFonts(html, Gui.this.getSelectedValue(this.fontFamily), this.headlineFont.getSelectedIndex() == 0 ? "" : Gui.this.getSelectedValue(this.headlineFont));
            SwingUtilities.invokeLater(() -> this.designPreview.loadContent(html1));
        }

        private void refreshThumbsPreview() {
            String html;
            String html1 = html = this.thumbsTemplate.replace("{backgroundColor}", Gui.this.getCssColor(this.backgroundColor.toString())).replace("{panelBackgroundColor}", Gui.this.getCssColor(this.controlsBackgroundColor.toString())).replace("{thumbGap}", this.thumbGap.getValue().toString()).replace("{thumbStyle}", ((Item)this.thumbStyle.getSelectedItem()).value.toString());
            SwingUtilities.invokeLater(() -> this.thumbsPreview.loadContent(html1));
        }
    };

    private String getStyleName() {
        this.window.ui2Engine();
        String style = this.engine.getStyle();
        return style.substring(0, style.indexOf("."));
    }

    private String getSkinName() {
        return this.engine.getSkin();
    }

    private String getLastSkinName() {
        String ls = null;
        try {
            ls = this.engine.getLastSkin();
        }
        catch (Throwable t) {
            JAlbum.logger.log(Level.FINER, "Last skin is unknown.");
        }
        return ls;
    }

    private final String unCamelCase(String s) {
        if (s.length() > 0) {
            s = s.replaceAll("([a-z])([A-Z]+)", "$1 $2");
            return Character.toUpperCase(s.charAt(0)) + s.substring(1);
        }
        return "";
    }

    private final String getText(String t) {
        String s;
        try {
            s = this.texts.getString(t);
        }
        catch (MissingResourceException e) {
            JAlbum.logger.log(Level.FINE, "Missing text: \"{0}\"", t);
            if (t.startsWith("ui.")) {
                t = t.substring(3);
            }
            s = this.unCamelCase(t);
        }
        return s;
    }

    private String getFonts(String html, String ff, String hf) {
        String gf = "";
        String fw = "";
        String bw = "bold";
        String hw = "";
        if (ff.contains(":")) {
            gf = ff;
            fw = ff.split(":")[1];
            if (fw.length() > 0) {
                String[] w = fw.split(",");
                bw = w.length > 2 ? w[2] : w[1];
                fw = w[0];
            }
            if ((ff = ff.split(":")[0]).contains(" ")) {
                ff = "\"" + ff + "\"";
            }
            ff = ff + ",sans-serif";
        }
        if (!hf.equals("")) {
            if (!hf.equals(gf)) {
                String string = gf = gf.length() > 0 ? gf + "|" + hf : hf;
            }
            if (hf.contains(":")) {
                hw = hf.split(":")[1];
                if (hw.length() > 0) {
                    hw = hw.split(",")[0];
                }
                hf = hf.split(":")[0];
            }
            if (hf.contains(" ")) {
                hf = "\"" + hf + "\"";
            }
            hf = hf + ",sans-serif";
        }
        return html.replace("{googleFontsLink}", gf.length() == 0 ? "" : "\t<link rel=\"stylesheet\" href=\"http://fonts.googleapis.com/css?family=" + gf.replaceAll(" ", "+") + "&display=swap\">\n").replace("{fontFamily}", ff).replace("{fontWeight}", fw.equals("") ? "300" : fw).replace("{boldWeight}", bw).replace("{headlineFont}", hf.equals("") ? "inherit" : hf).replace("{headlineWeight}", hw.equals("") ? "400" : hw);
    }

    private DateFormat getDateFormat() {
        return new SimpleDateFormat("yyyy-MMM-dd");
    }

    private String attemptSignIn() {
        SignInManager mgr = SignInManager.getInstance();
        if (mgr != null && mgr.isSignedIn()) {
            return "&cid=" + AccountManager.getCid((String)mgr.getUserName(), (String)mgr.getPassword());
        }
        return "";
    }

    private String getFileContents(String name) {
        StringBuilder cont = new StringBuilder();
        String nl = System.getProperty("line.separator");
        File f = new File(this.skinDirectory, name);
        if (f.exists()) {
            try (BufferedReader in = new BufferedReader(new FileReader(f));){
                String line;
                while ((line = in.readLine()) != null) {
                    cont.append(line);
                    cont.append(nl);
                }
            }
            catch (FileNotFoundException e) {
                return null;
            }
            catch (IOException e) {
                return null;
            }
        }
        return cont.toString();
    }

    private void writeFile(String fileName, String cont) {
        File out = new File(fileName);
        try {
            FileWriter writer = new FileWriter(out, false);
            writer.write(cont);
            writer.close();
        }
        catch (IOException e) {
            JAlbum.logger.log(Level.FINE, "Error writing \"{0}\".", fileName);
            e.printStackTrace();
        }
    }

    private Color toColor(JColorSelector cs) {
        return this.toColor(cs.toString());
    }

    private Color toColor(String c) {
        int a = 255;
        Color clr = Color.GRAY;
        if (c.charAt(0) == '#') {
            c = c.substring(1);
        }
        if (c.length() > 7) {
            a = Integer.parseInt(c.substring(0, 2), 16);
            c = c.substring(2);
        }
        if (c.length() == 3) {
            clr = new Color(Math.min(255, Integer.parseInt(c.substring(0, 1), 16) * 17), Math.min(255, Integer.parseInt(c.substring(1, 2), 16) * 17), Math.min(255, Integer.parseInt(c.substring(2), 16) * 17));
        }
        if (c.length() == 6) {
            clr = new Color(Math.min(255, Integer.parseInt(c.substring(0, 2), 16)), Math.min(255, Integer.parseInt(c.substring(2, 4), 16)), Math.min(255, Integer.parseInt(c.substring(4), 16)), a);
        }
        return clr;
    }

    private String getCssColor(JColorSelector cs) {
        return this.getCssColor(this.toColor(cs));
    }

    private String getCssColor(String c) {
        return this.getCssColor(this.toColor(c));
    }

    private String getCssColor(Color c) {
        if (c == null) {
            return "transparent";
        }
        Double a = (double)c.getAlpha() / 255.0;
        if (a < this.FULLY_TRANSP) {
            return "transparent";
        }
        if (a < this.FULLY_OPAQUE) {
            return "rgba(" + c.getRed() + "," + c.getGreen() + "," + c.getBlue() + "," + (double)Math.round(a * 1000.0) / 1000.0 + ")";
        }
        return "rgba(" + c.getRed() + "," + c.getGreen() + "," + c.getBlue() + ",1)";
    }

    private Double getAlpha(JColorSelector cs) {
        Color c = this.toColor(cs);
        return (double)c.getAlpha() / 255.0;
    }

    private Double getAlpha(String clr) {
        Color c = this.toColor(clr);
        return (double)c.getAlpha() / 255.0;
    }

    private String setAlpha(String clr, Double a) {
        Color c = this.toColor(clr);
        return "rgba(" + c.getRed() + "," + c.getGreen() + "," + c.getBlue() + "," + a + ")";
    }

    private Color flatColor(JColorSelector bc, JColorSelector fc) {
        return this.flatColor(this.toColor(bc), this.toColor(fc));
    }

    private Color flatColor(Color bc, Color fc) {
        Double a = (double)fc.getAlpha() / 255.0;
        if (a < this.FULLY_TRANSP) {
            return bc;
        }
        if (a > this.FULLY_OPAQUE) {
            return fc;
        }
        return new Color((int)Math.max(0L, Math.min(Math.round(a * (double)fc.getRed() + (1.0 - a) * (double)bc.getRed()), 255L)), (int)Math.max(0L, Math.min(Math.round(a * (double)fc.getGreen() + (1.0 - a) * (double)bc.getGreen()), 255L)), (int)Math.max(0L, Math.min(Math.round(a * (double)fc.getBlue() + (1.0 - a) * (double)bc.getBlue()), 255L)));
    }

    private String getFlatColor(JColorSelector bc, JColorSelector fc) {
        return this.getCssColor(this.flatColor(this.toColor(bc), this.toColor(fc)));
    }

    private String getFlatColor(String bc, String fc) {
        return this.getCssColor(this.flatColor(this.toColor(bc), this.toColor(fc)));
    }

    private String getFlatColor(Color bc, Color fc) {
        return this.getCssColor(this.flatColor(bc, fc));
    }

    private Double getLuminosity(JColorSelector bg, JColorSelector fg) {
        return this.getLuminosity(this.flatColor(bg, fg));
    }

    private Double getLuminosity(JColorSelector cs) {
        return this.getLuminosity(this.toColor(cs));
    }

    private Double getLuminosity(String c) {
        return this.getLuminosity(this.toColor(c));
    }

    private Double getLuminosity(Color c) {
        return 0.0011725490196078 * (double)c.getRed() + 0.0023019607843137 * (double)c.getGreen() + 4.470588235294118E-4 * (double)c.getBlue();
    }

    private boolean isLightColor(JColorSelector cs) {
        return this.getLuminosity(cs) > 0.5;
    }

    private boolean isLightColor(String fc) {
        return this.getLuminosity(fc) > 0.5;
    }

    private boolean isLightColor(JColorSelector fc, double threshold) {
        return this.getLuminosity(fc) > threshold;
    }

    private boolean isLightColor(String fc, double threshold) {
        return this.getLuminosity(fc) > threshold;
    }

    private boolean isLightColor(JColorSelector bc, JColorSelector fc) {
        return this.isLightColor(this.toColor(bc), this.toColor(fc), (Double)0.5);
    }

    private boolean isLightColor(String bc, String fc) {
        return this.isLightColor(this.toColor(bc), this.toColor(fc), (Double)0.5);
    }

    private boolean isLightColor(JColorSelector bc, JColorSelector fc, Double threshold) {
        return this.isLightColor(this.toColor(bc), this.toColor(fc), threshold);
    }

    private boolean isLightColor(String bc, String fc, Double threshold) {
        return this.isLightColor(this.toColor(bc), this.toColor(fc), threshold);
    }

    private boolean isLightColor(Color bc, Color fc, Double threshold) {
        Double a = (double)fc.getAlpha() / 255.0;
        if (a > this.FULLY_OPAQUE) {
            return this.getLuminosity(fc) >= threshold;
        }
        return this.getLuminosity(this.flatColor(bc, fc)) >= threshold;
    }

    private String getLegibleColor(Color bc1, Color bc2, Color fc, Double f) {
        Color bc = this.flatColor(bc1, bc2);
        return this.getLegibleColor(bc, fc, f);
    }

    private String getLegibleColor(JColorSelector bc, JColorSelector fc) {
        return this.getLegibleColor(this.toColor(bc), this.toColor(fc), (Double)0.6);
    }

    private String getLegibleColor(JColorSelector bc, JColorSelector fc, Double f) {
        return this.getLegibleColor(this.toColor(bc), this.toColor(fc), f);
    }

    private String getLegibleColor(JColorSelector bc1, JColorSelector bc2, JColorSelector fc) {
        return this.getLegibleColor(this.flatColor(bc1, bc2), this.toColor(fc), (Double)0.6);
    }

    private String getLegibleColor(JColorSelector bc1, JColorSelector bc2, JColorSelector fc, Double f) {
        return this.getLegibleColor(this.flatColor(bc1, bc2), this.toColor(fc), f);
    }

    private String getLegibleColor(Color bc, Color fc, Double f) {
        int b;
        int g;
        int r;
        if (Math.abs(this.getLuminosity(bc) - this.getLuminosity(fc)) >= f) {
            return this.getCssColor(fc);
        }
        f = f * 255.0;
        if (this.getLuminosity(bc) > 0.5) {
            r = (int)Math.round(Math.max((double)fc.getRed() - f, 0.0));
            g = (int)Math.round(Math.max((double)fc.getGreen() - f, 0.0));
            b = (int)Math.round(Math.max((double)fc.getBlue() - f, 0.0));
        } else {
            r = (int)Math.round(Math.min((double)fc.getRed() + f, 255.0));
            g = (int)Math.round(Math.min((double)fc.getGreen() + f, 255.0));
            b = (int)Math.round(Math.min((double)fc.getBlue() + f, 255.0));
        }
        return this.getCssColor(new Color(r, g, b));
    }

    private void getFileToRes(String[] extensions, JTextField name, Component c) {
        String fn;
        this.fc.setFileFilter((FileFilter)new FileNameExtensionFilter(this.getText("ui.select"), extensions));
        int returnVal = this.fc.showOpenDialog(c);
        if (returnVal == 0 && !(fn = this.fc.getSelectedFile().toString()).trim().equals("")) {
            File src = new File(fn);
            File dst = new File(this.context.getPluginContext().getRootFolder().getFile(), "res");
            if (!dst.exists()) {
                dst.mkdir();
            }
            if (src.exists() && dst.exists()) {
                try {
                    IO.copyFile((File)src, (File)dst);
                    name.setText(src.getName());
                }
                catch (IOException e) {
                    System.out.println(e);
                }
            }
        }
    }

    private void backupProjectFile(String ver) {
        try {
            File projectFile = this.window.projectChooser.getSelectedFile();
            IO.copyFile((File)projectFile, (File)new File(projectFile.getParentFile(), IO.baseName((File)projectFile) + "-" + (ver == null ? "old" : ver) + ".jap"));
        }
        catch (IOException ex) {
            JAlbum.logger.log(Level.FINE, "Error backing up project file: {0}", this.window.projectChooser.getSelectedFile());
        }
    }

    private static Icon icon(String basename) {
        return Icons.get(Lazaicon.class, (String)("svg/" + basename + ".svg"), (int)18);
    }

    private static Icon icon(String basename, int size) {
        return Icons.get(Lazaicon.class, (String)("svg/" + basename + ".svg"), (int)size);
    }

    private static Icon svgIcon(String basename, Dimension dim) {
        DeferredSVGIcon icon = new DeferredSVGIcon(Gui.class, "graphics/" + basename + ".svg");
        icon.setAntiAlias(true);
        icon.setAdaptColors(false);
        icon.setPreferredSize(dim);
        icon.setAutosize(4);
        return icon;
    }

    private Object[] getPosition() {
        return new Object[]{new Item((Object)"left top", (Object)this.getText("ui.left_top")), new Item((Object)"center top", (Object)this.getText("ui.center_top")), new Item((Object)"right top", (Object)this.getText("ui.right_top")), new Item((Object)"left center", (Object)this.getText("ui.left_middle")), new Item((Object)"center center", (Object)this.getText("ui.center_middle")), new Item((Object)"right center", (Object)this.getText("ui.right_middle")), new Item((Object)"left bottom", (Object)this.getText("ui.left_bottom")), new Item((Object)"center bottom", (Object)this.getText("ui.center_bottom")), new Item((Object)"right bottom", (Object)this.getText("ui.right_bottom"))};
    }

    private int setSelectedValue(JComboBox<Item> box, Object val) {
        int size = box.getItemCount();
        for (int i = 0; i < size; ++i) {
            Item it = box.getItemAt(i);
            if (!it.item.equals(val)) continue;
            box.setSelectedIndex(i);
            return i;
        }
        return -1;
    }

    private String getSelectedValue(Object o) {
        if (o instanceof JComboBox) {
            Object so = ((JComboBox)o).getSelectedItem();
            if (so instanceof Item) {
                return ((Item)so).value.toString();
            }
            return so == null ? null : so.toString();
        }
        return o == null ? null : o.toString();
    }

    private int getSpinnerValueAsInt(JSpinner o) {
        return (Integer)o.getValue();
    }

    private Double getSpinnerValueAsDouble(JSpinner o) {
        return (Double)o.getValue();
    }

    private Double getSelectedValueAsDouble(Object o) {
        if (o instanceof JComboBox) {
            Object so = ((JComboBox)o).getSelectedItem();
            if (so instanceof Item) {
                String s = ((Item)so).value.toString();
                return s != null && s.length() > 0 ? Double.valueOf(Double.parseDouble(s)) : null;
            }
            return null;
        }
        return o == null ? null : Double.valueOf(Double.parseDouble(o.toString()));
    }

    private Integer getSelectedValueAsInt(JComboBox o) {
        Object so = o.getSelectedItem();
        if (so instanceof Item) {
            return Integer.parseInt(((Item)so).value.toString());
        }
        return null;
    }

    private Double getThumbAspectRatio() {
        String[] cdim = this.engine.getThumbSize().split("x");
        Double w = Double.parseDouble(cdim[0]);
        Double h = Double.parseDouble(cdim[1]);
        if (w != null && h != null) {
            return w / h;
        }
        JAlbum.logger.log(Level.FINE, "Invalid thumbnail dimensions: {0} x {1}", new Object[]{w.toString(), h.toString()});
        return null;
    }

    private boolean isSynchingUI() {
        return new Date().getTime() - this.skinLoadedOn.getTime() < 2000L;
    }

    private void allowHTMLEditing(JSmartTextArea ta) {
        try {
            ((JSmartTextArea)ta.setAllowHTMLEditing(true)).setFullHTMLEditing(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void allowSpelling(JSmartTextArea ta) {
        try {
            ta.spelling();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private String majorVersion(String s) {
        int i = s.indexOf(".");
        if (i > 0) {
            return s.substring(0, i);
        }
        return s;
    }

    private int getMajorVersion(Object v) {
        if (v == null) {
            return -1;
        }
        if (v instanceof Integer) {
            return (Integer)v;
        }
        if (v instanceof String) {
            try {
                return Integer.valueOf((String)v);
            }
            catch (NumberFormatException ex) {
                return -1;
            }
        }
        if (v instanceof Double) {
            return (int)Math.floor((Double)v);
        }
        return -1;
    }

    public Gui() {
        this(JAlbumContext.getInstance());
    }

    public Gui(JAlbumContext context) {
        super(context);
        this.skinUi.setBorder(this.emptyBorder);
        ((RiverLayout)this.getLayout()).setVgap(0);
        ((RiverLayout)this.getLayout()).setHgap(0);
        this.window.pack();
        this.window.setSkinUI(this.skinUi);
        this.skinReady = true;
    }
}

