/*
 * Decompiled with CFR 0.152.
 */
package lucid;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.Map;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.JAFilter;
import se.datadosen.jalbum.ModifiesSize;

public class ConstrainRatioFilter
implements JAFilter,
ModifiesSize {
    private float xWeight = 0.5f;
    private float yWeight = 0.2f;
    private float minRatio = 0.5f;
    private float maxRatio = 2.0f;

    public ConstrainRatioFilter() {
    }

    public ConstrainRatioFilter(float minRatio, float maxRatio) {
        this.setMinRatio(minRatio);
        this.setMaxRatio(maxRatio);
    }

    public float getXWeight() {
        return this.xWeight;
    }

    public float getMinRatio() {
        return this.minRatio;
    }

    public float getMaxRatio() {
        return this.maxRatio;
    }

    public void setMinRatio(float minRatio) {
        this.minRatio = minRatio;
    }

    public void setMaxRatio(float maxRatio) {
        this.maxRatio = maxRatio;
    }

    public void setXWeight(float xWeight) {
        this.xWeight = xWeight;
    }

    public float getYWeight() {
        return this.yWeight;
    }

    public void setYWeight(float yWeight) {
        this.yWeight = yWeight;
    }

    public String getName() {
        return "Constrain ratio filter";
    }

    public String getDescription() {
        return "Constrains the aspect ratio of images to be within the specificd min- and max ratios";
    }

    public BufferedImage filter(BufferedImage bi, Map vars) {
        bi = this.doFilter(bi, vars);
        return bi;
    }

    private BufferedImage doFilter(BufferedImage bi, Map vars) {
        Dimension sDim = new Dimension(bi.getWidth(), bi.getHeight());
        Rectangle bounds = this.getBounds(sDim, vars);
        if (bounds.x != 0 || bounds.y != 0 || bounds.width != bi.getWidth() || bounds.height != bi.getHeight()) {
            return bi.getSubimage(bounds.x, bounds.y, bounds.width, bounds.height);
        }
        return bi;
    }

    private Rectangle getBounds(Dimension sDim, Map vars) {
        double dAspekt;
        double sAspekt;
        AlbumBean engine = (AlbumBean)vars.get("engine");
        int stage = vars.getOrDefault("stage", 4);
        float hw = this.xWeight;
        if (vars.containsKey("xWeight")) {
            Object xWeight = vars.get("xWeight");
            hw = xWeight instanceof Double ? ((Double)xWeight).floatValue() : Float.parseFloat((String)xWeight);
        }
        float vw = this.yWeight;
        if (vars.containsKey("yWeight")) {
            Object yWeight = vars.get("yWeight");
            float f = vw = yWeight instanceof Double ? ((Double)yWeight).floatValue() : Float.parseFloat((String)yWeight);
        }
        if ((sAspekt = (double)sDim.width / (double)sDim.height) > (dAspekt = Math.min((double)this.maxRatio, Math.max((double)this.minRatio, sAspekt)))) {
            int newWidth = (int)(dAspekt * (double)sDim.height);
            return new Rectangle((int)((float)(sDim.width - newWidth) * hw), 0, newWidth, sDim.height);
        }
        if (sAspekt < dAspekt) {
            int newHeight = (int)((double)sDim.width / dAspekt);
            return new Rectangle(0, (int)((float)(sDim.height - newHeight) * vw), sDim.width, newHeight);
        }
        return new Rectangle(0, 0, sDim.width, sDim.height);
    }

    public Dimension getModifiedSize(Dimension originalSize, Map vars) {
        return this.getBounds(originalSize, vars).getSize();
    }
}

