/*
 * Decompiled with CFR 0.152.
 */
package it.sauronsoftware.ftp4j.listparsers;

import it.sauronsoftware.ftp4j.FTPFile;
import it.sauronsoftware.ftp4j.FTPListParseException;
import it.sauronsoftware.ftp4j.FTPListParser;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import java.util.StringTokenizer;

public class MLSDListParser
implements FTPListParser {
    private static final DateFormat MLSD_DATE_FORMAT_1 = new SimpleDateFormat("yyyyMMddhhmmss.SSS Z");
    private static final DateFormat MLSD_DATE_FORMAT_2 = new SimpleDateFormat("yyyyMMddhhmmss Z");

    @Override
    public FTPFile[] parse(String[] lines) throws FTPListParseException {
        ArrayList<FTPFile> list = new ArrayList<FTPFile>();
        for (int i = 0; i < lines.length; ++i) {
            FTPFile file = this.parseLine(lines[i]);
            if (file == null) continue;
            list.add(file);
        }
        int size = list.size();
        FTPFile[] ret = new FTPFile[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = (FTPFile)list.get(i);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FTPFile parseLine(String line) throws FTPListParseException {
        int type;
        Object value;
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(line, ";");
        while (st.hasMoreElements()) {
            String aux = st.nextToken().trim();
            if (aux.length() <= 0) continue;
            list.add(aux);
        }
        if (list.size() == 0) {
            throw new FTPListParseException();
        }
        String name = (String)list.remove(list.size() - 1);
        Properties facts = new Properties();
        for (String aux : list) {
            int sep = aux.indexOf(61);
            if (sep == -1) {
                throw new FTPListParseException();
            }
            String key = aux.substring(0, sep).trim();
            value = aux.substring(sep + 1, aux.length()).trim();
            if (key.length() == 0 || ((String)value).length() == 0) {
                throw new FTPListParseException();
            }
            facts.setProperty(key, (String)value);
        }
        String typeString = facts.getProperty("type");
        if (typeString == null) {
            throw new FTPListParseException();
        }
        if ("file".equalsIgnoreCase(typeString)) {
            type = 0;
        } else if ("dir".equalsIgnoreCase(typeString)) {
            type = 1;
        } else {
            if ("cdir".equalsIgnoreCase(typeString)) {
                return null;
            }
            if ("pdir".equalsIgnoreCase(typeString)) {
                return null;
            }
            return null;
        }
        Date modifiedDate = null;
        String modifyString = facts.getProperty("modify");
        if (modifyString != null) {
            modifyString = modifyString + " +0000";
            try {
                value = MLSD_DATE_FORMAT_1;
                synchronized (value) {
                    modifiedDate = MLSD_DATE_FORMAT_1.parse(modifyString);
                }
            }
            catch (ParseException e1) {
                try {
                    DateFormat dateFormat = MLSD_DATE_FORMAT_2;
                    synchronized (dateFormat) {
                        modifiedDate = MLSD_DATE_FORMAT_2.parse(modifyString);
                    }
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
        long size = 0L;
        String sizeString = facts.getProperty("size");
        if (sizeString != null) {
            try {
                size = Long.parseLong(sizeString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (size < 0L) {
                size = 0L;
            }
        }
        FTPFile ret = new FTPFile();
        ret.setType(type);
        ret.setModifiedDate(modifiedDate);
        ret.setSize(size);
        ret.setName(name);
        return ret;
    }
}

