/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.util;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import net.jalbum.util.Replacer;
import net.jalbum.util.StringCodec;

public class MiniIO {
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final int BUFSIZE = 262144;
    private static final Pattern backslashPattern = Pattern.compile("\\\\\\\\", 2);

    public static String readTextFile(File file, String encoding) throws IOException, NoSuchFileException {
        byte[] buf = MiniIO.readBytes(file);
        StringCodec codec = new StringCodec();
        return codec.decode(buf, encoding);
    }

    public static String readTextFile(File file) throws IOException, NoSuchFileException {
        return MiniIO.readTextFile(file, System.getProperty("jalbum.file.encoding"));
    }

    public static String readTextFile(String fileName) throws IOException, NoSuchFileException {
        return MiniIO.readTextFile(new File(fileName));
    }

    public static byte[] readBytes(File f) throws IOException, NoSuchFileException {
        return Files.readAllBytes(f.toPath());
    }

    public static void writeBytes(byte[] buf, File f) throws IOException {
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(f));){
            ((OutputStream)out).write(buf);
        }
    }

    public static void writeTextFile(String content, File file) throws IOException {
        MiniIO.writeTextFile(content, file, System.getProperty("jalbum.file.encoding"));
    }

    public static void writeTextFile(String content, File file, String encoding) throws IOException {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding);){
            writer.write(content);
        }
    }

    public static Map readMapFile(File file) throws IOException {
        return MiniIO.readMapFile(file, false);
    }

    public static Map<String, Object> readMapFile(File file, boolean maintainOrdering) throws IOException {
        return MiniIO.readMap(MiniIO.readBytes(file), maintainOrdering);
    }

    public static Map readMap(byte[] bytes) throws IOException {
        return MiniIO.readMap(bytes, false);
    }

    public static Map<String, Object> readMap(byte[] bytes, boolean maintainOrdering) throws IOException {
        StringCodec codec = new StringCodec();
        String s = codec.decode(bytes, System.getProperty("jalbum.file.encoding"));
        try (BufferedReader in = new BufferedReader(new StringReader(s));){
            String line;
            LinkedHashMap<String, Object> theMap;
            HashMap hashMap = theMap = maintainOrdering ? new LinkedHashMap() : new HashMap();
            while ((line = in.readLine()) != null) {
                int equalsIndex;
                if ((line = line.trim()).startsWith("#") || (equalsIndex = line.indexOf(61)) == -1) continue;
                String key = line.substring(0, equalsIndex).trim();
                String value = line.substring(equalsIndex + 1).trim();
                if (MiniIO.continueLine(line)) {
                    line = value;
                    StringBuilder sb = new StringBuilder();
                    do {
                        sb.append(line, 0, line.length() - 1);
                        line = in.readLine();
                        if (line == null) break;
                        sb.append('\n');
                    } while (MiniIO.continueLine(line));
                    if (line != null) {
                        sb.append(line);
                    }
                    value = sb.toString();
                }
                value = backslashPattern.matcher(value).replaceAll("\\\\");
                theMap.put(key, value);
            }
            LinkedHashMap<String, Object> linkedHashMap = theMap;
            return linkedHashMap;
        }
    }

    public static void writeMapFile(Map map, File f) throws IOException {
        byte[] bytes;
        StringCodec codec;
        Replacer backslashEncoder = new Replacer();
        backslashEncoder.add("\\", "\\\\");
        backslashEncoder.add("\n", "\\" + System.getProperty("line.separator"));
        StringWriter writer = new StringWriter();
        try (PrintWriter out = new PrintWriter(writer);){
            for (Map.Entry e : map.entrySet()) {
                out.println(e.getKey().toString() + "=" + backslashEncoder.replace(e.getValue().toString()));
            }
        }
        String s = writer.getBuffer().toString();
        if (!s.equals((codec = new StringCodec()).decode(bytes = codec.encode(s)))) {
            bytes = codec.encode(s, "UTF-8");
        }
        MiniIO.writeBytes(bytes, f);
    }

    private static boolean continueLine(String line) {
        int slashCount = 0;
        int index = line.length() - 1;
        while (index >= 0 && line.charAt(index--) == '\\') {
            ++slashCount;
        }
        return slashCount % 2 == 1;
    }

    public static String urlEncode(String s) {
        StringBuilder sb = new StringBuilder();
        try {
            byte[] bytes = s.getBytes("UTF-8");
            s = new String(bytes, "8859_1");
        }
        catch (UnsupportedEncodingException bytes) {
            // empty catch block
        }
        char[] chars = s.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] > '\u007f') {
                sb.append('%');
                sb.append(hexDigits[(chars[i] & 0xF0) >> 4]);
                sb.append(hexDigits[chars[i] & 0xF]);
                continue;
            }
            sb.append(chars[i]);
        }
        return sb.toString();
    }

    public static String readAll(Reader in) throws IOException {
        int bytesRead;
        char[] buffer = new char[262144];
        StringBuilder sb = new StringBuilder();
        while ((bytesRead = in.read(buffer)) != -1) {
            sb.append(buffer, 0, bytesRead);
        }
        return sb.toString();
    }
}

